/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.WirelessUtils;
import mods.eln.sixnode.wirelesssignal.aggregator.BiggerAggregator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class WirelessSignalAnalyserItemDescriptor
extends GenericItemUsingDamageDescriptor {
    public WirelessSignalAnalyserItemDescriptor(String name) {
        super(name);
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float vx, float vy, float vz) {
        if (world.field_72995_K) {
            return true;
        }
        Utils.addChatMessage(player, "-------------------");
        Direction dir = Direction.fromIntMinecraftSide(side);
        Coordinate c = new Coordinate(x, y, z, world);
        c.move(dir);
        WirelessUtils.WirelessSignalSpot spot = WirelessUtils.buildSpot(c, null, 0);
        HashMap<String, HashSet<IWirelessSignalTx>> txSet = new HashMap<String, HashSet<IWirelessSignalTx>>();
        HashMap<IWirelessSignalTx, Double> txStrength = new HashMap<IWirelessSignalTx, Double>();
        WirelessUtils.getTx(spot, txSet, txStrength);
        BiggerAggregator aggregator = new BiggerAggregator();
        for (Map.Entry<String, HashSet<IWirelessSignalTx>> entrySet : txSet.entrySet()) {
            HashSet<IWirelessSignalTx> set = entrySet.getValue();
            double strength = 100000.0;
            for (IWirelessSignalTx oneTx : set) {
                double temp = txStrength.get(oneTx);
                if (!(temp < strength)) continue;
                strength = temp;
            }
            Utils.addChatMessage(player, entrySet.getKey() + " Strength=" + String.format("%2.1f", strength) + " Value=" + String.format("%3.0f", aggregator.aggregate(set) * 100.0) + "%");
        }
        if (txSet.isEmpty()) {
            Utils.addChatMessage(player, "No wireless signal in area!");
        }
        return true;
    }
}

