/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.rx;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.wirelesssignal.aggregator.BiggerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.IWirelessSignalAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.SmallerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.ToogleAggregator;
import mods.eln.sixnode.wirelesssignal.rx.WirelessSignalRxDescriptor;
import mods.eln.sixnode.wirelesssignal.rx.WirelessSignalRxProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class WirelessSignalRxElement
extends SixNodeElement
implements IConfigurable {
    NbtElectricalGateOutput outputGate = new NbtElectricalGateOutput("outputGate");
    NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public String channel = "Default channel";
    WirelessSignalRxProcess slowProcess = new WirelessSignalRxProcess(this);
    WirelessSignalRxDescriptor descriptor;
    ToogleAggregator toogleAggregator;
    boolean connection = false;
    public static final byte setChannelId = 1;
    public static final byte setSelectedAggregator = 2;
    IWirelessSignalAggregator[] aggregators;
    int selectedAggregator = 0;

    public WirelessSignalRxElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (WirelessSignalRxDescriptor)descriptor;
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.electricalProcessList.add(this.slowProcess);
        this.aggregators = new IWirelessSignalAggregator[3];
        this.aggregators[0] = new BiggerAggregator();
        this.aggregators[1] = new SmallerAggregator();
        this.toogleAggregator = new ToogleAggregator();
        this.aggregators[2] = this.toogleAggregator;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return this.outputGate.plot("Output gate");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Channel", new Object[0]), (this.connection ? "\u00a7a" : "\u00a7c") + this.channel);
        info.put(I18N.tr("Output voltage", new Object[0]), Utils.plotVolt("", this.outputGate.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
    }

    void setConnection(boolean connection) {
        if (connection != this.connection) {
            this.connection = connection;
            this.needPublish();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("channel", this.channel);
        nbt.func_74757_a("connection", this.connection);
        nbt.func_74768_a("selectedAggregator", this.selectedAggregator);
        this.toogleAggregator.writeToNBT(nbt, "toogleAggregator");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.channel = nbt.func_74779_i("channel");
        this.connection = nbt.func_74767_n("connection");
        this.selectedAggregator = nbt.func_74762_e("selectedAggregator");
        this.toogleAggregator.readFromNBT(nbt, "toogleAggregator");
    }

    @Override
    public Coordinate getCoordinate() {
        return this.sixNode.coordinate;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.channel = stream.readUTF();
                    this.slowProcess.sleepTimer = 0.0;
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.selectedAggregator = stream.readByte();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.channel);
            stream.writeBoolean(this.connection);
            stream.writeByte(this.selectedAggregator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IWirelessSignalAggregator getAggregator() {
        if (this.selectedAggregator >= 0 && this.selectedAggregator < this.aggregators.length) {
            return this.aggregators[this.selectedAggregator];
        }
        return null;
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        String newChannel;
        if (compound.func_74764_b("wirelessChannels") && (newChannel = compound.func_150295_c("wirelessChannels", 8).func_150307_f(0)) != null && newChannel != "") {
            this.channel = newChannel;
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString(this.channel));
        compound.func_74782_a("wirelessChannels", (NBTBase)list);
    }
}

