/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.source;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceRenderObj;
import mods.eln.sixnode.wirelesssignal.source.WirelessSignalSourceElement;
import mods.eln.sixnode.wirelesssignal.source.WirelessSignalSourceRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WirelessSignalSourceDescriptor
extends SixNodeDescriptor {
    int range;
    public boolean autoReset;
    ElectricalGateSourceRenderObj render;

    public WirelessSignalSourceDescriptor(String name, ElectricalGateSourceRenderObj render, int range, boolean autoReset) {
        super(name, WirelessSignalSourceElement.class, WirelessSignalSourceRender.class);
        this.range = range;
        this.autoReset = autoReset;
        this.render = render;
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.autoReset) {
            Collections.addAll(list, I18N.tr("Acts like a\npush button.", new Object[0]).split("\n"));
        } else {
            Collections.addAll(list, I18N.tr("Acts like a\ntoggle switch.", new Object[0]).split("\n"));
        }
    }

    void draw(float factor, float distance, TileEntity e) {
        this.render.draw(factor, distance, e);
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            this.draw(0.0f, 1.0f, null);
        }
    }

    @Override
    public RealisticEnum addRealismContext(List<String> list) {
        super.addRealismContext(list);
        list.add(I18N.tr("It should require power to transmit realistically", new Object[0]));
        return RealisticEnum.IDEAL;
    }
}

