/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.source;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.source.WirelessSignalSourceDescriptor;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxElement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class WirelessSignalSourceElement
extends SixNodeElement
implements IWirelessSignalTx,
IConfigurable {
    public static final HashMap<String, ArrayList<IWirelessSignalTx>> channelMap = new HashMap();
    WirelessSignalSourceDescriptor descriptor;
    public AutoResetProcess autoResetProcess;
    boolean state = false;
    public String channel = "Default channel";
    private WirelessSignalTxElement.LightningGlitchProcess lightningGlitchProcess;
    public static final byte setChannelId = 1;

    public WirelessSignalSourceElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (WirelessSignalSourceDescriptor)descriptor;
        WirelessSignalTxElement.channelRegister(this);
        this.lightningGlitchProcess = new WirelessSignalTxElement.LightningGlitchProcess(this.getCoordinate());
        this.slowProcessList.add(this.lightningGlitchProcess);
        if (this.descriptor.autoReset) {
            this.autoResetProcess = new AutoResetProcess();
            this.slowProcessList.add(this.autoResetProcess);
            this.autoResetProcess.reset();
        }
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        return 0;
    }

    @Override
    public String multiMeterString() {
        return null;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Channel", new Object[0]), this.channel);
        if (!this.descriptor.autoReset) {
            if (this.state) {
                info.put(I18N.tr("State", new Object[0]), "\u00a7a" + I18N.tr("On", new Object[0]));
            } else {
                info.put(I18N.tr("State", new Object[0]), "\u00a7c" + I18N.tr("Off", new Object[0]));
            }
        }
        return info;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            return false;
        }
        boolean bl = this.state = !this.state;
        if (this.state && this.autoResetProcess != null) {
            this.autoResetProcess.reset();
        }
        this.needPublish();
        return true;
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        WirelessSignalTxElement.channelRemove(this);
        super.destroy(entityPlayer);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("channel", this.channel);
        nbt.func_74757_a("state", this.state);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        WirelessSignalTxElement.channelRemove(this);
        super.readFromNBT(nbt);
        this.channel = nbt.func_74779_i("channel");
        this.state = nbt.func_74767_n("state");
        WirelessSignalTxElement.channelRegister(this);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.sixNode.coordinate;
    }

    @Override
    public int getRange() {
        return this.descriptor.range;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public double getValue() {
        return (this.state ? 1.0 : 0.0) + this.lightningGlitchProcess.glitchOffset;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    WirelessSignalTxElement.channelRemove(this);
                    this.channel = stream.readUTF();
                    this.needPublish();
                    WirelessSignalTxElement.channelRegister(this);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.channel);
            stream.writeBoolean(this.state);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        String newChannel;
        if (compound.func_74764_b("wirelessChannels") && (newChannel = compound.func_150295_c("wirelessChannels", 8).func_150307_f(0)) != null && newChannel != "") {
            WirelessSignalTxElement.channelRemove(this);
            this.channel = newChannel;
            WirelessSignalTxElement.channelRegister(this);
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString(this.channel));
        compound.func_74782_a("wirelessChannels", (NBTBase)list);
    }

    class AutoResetProcess
    implements IProcess {
        double timeout = 0.0;
        double timeoutDelay = 0.21;

        AutoResetProcess() {
        }

        @Override
        public void process(double time) {
            if (this.timeout > 0.0) {
                if (this.timeout - time < 0.0 && WirelessSignalSourceElement.this.state) {
                    WirelessSignalSourceElement.this.state = false;
                    WirelessSignalSourceElement.this.needPublish();
                }
                this.timeout -= time;
            }
        }

        void reset() {
            this.timeout = this.timeoutDelay;
        }
    }
}

