/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.tx;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxElement;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WirelessSignalTxDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    Obj3D.Obj3DPart main;
    int range;

    public WirelessSignalTxDescriptor(String name, Obj3D obj, int range) {
        super(name, WirelessSignalTxElement.class, WirelessSignalTxRender.class);
        this.range = range;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    public void draw() {
        if (this.main != null) {
            this.main.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glScalef((float)2.8f, (float)2.8f, (float)2.8f);
            }
            this.draw();
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Sends signal voltage on selected wireless signal channel", new Object[0]));
    }

    @Override
    public RealisticEnum addRealismContext(List<String> list) {
        super.addRealismContext(list);
        list.add(I18N.tr("It should require power to transmit realistically", new Object[0]));
        return RealisticEnum.IDEAL;
    }
}

