/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.wirelesssignal.tx;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class WirelessSignalTxElement
extends SixNodeElement
implements IWirelessSignalTx,
IConfigurable {
    public static final HashMap<String, ArrayList<IWirelessSignalTx>> channelMap = new HashMap();
    NbtElectricalGateInput inputGate = new NbtElectricalGateInput("inputGate");
    WirelessSignalTxDescriptor descriptor;
    public String channel = "Default channel";
    private LightningGlitchProcess lightningGlitchProcess;
    public static final byte setChannelId = 1;

    public WirelessSignalTxElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.inputGate);
        this.lightningGlitchProcess = new LightningGlitchProcess(this.getCoordinate());
        this.slowProcessList.add(this.lightningGlitchProcess);
        this.descriptor = (WirelessSignalTxDescriptor)descriptor;
        WirelessSignalTxElement.channelRegister(this);
    }

    public static void channelRegister(IWirelessSignalTx tx) {
        String channel = tx.getChannel();
        ArrayList<IWirelessSignalTx> list = channelMap.get(channel);
        if (list == null) {
            list = new ArrayList();
            channelMap.put(channel, list);
        }
        list.add(tx);
    }

    public static void channelRemove(IWirelessSignalTx tx) {
        String channel = tx.getChannel();
        ArrayList<IWirelessSignalTx> list = channelMap.get(channel);
        if (list == null) {
            return;
        }
        list.remove(tx);
        if (list.isEmpty()) {
            channelMap.remove(channel);
        }
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.inputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return this.inputGate.plot("Input gate");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Channel", new Object[0]), this.channel);
        info.put(I18N.tr("Input voltage", new Object[0]), Utils.plotVolt("", this.inputGate.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        this.unregister();
        super.destroy(entityPlayer);
    }

    @Override
    public void unload() {
        super.unload();
        this.unregister();
    }

    void unregister() {
        WirelessSignalTxElement.channelRemove(this);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("channel", this.channel);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        WirelessSignalTxElement.channelRemove(this);
        super.readFromNBT(nbt);
        this.channel = nbt.func_74779_i("channel");
        WirelessSignalTxElement.channelRegister(this);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.sixNode.coordinate;
    }

    @Override
    public int getRange() {
        return this.descriptor.range;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public double getValue() {
        return this.inputGate.getNormalized() + this.lightningGlitchProcess.glitchOffset;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    WirelessSignalTxElement.channelRemove(this);
                    this.channel = stream.readUTF();
                    this.needPublish();
                    WirelessSignalTxElement.channelRegister(this);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.channel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        String newChannel;
        if (compound.func_74764_b("wirelessChannels") && (newChannel = compound.func_150295_c("wirelessChannels", 8).func_150307_f(0)) != null && newChannel != "") {
            WirelessSignalTxElement.channelRemove(this);
            this.channel = newChannel;
            WirelessSignalTxElement.channelRegister(this);
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString(this.channel));
        compound.func_74782_a("wirelessChannels", (NBTBase)list);
    }

    public static class LightningGlitchProcess
    implements IProcess {
        double range = 64.0;
        Coordinate c;
        double glichedTimer = 0.0;
        double glichedStrangth = 0.0;
        final double glitchLength = 6.0;
        public double glitchOffset = 0.0;

        public LightningGlitchProcess(Coordinate c) {
            this.c = c;
        }

        @Override
        public void process(double time) {
            double strangth;
            if (this.glichedTimer > 0.0) {
                this.glichedTimer -= time;
            }
            if ((strangth = this.range - Eln.instance.serverEventListener.getLightningClosestTo(this.c)) > 0.0 && this.glichedTimer <= 0.0) {
                this.glichedTimer = 6.0;
                this.glichedStrangth = strangth / this.range;
                this.glichedStrangth = Math.pow(this.glichedStrangth, 1.4);
            }
            if (this.glichedTimer > 0.0) {
                double phase = 6.0 - this.glichedTimer;
                this.glitchOffset = Math.sin(phase * Math.PI * 2.0 * 3.0) * this.glichedStrangth * Math.pow(this.glichedTimer / 6.0, 4.0);
            } else {
                this.glitchOffset = 0.0;
            }
        }
    }
}

