/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sound;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.misc.Coordinate;
import mods.eln.sound.SoundClient;
import mods.eln.sound.SoundServer;
import mods.eln.sound.SoundTrack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SoundCommand {
    World world;
    double x;
    double y;
    double z;
    String track;
    double trackLength;
    float volume = 1.0f;
    float pitch = 1.0f;
    float rangeNominal;
    float rangeMax;
    float blockFactor;
    ArrayList<Integer> uuid = new ArrayList();

    public SoundCommand() {
        this.mediumRange();
    }

    public SoundCommand(String track) {
        this.track = track;
        this.mediumRange();
    }

    public SoundCommand(String track, double trackLength) {
        this.track = track;
        this.trackLength = trackLength;
        this.mediumRange();
    }

    public SoundCommand(SoundTrack s) {
        this.track = s.track;
        this.volume = s.volume;
        this.pitch = s.pitch;
        this.rangeNominal = s.rangeNominal;
        this.rangeMax = s.rangeMax;
        this.blockFactor = s.blockFactor;
        this.uuid = (ArrayList)s.uuid.clone();
    }

    public SoundCommand copy() {
        SoundCommand c = new SoundCommand();
        c.world = this.world;
        c.x = this.x;
        c.y = this.y;
        c.z = this.z;
        c.track = this.track;
        c.trackLength = this.trackLength;
        c.volume = this.volume;
        c.pitch = this.pitch;
        c.rangeNominal = this.rangeNominal;
        c.rangeMax = this.rangeMax;
        c.blockFactor = this.blockFactor;
        c.uuid = (ArrayList)this.uuid.clone();
        return c;
    }

    public void play() {
        if (this.world.field_72995_K) {
            SoundClient.play(this);
        } else {
            SoundServer.play(this);
        }
    }

    public SoundCommand set(Coordinate c) {
        this.world = c.world();
        this.x = (double)c.x + 0.5;
        this.y = (double)c.y + 0.5;
        this.z = (double)c.z + 0.5;
        return this;
    }

    public SoundCommand set(TileEntity c) {
        this.world = c.func_145831_w();
        this.x = (double)c.field_145851_c + 0.5;
        this.y = (double)c.field_145848_d + 0.5;
        this.z = (double)c.field_145849_e + 0.5;
        return this;
    }

    public SoundCommand set(double x, double y, double z, World w) {
        this.world = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    void applyRange(Range range) {
        switch (range) {
            case Small: {
                this.smallRange();
                break;
            }
            case Far: {
                this.longRange();
                break;
            }
            default: {
                this.mediumRange();
            }
        }
    }

    public SoundCommand mediumRange() {
        this.rangeNominal = 4.0f;
        this.rangeMax = 16.0f;
        this.blockFactor = 1.0f;
        return this;
    }

    public SoundCommand smallRange() {
        this.rangeNominal = 2.0f;
        this.rangeMax = 8.0f;
        this.blockFactor = 3.0f;
        return this;
    }

    public SoundCommand verySmallRange() {
        this.rangeNominal = 2.0f;
        this.rangeMax = 4.0f;
        this.blockFactor = 10.0f;
        return this;
    }

    public SoundCommand longRange() {
        this.rangeNominal = 8.0f;
        this.rangeMax = 48.0f;
        this.blockFactor = 0.3f;
        return this;
    }

    public SoundCommand mulVolume(float volume, float pitch) {
        this.volume *= volume;
        this.pitch *= pitch;
        return this;
    }

    public SoundCommand addUuid(int uuid) {
        this.uuid.add(uuid);
        return this;
    }

    public static SoundCommand fromStream(DataInputStream stream, World w) throws IOException {
        SoundCommand p = new SoundCommand();
        p.world = w;
        p.x = (double)stream.readInt() / 8.0;
        p.y = (double)stream.readInt() / 8.0;
        p.z = (double)stream.readInt() / 8.0;
        p.track = stream.readUTF();
        p.volume = stream.readFloat();
        p.pitch = stream.readFloat();
        p.rangeNominal = stream.readFloat();
        p.rangeMax = stream.readFloat();
        p.blockFactor = stream.readFloat();
        p.uuid = new ArrayList();
        for (int idx = stream.readByte(); idx != 0; --idx) {
            p.addUuid(stream.readInt());
        }
        return p;
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        stream.writeInt((int)(this.x * 8.0));
        stream.writeInt((int)(this.y * 8.0));
        stream.writeInt((int)(this.z * 8.0));
        stream.writeUTF(this.track);
        stream.writeFloat(this.volume);
        stream.writeFloat(this.pitch);
        stream.writeFloat(this.rangeNominal);
        stream.writeFloat(this.rangeMax);
        stream.writeFloat(this.blockFactor);
        stream.writeByte(this.uuid.size());
        for (Integer i : this.uuid) {
            stream.writeInt(i);
        }
    }

    public SoundCommand mulVolume(double volume) {
        this.volume = (float)((double)this.volume * volume);
        return this;
    }

    public SoundCommand applyNominalVolume(double nominalVolume) {
        this.mulVolume(nominalVolume);
        return this;
    }

    public SoundCommand mulBlockAttenuation(double factor) {
        this.blockFactor = (float)((double)this.blockFactor * factor);
        return this;
    }

    static enum Range {
        Small,
        Mid,
        Far;

    }
}

