/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sound;

import java.util.ArrayList;

public class SoundTrack {
    String track;
    double trackLength;
    float volume = 1.0f;
    float pitch = 1.0f;
    float rangeNominal;
    float rangeMax;
    float blockFactor;
    ArrayList<Integer> uuid = new ArrayList();

    public SoundTrack() {
    }

    public SoundTrack(String track) {
        this.track = track;
        this.mediumRange();
    }

    public SoundTrack(String track, double trackLength) {
        this.track = track;
        this.trackLength = trackLength;
        this.mediumRange();
    }

    public SoundTrack copy() {
        SoundTrack c = new SoundTrack();
        c.track = this.track;
        c.trackLength = this.trackLength;
        c.volume = this.volume;
        c.pitch = this.pitch;
        c.rangeNominal = this.rangeNominal;
        c.rangeMax = this.rangeMax;
        c.blockFactor = this.blockFactor;
        c.uuid = (ArrayList)this.uuid.clone();
        return c;
    }

    void applyRange(Range range) {
        switch (range) {
            case Small: {
                this.smallRange();
                break;
            }
            case Far: {
                this.longRange();
                break;
            }
            default: {
                this.mediumRange();
            }
        }
    }

    public SoundTrack mediumRange() {
        this.rangeNominal = 4.0f;
        this.rangeMax = 16.0f;
        this.blockFactor = 1.0f;
        return this;
    }

    public SoundTrack smallRange() {
        this.rangeNominal = 2.0f;
        this.rangeMax = 8.0f;
        this.blockFactor = 3.0f;
        return this;
    }

    public SoundTrack longRange() {
        this.rangeNominal = 8.0f;
        this.rangeMax = 48.0f;
        this.blockFactor = 0.5f;
        return this;
    }

    public SoundTrack setVolume(float volume, float pitch) {
        this.volume = volume;
        this.pitch = pitch;
        return this;
    }

    public SoundTrack addUuid(int uuid) {
        this.uuid.add(uuid);
        return this;
    }

    static enum Range {
        Small,
        Mid,
        Far;

    }
}

