/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.ArcFurnaceContainer;
import mods.eln.transparentnode.ArcFurnaceDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lmods/eln/transparentnode/ArcFurnaceElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "adesc", "Lmods/eln/transparentnode/ArcFurnaceDescriptor;", "getAdesc", "()Lmods/eln/transparentnode/ArcFurnaceDescriptor;", "setAdesc", "(Lmods/eln/transparentnode/ArcFurnaceDescriptor;)V", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "electricalResistor", "Lmods/eln/sim/mna/component/Resistor;", "getElectricalResistor", "()Lmods/eln/sim/mna/component/Resistor;", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInventory", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "voltageWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "hasGui", "", "initialize", "", "multiMeterString", "", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "Eln"})
public final class ArcFurnaceElement
extends TransparentNodeElement {
    @Nullable
    private ArcFurnaceDescriptor adesc;
    @NotNull
    private final TransparentNodeElementInventory inventory;
    @NotNull
    private final NbtElectricalLoad electricalLoad;
    @NotNull
    private final Resistor electricalResistor;
    @NotNull
    private final VoltageStateWatchDog voltageWatchdog;

    public ArcFurnaceElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(node, descriptor);
        this.adesc = (ArcFurnaceDescriptor)descriptor;
        this.inventory = new TransparentNodeElementInventory(5, 1, this);
        this.electricalLoad = new NbtElectricalLoad("electricalLoad");
        this.electricalResistor = new Resistor(this.electricalLoad, null);
        this.voltageWatchdog = new VoltageStateWatchDog(this.electricalLoad);
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.electricalResistor);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.setNominalVoltage(800.0).setDestroys(exp));
    }

    @Nullable
    public final ArcFurnaceDescriptor getAdesc() {
        return this.adesc;
    }

    public final void setAdesc(@Nullable ArcFurnaceDescriptor arcFurnaceDescriptor) {
        this.adesc = arcFurnaceDescriptor;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final Resistor getElectricalResistor() {
        return this.electricalResistor;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotUIP(this.electricalLoad.getVoltage(), this.electricalLoad.getCurrent());
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.electricalLoad;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return 0;
        }
        return 1;
    }

    @Override
    public void initialize() {
        this.connect();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @NotNull
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new ArcFurnaceContainer(this.node, player, (IInventory)this.getInventory());
    }
}

