/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.FerromagneticCoreDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.TransformerInterSystemProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.DcDcContainer;
import mods.eln.transparentnode.DcDcProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0016J\b\u00107\u001a\u000205H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u001a\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0014\u0010D\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020F0EH\u0016J\b\u0010G\u001a\u00020\u0011H\u0016J\b\u0010H\u001a\u000205H\u0016J\u0012\u0010I\u001a\u0002052\b\u0010\f\u001a\u0004\u0018\u00010JH\u0016J\u0010\u0010K\u001a\u00020F2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010L\u001a\u0002052\u0006\u0010M\u001a\u00020NH\u0016J\u001a\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010:\u001a\u00020;2\u0006\u0010Q\u001a\u00020RH\u0016J0\u0010S\u001a\u00020\u00112\u0006\u0010Q\u001a\u00020R2\u0006\u0010:\u001a\u00020;2\u0006\u0010T\u001a\u00020A2\u0006\u0010U\u001a\u00020A2\u0006\u0010V\u001a\u00020AH\u0016J\b\u0010W\u001a\u000205H\u0016J\u0018\u0010X\u001a\u0002052\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020RH\u0016J\u0018\u0010\\\u001a\u0002052\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020RH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001d\"\u0004\b*\u0010\u001fR\u0011\u0010+\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0019R\u001a\u0010-\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001d\"\u0004\b/\u0010\u001fR\u0011\u00100\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010#R\u0011\u00102\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010'\u00a8\u0006]"}, d2={"Lmods/eln/transparentnode/DcDcElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "Lmods/eln/item/IConfigurable;", "transparentNode", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "interSystemProcess", "Lmods/eln/sim/mna/process/TransformerInterSystemProcess;", "getInterSystemProcess", "()Lmods/eln/sim/mna/process/TransformerInterSystemProcess;", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInventory", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "populated", "", "getPopulated", "()Z", "setPopulated", "(Z)V", "primaryLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getPrimaryLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "primaryMaxCurrent", "", "getPrimaryMaxCurrent", "()D", "setPrimaryMaxCurrent", "(D)V", "primaryVoltageSource", "Lmods/eln/sim/mna/component/VoltageSource;", "getPrimaryVoltageSource", "()Lmods/eln/sim/mna/component/VoltageSource;", "primaryVoltageWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getPrimaryVoltageWatchdog", "()Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "ratioControl", "getRatioControl", "setRatioControl", "secondaryLoad", "getSecondaryLoad", "secondaryMaxCurrent", "getSecondaryMaxCurrent", "setSecondaryMaxCurrent", "secondaryVoltageSource", "getSecondaryVoltageSource", "secondaryVoltageWatchdog", "getSecondaryVoltageWatchdog", "computeInventory", "", "connectJob", "disconnectJob", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getLightOpacity", "", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "initialize", "inventoryChange", "Lnet/minecraft/inventory/IInventory;", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "vx", "vy", "vz", "onGroundedChangedByClient", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "writeConfigTool", "Eln"})
public final class DcDcElement
extends TransparentNodeElement
implements IConfigurable {
    @NotNull
    private final NbtElectricalLoad primaryLoad;
    @NotNull
    private final NbtElectricalLoad secondaryLoad;
    @NotNull
    private final VoltageSource primaryVoltageSource;
    @NotNull
    private final VoltageSource secondaryVoltageSource;
    @NotNull
    private final TransformerInterSystemProcess interSystemProcess;
    @NotNull
    private final TransparentNodeElementInventory inventory;
    private double primaryMaxCurrent;
    private double secondaryMaxCurrent;
    @NotNull
    private final VoltageStateWatchDog primaryVoltageWatchdog;
    @NotNull
    private final VoltageStateWatchDog secondaryVoltageWatchdog;
    private boolean populated;
    private double ratioControl;

    public DcDcElement(@NotNull TransparentNode transparentNode, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(transparentNode, "transparentNode");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(transparentNode, descriptor);
        this.primaryLoad = new NbtElectricalLoad("primaryLoad");
        this.secondaryLoad = new NbtElectricalLoad("secondaryLoad");
        this.primaryVoltageSource = new VoltageSource("primaryVoltageSource");
        this.secondaryVoltageSource = new VoltageSource("secondaryVoltageSource");
        this.interSystemProcess = new TransformerInterSystemProcess(this.primaryLoad, this.secondaryLoad, this.primaryVoltageSource, this.secondaryVoltageSource);
        this.inventory = new TransparentNodeElementInventory(4, 64, this);
        this.primaryVoltageWatchdog = new VoltageStateWatchDog(this.primaryLoad);
        this.secondaryVoltageWatchdog = new VoltageStateWatchDog(this.secondaryLoad);
        this.ratioControl = 1.0;
        this.electricalLoadList.add(this.primaryLoad);
        this.electricalLoadList.add(this.secondaryLoad);
        this.electricalComponentList.add(this.primaryVoltageSource);
        this.electricalComponentList.add(this.secondaryVoltageSource);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.primaryVoltageWatchdog.setDestroys(exp));
        this.slowProcessList.add(this.secondaryVoltageWatchdog.setDestroys(exp));
        TransparentNode transparentNode2 = this.node;
        Intrinsics.checkNotNull(transparentNode2);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode2, 1.0, 0.5));
        this.slowProcessList.add(new DcDcProcess(this));
    }

    @NotNull
    public final NbtElectricalLoad getPrimaryLoad() {
        return this.primaryLoad;
    }

    @NotNull
    public final NbtElectricalLoad getSecondaryLoad() {
        return this.secondaryLoad;
    }

    @NotNull
    public final VoltageSource getPrimaryVoltageSource() {
        return this.primaryVoltageSource;
    }

    @NotNull
    public final VoltageSource getSecondaryVoltageSource() {
        return this.secondaryVoltageSource;
    }

    @NotNull
    public final TransformerInterSystemProcess getInterSystemProcess() {
        return this.interSystemProcess;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    public final double getPrimaryMaxCurrent() {
        return this.primaryMaxCurrent;
    }

    public final void setPrimaryMaxCurrent(double d) {
        this.primaryMaxCurrent = d;
    }

    public final double getSecondaryMaxCurrent() {
        return this.secondaryMaxCurrent;
    }

    public final void setSecondaryMaxCurrent(double d) {
        this.secondaryMaxCurrent = d;
    }

    @NotNull
    public final VoltageStateWatchDog getPrimaryVoltageWatchdog() {
        return this.primaryVoltageWatchdog;
    }

    @NotNull
    public final VoltageStateWatchDog getSecondaryVoltageWatchdog() {
        return this.secondaryVoltageWatchdog;
    }

    public final boolean getPopulated() {
        return this.populated;
    }

    public final void setPopulated(boolean bl) {
        this.populated = bl;
    }

    public final double getRatioControl() {
        return this.ratioControl;
    }

    public final void setRatioControl(double d) {
        this.ratioControl = d;
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.interSystemProcess);
    }

    @Override
    public void connectJob() {
        Eln.simulator.mna.addProcess(this.interSystemProcess);
        super.connectJob();
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        Direction direction = side;
        return direction == this.front.right() ? (ElectricalLoad)this.secondaryLoad : (direction == this.front.left() ? (ElectricalLoad)this.primaryLoad : null);
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return 0;
        }
        Direction direction = side;
        return direction == this.front.left() ? 1 : (direction == this.front.right() ? 1 : 0);
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (side == this.front.left()) {
            return Utils.plotVolt("UP+:", this.primaryLoad.getVoltage()) + Utils.plotAmpere("IP+:", -this.primaryLoad.getCurrent());
        }
        return side == this.front.right() ? Utils.plotVolt("US+:", this.secondaryLoad.getVoltage()) + Utils.plotAmpere("IS+:", -this.secondaryLoad.getCurrent()) : Utils.plotVolt("UP+:", this.primaryLoad.getVoltage()) + Utils.plotAmpere("IP+:", this.primaryVoltageSource.getCurrent()) + Utils.plotVolt("  US+:", this.secondaryLoad.getVoltage()) + Utils.plotAmpere("IS+:", this.secondaryVoltageSource.getCurrent());
    }

    @Override
    public void initialize() {
        this.primaryVoltageSource.connectTo(this.primaryLoad, null);
        this.secondaryVoltageSource.connectTo(this.secondaryLoad, null);
        this.electricalComponentList.add(this.primaryVoltageSource);
        this.electricalComponentList.add(this.secondaryVoltageSource);
        this.interSystemProcess.setRatio(1.0);
        this.computeInventory();
        this.connect();
    }

    private final void computeInventory() {
        double d;
        ItemStack primaryCable = this.getInventory().func_70301_a(0);
        ItemStack secondaryCable = this.getInventory().func_70301_a(1);
        ItemStack core = this.getInventory().func_70301_a(2);
        this.primaryVoltageWatchdog.setNominalVoltage(120000.0);
        this.secondaryVoltageWatchdog.setNominalVoltage(120000.0);
        this.primaryMaxCurrent = 5.0;
        this.secondaryMaxCurrent = 5.0;
        double coreFactor = 1.0;
        if (core != null) {
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(core);
            Intrinsics.checkNotNull(genericItemUsingDamageDescriptor, "null cannot be cast to non-null type mods.eln.item.FerromagneticCoreDescriptor");
            FerromagneticCoreDescriptor coreDescriptor = (FerromagneticCoreDescriptor)genericItemUsingDamageDescriptor;
            coreFactor = coreDescriptor.cableMultiplicator;
        }
        if (primaryCable == null || core == null || primaryCable.field_77994_a < 1) {
            this.primaryLoad.highImpedance();
            this.populated = false;
        } else {
            this.primaryLoad.setSerialResistance(coreFactor * 0.01);
        }
        if (secondaryCable == null || core == null || secondaryCable.field_77994_a < 1) {
            this.secondaryLoad.highImpedance();
            this.populated = false;
        } else {
            this.secondaryLoad.setSerialResistance(coreFactor * 0.01);
        }
        boolean bl = this.populated = primaryCable != null && secondaryCable != null && primaryCable.field_77994_a >= 1 && secondaryCable.field_77994_a >= 1 && core != null;
        if (this.populated) {
            ItemStack itemStack = secondaryCable;
            Intrinsics.checkNotNull(itemStack);
            double d2 = itemStack.field_77994_a;
            ItemStack itemStack2 = primaryCable;
            Intrinsics.checkNotNull(itemStack2);
            d = d2 / (double)itemStack2.field_77994_a;
        } else {
            d = 1.0;
        }
        this.ratioControl = d;
    }

    @Override
    public void inventoryChange(@Nullable IInventory inventory) {
        this.disconnect();
        this.computeInventory();
        this.connect();
        this.needPublish();
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new DcDcContainer(player, (IInventory)this.getInventory());
    }

    @Override
    public float getLightOpacity() {
        return 1.0f;
    }

    @Override
    public void onGroundedChangedByClient() {
        super.onGroundedChangedByClient();
        this.computeInventory();
        this.reconnect();
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            if (this.getInventory().func_70301_a(0) == null) {
                stream.writeByte(0);
            } else {
                ItemStack itemStack = this.getInventory().func_70301_a(0);
                Intrinsics.checkNotNull(itemStack);
                stream.writeByte(itemStack.field_77994_a);
            }
            if (this.getInventory().func_70301_a(1) == null) {
                stream.writeByte(0);
            } else {
                ItemStack itemStack = this.getInventory().func_70301_a(1);
                Intrinsics.checkNotNull(itemStack);
                stream.writeByte(itemStack.field_77994_a);
            }
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(2));
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(0));
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(1));
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            transparentNode.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
            float load = 0.0f;
            if (!(this.primaryMaxCurrent == 0.0) && !(this.secondaryMaxCurrent == 0.0)) {
                load = Utils.limit((float)Math.max(this.primaryLoad.getCurrent() / this.primaryMaxCurrent, this.secondaryLoad.getCurrent() / this.secondaryMaxCurrent), 0.0f, 1.0f);
            }
            stream.writeFloat(load);
            stream.writeBoolean(this.getInventory().func_70301_a(3) != null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap info = new HashMap();
        Map map = info;
        String string = I18N.tr("Ratio", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Ratio\")");
        String string2 = string;
        String string3 = Utils.plotValue(this.interSystemProcess.getRatio());
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            ((Map)info).put("Voltages", "\u00a7a" + Utils.plotVolt("", this.primaryLoad.getVoltage()) + " \u00a7e" + Utils.plotVolt("", this.secondaryLoad.getVoltage()));
        }
        map = info;
        String string4 = I18N.tr("Subsystem Matrix Size: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Subsystem Matrix Size: \")");
        string2 = string4;
        string3 = Utils.renderDoubleSubsystemWaila(this.primaryLoad.getSubSystem(), this.secondaryLoad.getSubSystem());
        map.put(string2, string3);
        return info;
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("isolator")) {
            this.disconnect();
            this.reconnect();
            this.needPublish();
        }
        if (ConfigCopyToolDescriptor.readGenDescriptor(compound, "primary", (IInventory)this.getInventory(), 0, invoker)) {
            this.inventoryChange((IInventory)this.getInventory());
        }
        if (ConfigCopyToolDescriptor.readGenDescriptor(compound, "secondary", (IInventory)this.getInventory(), 1, invoker)) {
            this.inventoryChange((IInventory)this.getInventory());
        }
        if (ConfigCopyToolDescriptor.readGenDescriptor(compound, "core", (IInventory)this.getInventory(), 2, invoker)) {
            this.inventoryChange((IInventory)this.getInventory());
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        ConfigCopyToolDescriptor.writeGenDescriptor(compound, "primary", this.getInventory().func_70301_a(0));
        ConfigCopyToolDescriptor.writeGenDescriptor(compound, "secondary", this.getInventory().func_70301_a(1));
        ConfigCopyToolDescriptor.writeGenDescriptor(compound, "core", this.getInventory().func_70301_a(2));
    }
}

