/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.FerromagneticCoreDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Obj3D;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.SlewLimiter;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sound.LoopedSound;
import mods.eln.transparentnode.DcDcDescriptor;
import mods.eln.transparentnode.DcDcGui;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00103\u001a\u000204H\u0016J\u001a\u00105\u001a\u0004\u0018\u00010!2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u00106\u001a\u0002072\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u000204H\u0016J\u0010\u0010B\u001a\u0002042\u0006\u0010C\u001a\u00020DH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010#\"\u0004\b/\u0010%R\u001a\u00100\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010)\"\u0004\b2\u0010+\u00a8\u0006E"}, d2={"Lmods/eln/transparentnode/DcDcRender;", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "tileEntity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "cableRenderType", "Lmods/eln/cable/CableRenderType;", "controlConn", "Lmods/eln/misc/LRDUMask;", "coordinate", "Lmods/eln/misc/Coordinate;", "getDescriptor", "()Lmods/eln/node/transparent/TransparentNodeDescriptor;", "doorOpen", "Lmods/eln/misc/PhysicalInterpolator;", "eConn", "feroPart", "Lmods/eln/misc/Obj3D$Obj3DPart;", "Lmods/eln/misc/Obj3D;", "hasCasing", "", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInventory", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "load", "Lmods/eln/misc/SlewLimiter;", "getLoad", "()Lmods/eln/misc/SlewLimiter;", "priConn", "priRender", "Lmods/eln/cable/CableRenderDescriptor;", "getPriRender", "()Lmods/eln/cable/CableRenderDescriptor;", "setPriRender", "(Lmods/eln/cable/CableRenderDescriptor;)V", "primaryStackSize", "", "getPrimaryStackSize", "()B", "setPrimaryStackSize", "(B)V", "secConn", "secRender", "getSecRender", "setSecRender", "secondaryStackSize", "getSecondaryStackSize", "setSecondaryStackSize", "draw", "", "getCableRenderSide", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "notifyNeighborSpawn", "refresh", "deltaT", "", "Eln"})
public final class DcDcRender
extends TransparentNodeElementRender {
    @NotNull
    private final TransparentNodeDescriptor descriptor;
    @NotNull
    private final TransparentNodeElementInventory inventory;
    @NotNull
    private final SlewLimiter load;
    private byte primaryStackSize;
    private byte secondaryStackSize;
    @Nullable
    private CableRenderDescriptor priRender;
    @Nullable
    private CableRenderDescriptor secRender;
    @Nullable
    private Obj3D.Obj3DPart feroPart;
    private boolean hasCasing;
    @NotNull
    private final Coordinate coordinate;
    @NotNull
    private final PhysicalInterpolator doorOpen;
    @NotNull
    private final LRDUMask priConn;
    @NotNull
    private final LRDUMask secConn;
    @NotNull
    private final LRDUMask controlConn;
    @NotNull
    private final LRDUMask eConn;
    @Nullable
    private CableRenderType cableRenderType;

    public DcDcRender(@NotNull TransparentNodeEntity tileEntity, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(tileEntity, descriptor);
        this.descriptor = descriptor;
        this.inventory = new TransparentNodeElementInventory(4, 64, this);
        this.load = new SlewLimiter(0.5f);
        this.priConn = new LRDUMask();
        this.secConn = new LRDUMask();
        this.controlConn = new LRDUMask();
        this.eConn = new LRDUMask();
        Coordinate coordinate = this.coordinate();
        ISound.AttenuationType attenuationType = ISound.AttenuationType.LINEAR;
        this.addLoopedSound(new LoopedSound(coordinate, attenuationType){

            @Override
            public float func_147653_e() {
                float f = this.getLoad().getPosition();
                TransparentNodeDescriptor transparentNodeDescriptor = this.getDescriptor();
                Intrinsics.checkNotNull(transparentNodeDescriptor, "null cannot be cast to non-null type mods.eln.transparentnode.DcDcDescriptor");
                return f > ((DcDcDescriptor)transparentNodeDescriptor).getMinimalLoadToHum() ? 0.1f * (this.getLoad().getPosition() - ((DcDcDescriptor)this.getDescriptor()).getMinimalLoadToHum()) / (1.0f - ((DcDcDescriptor)this.getDescriptor()).getMinimalLoadToHum()) : 0.0f;
            }
        });
        this.coordinate = new Coordinate(tileEntity);
        this.doorOpen = new PhysicalInterpolator(0.4f, 4.0f, 0.9f, 0.05f);
    }

    @NotNull
    public final TransparentNodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final SlewLimiter getLoad() {
        return this.load;
    }

    public final byte getPrimaryStackSize() {
        return this.primaryStackSize;
    }

    public final void setPrimaryStackSize(byte by) {
        this.primaryStackSize = by;
    }

    public final byte getSecondaryStackSize() {
        return this.secondaryStackSize;
    }

    public final void setSecondaryStackSize(byte by) {
        this.secondaryStackSize = by;
    }

    @Nullable
    public final CableRenderDescriptor getPriRender() {
        return this.priRender;
    }

    public final void setPriRender(@Nullable CableRenderDescriptor cableRenderDescriptor) {
        this.priRender = cableRenderDescriptor;
    }

    @Nullable
    public final CableRenderDescriptor getSecRender() {
        return this.secRender;
    }

    public final void setSecRender(@Nullable CableRenderDescriptor cableRenderDescriptor) {
        this.secRender = cableRenderDescriptor;
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        Direction direction = this.front;
        Intrinsics.checkNotNull((Object)direction);
        direction.glRotateXnRef();
        TransparentNodeDescriptor transparentNodeDescriptor = this.descriptor;
        Intrinsics.checkNotNull(transparentNodeDescriptor, "null cannot be cast to non-null type mods.eln.transparentnode.DcDcDescriptor");
        ((DcDcDescriptor)transparentNodeDescriptor).draw$Eln(this.feroPart, this.primaryStackSize, this.secondaryStackSize, this.hasCasing, this.doorOpen.get());
        GL11.glPopMatrix();
        Direction direction2 = this.front;
        Intrinsics.checkNotNull((Object)direction2);
        this.cableRenderType = this.drawCable(direction2.down(), this.priRender, this.priConn, this.cableRenderType);
        Direction direction3 = this.front;
        Intrinsics.checkNotNull((Object)direction3);
        this.cableRenderType = this.drawCable(direction3.down(), this.secRender, this.secConn, this.cableRenderType);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            GenericItemBlockUsingDamageDescriptor secDesc;
            ItemStack secStack;
            GenericItemBlockUsingDamageDescriptor priDesc;
            ItemStack priStack;
            GenericItemUsingDamageDescriptor feroDesc;
            this.primaryStackSize = stream.readByte();
            this.secondaryStackSize = stream.readByte();
            ItemStack feroStack = Utils.unserialiseItemStack(stream);
            if (feroStack != null && (feroDesc = GenericItemUsingDamageDescriptor.Companion.getDescriptor(feroStack, FerromagneticCoreDescriptor.class)) != null) {
                this.feroPart = ((FerromagneticCoreDescriptor)feroDesc).feroPart;
            }
            if ((priStack = Utils.unserialiseItemStack(stream)) != null && (priDesc = ElectricalCableDescriptor.getDescriptor(priStack, ElectricalCableDescriptor.class)) != null) {
                this.priRender = ((ElectricalCableDescriptor)priDesc).render;
            }
            if ((secStack = Utils.unserialiseItemStack(stream)) != null && (secDesc = ElectricalCableDescriptor.getDescriptor(secStack, ElectricalCableDescriptor.class)) != null) {
                this.secRender = ((ElectricalCableDescriptor)secDesc).render;
            }
            this.eConn.deserialize(stream);
            this.priConn.setMask(0);
            this.secConn.setMask(0);
            for (LRDU lrdu : LRDU.values()) {
                if (!this.eConn.get(lrdu)) continue;
                Direction direction = this.front;
                Intrinsics.checkNotNull((Object)direction);
                Direction direction2 = direction.down().applyLRDU(lrdu);
                Direction direction3 = this.front;
                Intrinsics.checkNotNull((Object)direction3);
                if (direction2 == direction3.left()) {
                    this.priConn.set(lrdu, true);
                    continue;
                }
                Direction direction4 = this.front;
                Intrinsics.checkNotNull((Object)direction4);
                Direction direction5 = direction4.down().applyLRDU(lrdu);
                Direction direction6 = this.front;
                Intrinsics.checkNotNull((Object)direction6);
                if (direction5 == direction6.right()) {
                    this.secConn.set(lrdu, true);
                    continue;
                }
                this.controlConn.set(lrdu, true);
            }
            this.cableRenderType = null;
            this.load.setTarget(stream.readFloat());
            this.hasCasing = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRenderSide(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == LRDU.Down) {
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            if (side == direction.left()) {
                return this.priRender;
            }
            Direction direction2 = this.front;
            Intrinsics.checkNotNull((Object)direction2);
            if (side == direction2.right()) {
                return this.secRender;
            }
            if (side == this.front && !this.getGrounded()) {
                return this.priRender;
            }
            Direction direction3 = this.front;
            Intrinsics.checkNotNull((Object)direction3);
            if (side == direction3.back() && !this.getGrounded()) {
                return this.secRender;
            }
        }
        return null;
    }

    @Override
    public void notifyNeighborSpawn() {
        super.notifyNeighborSpawn();
        this.cableRenderType = null;
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.load.step(deltaT);
        if (this.hasCasing) {
            World world = this.getTileEntity().func_145831_w();
            Intrinsics.checkNotNullExpressionValue(world, "tileEntity.worldObj");
            Direction direction = this.front;
            Intrinsics.checkNotNull((Object)direction);
            if (!Utils.isPlayerAround(world, this.coordinate.moved(direction).getAxisAlignedBB(0))) {
                this.doorOpen.setTarget(0.0f);
            } else {
                this.doorOpen.setTarget(1.0f);
            }
            this.doorOpen.step(deltaT);
        }
    }

    @Override
    @NotNull
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return (GuiScreen)new DcDcGui(player, (IInventory)this.getInventory(), this);
    }
}

