/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.FabricatorContainer;
import mods.eln.transparentnode.FabricatorDescriptor;
import mods.eln.transparentnode.FabricatorInventory;
import mods.eln.transparentnode.FabricatorNetwork;
import mods.eln.transparentnode.FabricatorOperation;
import mods.eln.transparentnode.FabricatorProcess;
import mods.eln.transparentnode.FabricatorSlots;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010-\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u000205H\u0016J0\u00106\u001a\u00020(2\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u000208H\u0016J\u0010\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010?\u001a\u00020*2\u0006\u0010<\u001a\u00020=H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006@"}, d2={"Lmods/eln/transparentnode/FabricatorElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "craftingProcess", "Lmods/eln/transparentnode/FabricatorProcess;", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getElectricalLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInventory", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "operation", "Lmods/eln/transparentnode/FabricatorOperation;", "getOperation", "()Lmods/eln/transparentnode/FabricatorOperation;", "setOperation", "(Lmods/eln/transparentnode/FabricatorOperation;)V", "resistorLoad", "Lmods/eln/sim/mna/component/Resistor;", "getResistorLoad", "()Lmods/eln/sim/mna/component/Resistor;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "", "Ljava/io/DataInputStream;", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nFabricator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fabricator.kt\nmods/eln/transparentnode/FabricatorElement\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,385:1\n3792#2:386\n4307#2,2:387\n1282#2,2:389\n*S KotlinDebug\n*F\n+ 1 Fabricator.kt\nmods/eln/transparentnode/FabricatorElement\n*L\n126#1:386\n126#1:387,2\n145#1:389,2\n*E\n"})
public final class FabricatorElement
extends TransparentNodeElement {
    @Nullable
    private FabricatorOperation operation;
    @NotNull
    private final NbtElectricalLoad electricalLoad;
    @NotNull
    private final Resistor resistorLoad;
    @NotNull
    private final FabricatorProcess craftingProcess;
    @NotNull
    private final TransparentNodeElementInventory inventory;

    public FabricatorElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(node, descriptor);
        this.operation = FabricatorOperation.TRANSISTOR;
        this.electricalLoad = new NbtElectricalLoad("load");
        this.resistorLoad = new Resistor(this.electricalLoad, null);
        this.craftingProcess = new FabricatorProcess(this);
        this.inventory = new FabricatorInventory(FabricatorSlots.values().length, 64, this);
    }

    @Nullable
    public final FabricatorOperation getOperation() {
        return this.operation;
    }

    public final void setOperation(@Nullable FabricatorOperation fabricatorOperation) {
        this.operation = fabricatorOperation;
    }

    @NotNull
    public final NbtElectricalLoad getElectricalLoad() {
        return this.electricalLoad;
    }

    @NotNull
    public final Resistor getResistorLoad() {
        return this.resistorLoad;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return side == Direction.ZN && lrdu == LRDU.Down ? (ElectricalLoad)this.electricalLoad : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return side == Direction.ZN && lrdu == LRDU.Down ? 1 : 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotUIP(this.resistorLoad.getVoltage(), this.resistorLoad.getCurrent(), this.resistorLoad.getResistance());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Object object = this.operation;
        if (object == null || (object = object.getOpName()) == null) {
            object = "None";
        }
        return MapsKt.mapOf(new Pair<String, FabricatorOperation>("Operation", (FabricatorOperation)((Object)object)));
    }

    @Override
    public void initialize() {
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.resistorLoad);
        this.electricalLoad.setSerialResistance(Eln.getSmallRs());
        this.resistorLoad.setResistance(1.0E9);
        this.slowProcessList.add(this.craftingProcess);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @NotNull
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        NodeBase nodeBase = this.node;
        IInventory iInventory = (IInventory)this.getInventory();
        TransparentNodeDescriptor transparentNodeDescriptor = this.getDescriptor();
        Intrinsics.checkNotNull(transparentNodeDescriptor, "null cannot be cast to non-null type mods.eln.transparentnode.FabricatorDescriptor");
        return new FabricatorContainer(nodeBase, player, iInventory, (FabricatorDescriptor)transparentNodeDescriptor);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        FabricatorOperation fabricatorOperation = this.operation;
        stream.writeInt(fabricatorOperation != null ? fabricatorOperation.getNid() : -1);
        stream.writeBoolean(this.resistorLoad.getPower() > 1.0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        byte packetType = super.networkUnserialize(stream);
        try {
            if (packetType == FabricatorNetwork.BUTTON_CLICK.getId()) {
                void $this$filterTo$iv$iv;
                int op = stream.readInt();
                FabricatorOperation[] $this$filter$iv = FabricatorOperation.values();
                boolean $i$f$filter = false;
                FabricatorOperation[] fabricatorOperationArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!(op == it.getNid())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List thing = (List)destination$iv$iv;
                if (!((Collection)thing).isEmpty()) {
                    this.operation = (FabricatorOperation)((Object)CollectionsKt.first(thing));
                    this.craftingProcess.setPowerConsumed(0.0);
                    this.needPublish();
                    FabricatorOperation fabricatorOperation = this.operation;
                    Utils.println("Function is now " + (fabricatorOperation != null ? fabricatorOperation.getOpName() : null));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -128;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            super.readFromNBT(nbt);
            int id = nbt.func_74762_e("operation");
            FabricatorOperation[] fabricatorOperationArray = FabricatorOperation.values();
            FabricatorElement fabricatorElement = this;
            boolean $i$f$firstOrNull = false;
            int n = ((void)$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(it.getNid() == id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        fabricatorElement.operation = v0;
        this.craftingProcess.setPowerConsumed(nbt.func_74769_h("powerConsumed"));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        if (this.operation != null) {
            FabricatorOperation fabricatorOperation = this.operation;
            nbt.func_74768_a("operation", fabricatorOperation != null ? fabricatorOperation.getNid() : 0);
        }
        nbt.func_74780_a("powerConsumed", this.craftingProcess.getPowerConsumed());
    }
}

