/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.FabricatorElement;
import mods.eln.transparentnode.FabricatorOperation;
import mods.eln.transparentnode.FabricatorSlots;
import net.minecraft.item.ItemStack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmods/eln/transparentnode/FabricatorProcess;", "Lmods/eln/sim/IProcess;", "element", "Lmods/eln/transparentnode/FabricatorElement;", "(Lmods/eln/transparentnode/FabricatorElement;)V", "getElement", "()Lmods/eln/transparentnode/FabricatorElement;", "powerConsumed", "", "getPowerConsumed", "()D", "setPowerConsumed", "(D)V", "powerRequired", "process", "", "time", "Eln"})
public final class FabricatorProcess
implements IProcess {
    @NotNull
    private final FabricatorElement element;
    private double powerConsumed;
    private final double powerRequired;

    public FabricatorProcess(@NotNull FabricatorElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        this.element = element;
        this.powerRequired = 4000.0;
    }

    @NotNull
    public final FabricatorElement getElement() {
        return this.element;
    }

    public final double getPowerConsumed() {
        return this.powerConsumed;
    }

    public final void setPowerConsumed(double d) {
        this.powerConsumed = d;
    }

    @Override
    public void process(double time) {
        boolean hasInputs;
        boolean bl;
        FabricatorOperation operation = this.element.getOperation();
        ItemStack outputSlot = this.element.getInventory().func_70301_a(FabricatorSlots.OUTPUT.getSlotId());
        ItemStack siliconWaferSlot = this.element.getInventory().func_70301_a(FabricatorSlots.SILICON_WAFER.getSlotId());
        ItemStack plateCopperSlot = this.element.getInventory().func_70301_a(FabricatorSlots.COPPER_PLATE.getSlotId());
        String siliconWaferName = "Silicon_Wafer";
        String copperPlateName = "Copper_Plate";
        if (outputSlot != null) {
            ItemStack stack = this.element.getInventory().func_70301_a(FabricatorSlots.OUTPUT.getSlotId());
            if (operation != null) {
                ItemStack itemStack = stack;
                Intrinsics.checkNotNull(itemStack);
                bl = Intrinsics.areEqual(itemStack.func_77973_b(), operation.getOutputItem().func_77973_b()) && stack.field_77994_a + operation.getPerSheet() < stack.func_77976_d();
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        boolean canOutput = bl;
        boolean bl2 = hasInputs = siliconWaferSlot != null && plateCopperSlot != null && Intrinsics.areEqual(siliconWaferSlot.func_77977_a(), siliconWaferName) && Intrinsics.areEqual(plateCopperSlot.func_77977_a(), copperPlateName);
        if (canOutput && hasInputs && operation != null) {
            double power2 = time * this.element.getResistorLoad().getPower();
            this.powerConsumed += power2;
            if (this.powerConsumed > this.powerRequired * (double)2) {
                this.element.getResistorLoad().setResistance(1.0E9);
            } else {
                this.element.getResistorLoad().setResistance(40.0);
            }
        } else {
            this.element.getResistorLoad().setResistance(1.0E9);
        }
        FabricatorOperation fabricatorOperation = operation;
        if ((fabricatorOperation != null ? fabricatorOperation.getOutputItem() : null) != null && this.powerRequired <= this.powerConsumed) {
            this.element.getInventory().func_70298_a(FabricatorSlots.COPPER_PLATE.getSlotId(), 1);
            this.element.getInventory().func_70298_a(FabricatorSlots.SILICON_WAFER.getSlotId(), 1);
            if (Math.random() <= operation.getYieldPercentage()) {
                if (this.element.getInventory().func_70301_a(FabricatorSlots.OUTPUT.getSlotId()) == null) {
                    ItemStack newStack = operation.getOutputItem().func_77946_l();
                    newStack.field_77994_a = operation.getPerSheet();
                    this.element.getInventory().func_70299_a(FabricatorSlots.OUTPUT.getSlotId(), newStack);
                    this.powerConsumed -= this.powerRequired;
                    this.element.needPublish();
                } else {
                    ItemStack itemStack = this.element.getInventory().func_70301_a(FabricatorSlots.OUTPUT.getSlotId());
                    Intrinsics.checkNotNull(itemStack);
                    int stackSize = itemStack.field_77994_a;
                    boolean bl3 = 0 <= stackSize ? stackSize < 64 : false;
                    if (bl3) {
                        ItemStack newStack = operation.getOutputItem().func_77946_l();
                        newStack.field_77994_a = stackSize + operation.getPerSheet();
                        this.element.getInventory().func_70299_a(FabricatorSlots.OUTPUT.getSlotId(), newStack);
                        this.powerConsumed -= this.powerRequired;
                        this.element.needPublish();
                    }
                }
            }
        }
    }
}

