/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.fluid.FuelRegistry;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.published;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.MutablePropertyReference1Impl;
import mods.eln.shadow.kotlin.jvm.internal.Reflection;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.reflect.KProperty;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.FuelGeneratorDescriptor;
import mods.eln.transparentnode.FuelGeneratorSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u001a\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u001a\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0014\u0010D\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020F0EH\u0016J\b\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020F2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010J\u001a\u00020H2\u0006\u0010K\u001a\u00020LH\u0016J0\u0010M\u001a\u00020\u00132\u0006\u0010N\u001a\u00020O2\u0006\u0010<\u001a\u00020=2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020QH\u0016J\u0010\u0010T\u001a\u00020H2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020F2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010X\u001a\u00020H2\u0006\u0010U\u001a\u00020VH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107\u00a8\u0006Y"}, d2={"Lmods/eln/transparentnode/FuelGeneratorElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "transparentNode", "Lmods/eln/node/transparent/TransparentNode;", "descriptor_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "descriptor", "Lmods/eln/transparentnode/FuelGeneratorDescriptor;", "getDescriptor", "()Lmods/eln/transparentnode/FuelGeneratorDescriptor;", "setDescriptor", "(Lmods/eln/transparentnode/FuelGeneratorDescriptor;)V", "fuels", "", "", "getFuels$Eln", "()Ljava/util/List;", "<set-?>", "", "on", "getOn$Eln", "()Z", "setOn$Eln", "(Z)V", "on$delegate", "Lmods/eln/node/published;", "positiveLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getPositiveLoad$Eln", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setPositiveLoad$Eln", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "powerSource", "Lmods/eln/sim/mna/component/PowerSource;", "getPowerSource$Eln", "()Lmods/eln/sim/mna/component/PowerSource;", "setPowerSource$Eln", "(Lmods/eln/sim/mna/component/PowerSource;)V", "slowProcess", "Lmods/eln/transparentnode/FuelGeneratorSlowProcess;", "getSlowProcess$Eln", "()Lmods/eln/transparentnode/FuelGeneratorSlowProcess;", "setSlowProcess$Eln", "(Lmods/eln/transparentnode/FuelGeneratorSlowProcess;)V", "tankFluid", "getTankFluid$Eln", "()I", "setTankFluid$Eln", "(I)V", "tankLevel", "", "getTankLevel$Eln", "()D", "setTankLevel$Eln", "(D)V", "voltageGracePeriod", "getVoltageGracePeriod$Eln", "setVoltageGracePeriod$Eln", "getConnectionMask", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nFuelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuelGenerator.kt\nmods/eln/transparentnode/FuelGeneratorElement\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,303:1\n11335#2:304\n11670#2,3:305\n*S KotlinDebug\n*F\n+ 1 FuelGenerator.kt\nmods/eln/transparentnode/FuelGeneratorElement\n*L\n118#1:304\n118#1:305,3\n*E\n"})
public final class FuelGeneratorElement
extends TransparentNodeElement {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private NbtElectricalLoad positiveLoad;
    @NotNull
    private PowerSource powerSource;
    @NotNull
    private FuelGeneratorSlowProcess slowProcess;
    @NotNull
    private FuelGeneratorDescriptor descriptor;
    @NotNull
    private final List<Integer> fuels;
    private double tankLevel;
    private int tankFluid;
    @NotNull
    private final published on$delegate;
    private double voltageGracePeriod;

    /*
     * WARNING - void declaration
     */
    public FuelGeneratorElement(@NotNull TransparentNode transparentNode, @NotNull TransparentNodeDescriptor descriptor_) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(transparentNode, "transparentNode");
        Intrinsics.checkNotNullParameter(descriptor_, "descriptor_");
        super(transparentNode, descriptor_);
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.powerSource = new PowerSource("powerSource", (State)this.positiveLoad);
        this.slowProcess = new FuelGeneratorSlowProcess(this);
        this.descriptor = (FuelGeneratorDescriptor)descriptor_;
        Fluid[] fluidArray = FuelRegistry.INSTANCE.fluidListToFluids(this.getDescriptor().getFuels$Eln());
        FuelGeneratorElement fuelGeneratorElement = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getID());
        }
        fuelGeneratorElement.fuels = (List)destination$iv$iv;
        this.tankFluid = FluidRegistry.getFluid((String)"lava").getID();
        this.on$delegate = new published(false, null, false, 6, null);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerSource);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 1.0, 0.5));
        this.slowProcessList.add(this.slowProcess);
    }

    @NotNull
    public final NbtElectricalLoad getPositiveLoad$Eln() {
        return this.positiveLoad;
    }

    public final void setPositiveLoad$Eln(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.positiveLoad = nbtElectricalLoad;
    }

    @NotNull
    public final PowerSource getPowerSource$Eln() {
        return this.powerSource;
    }

    public final void setPowerSource$Eln(@NotNull PowerSource powerSource) {
        Intrinsics.checkNotNullParameter(powerSource, "<set-?>");
        this.powerSource = powerSource;
    }

    @NotNull
    public final FuelGeneratorSlowProcess getSlowProcess$Eln() {
        return this.slowProcess;
    }

    public final void setSlowProcess$Eln(@NotNull FuelGeneratorSlowProcess fuelGeneratorSlowProcess) {
        Intrinsics.checkNotNullParameter(fuelGeneratorSlowProcess, "<set-?>");
        this.slowProcess = fuelGeneratorSlowProcess;
    }

    @Override
    @NotNull
    public FuelGeneratorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(@NotNull FuelGeneratorDescriptor fuelGeneratorDescriptor) {
        Intrinsics.checkNotNullParameter(fuelGeneratorDescriptor, "<set-?>");
        this.descriptor = fuelGeneratorDescriptor;
    }

    @NotNull
    public final List<Integer> getFuels$Eln() {
        return this.fuels;
    }

    public final double getTankLevel$Eln() {
        return this.tankLevel;
    }

    public final void setTankLevel$Eln(double d) {
        this.tankLevel = d;
    }

    public final int getTankFluid$Eln() {
        return this.tankFluid;
    }

    public final void setTankFluid$Eln(int n) {
        this.tankFluid = n;
    }

    public final boolean getOn$Eln() {
        return (Boolean)this.on$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    public final void setOn$Eln(boolean bl) {
        this.on$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[0], bl);
    }

    public final double getVoltageGracePeriod$Eln() {
        return this.voltageGracePeriod;
    }

    public final void setVoltageGracePeriod$Eln(double d) {
        this.voltageGracePeriod = d;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return WhenMappings.$EnumSwitchMapping$0[lrdu.ordinal()] == 1 ? (ElectricalLoad)(((direction = side) == this.front ? true : direction == this.front.getInverse()) ? this.positiveLoad : null) : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return WhenMappings.$EnumSwitchMapping$0[lrdu.ordinal()] == 1 ? (((direction = side) == this.front ? true : direction == this.front.getInverse()) ? 1 : 0) : 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotVolt("U+:", this.positiveLoad.getVoltage()) + Utils.plotAmpere("I+:", this.positiveLoad.getCurrent()) + Utils.plotPercent("Fuel level:", this.tankLevel);
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    @Override
    public void initialize() {
        this.getDescriptor().getCable$Eln().applyTo(this.positiveLoad);
        this.powerSource.setMaximumVoltage(this.getDescriptor().getMaxVoltage$Eln());
        this.powerSource.setMaximumCurrent(this.getDescriptor().getNominalPower$Eln() * (double)5 / this.getDescriptor().getMaxVoltage$Eln());
        this.connect();
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        TransparentNode transparentNode = this.node;
        Intrinsics.checkNotNull(transparentNode);
        transparentNode.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        stream.writeBoolean(this.getOn$Eln());
        stream.writeFloat((float)(this.positiveLoad.getVoltage() / this.getDescriptor().getMaxVoltage$Eln()));
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        World world = player.field_70170_p;
        boolean bl = world != null ? !world.field_72995_K : false;
        if (bl) {
            ItemStack bucket = player.func_71045_bC();
            if (FluidContainerRegistry.isBucket((ItemStack)bucket) && FluidContainerRegistry.isFilledContainer((ItemStack)bucket)) {
                FluidStack fluidStack;
                double deltaLevel = 1.0 / (double)FuelGeneratorDescriptor.Companion.getTankCapacityInBuckets();
                if (this.tankLevel <= 1.0 - deltaLevel && (fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket)) != null && (fluidStack.getFluidID() == this.tankFluid || this.tankLevel <= 0.0) && this.fuels.contains(fluidStack.getFluidID())) {
                    this.tankFluid = fluidStack.getFluidID();
                    this.tankLevel += deltaLevel;
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack emptyBucket = FluidContainerRegistry.drainFluidContainer((ItemStack)bucket);
                        int slot = player.field_71071_by.field_70461_c;
                        player.field_71071_by.func_70299_a(slot, emptyBucket);
                    }
                    return true;
                }
            } else {
                if (Eln.multiMeterElement.checkSameItemStack(player.func_71045_bC()) || Eln.thermometerElement.checkSameItemStack(player.func_71045_bC()) || Eln.allMeterElement.checkSameItemStack(player.func_71045_bC())) {
                    return false;
                }
                if (this.getOn$Eln()) {
                    this.setOn$Eln(false);
                } else if (this.tankLevel > 0.0) {
                    this.setOn$Eln(true);
                    this.voltageGracePeriod = FuelGeneratorDescriptor.Companion.getVoltageStabilizationGracePeriod();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.tankLevel = nbt.func_74769_h("tankLevel");
        this.setOn$Eln(nbt.func_74767_n("on"));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74780_a("tankLevel", this.tankLevel);
        nbt.func_74757_a("on", this.getOn$Eln());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Pair[] pairArray = new Pair[]{new Pair<String, String>(I18N.tr("State", new Object[0]), this.getOn$Eln() ? I18N.tr("ON", new Object[0]) : I18N.tr("OFF", new Object[0])), new Pair<String, String>(I18N.tr("Fuel level", new Object[0]), Utils.plotPercent("", this.tankLevel)), new Pair<String, String>(I18N.tr("Generated power", new Object[0]), Utils.plotPower("", this.powerSource.getEffectivePower())), new Pair<String, String>(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.powerSource.getVoltage()))};
        return MapsKt.mutableMapOf(pairArray);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(FuelGeneratorElement.class, "on", "getOn$Eln()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LRDU.values().length];
            try {
                nArray[LRDU.Down.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

