/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.FuelGeneratorDescriptor;
import mods.eln.transparentnode.FuelGeneratorElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lmods/eln/transparentnode/FuelGeneratorSlowProcess;", "Lmods/eln/sim/IProcess;", "generator", "Lmods/eln/transparentnode/FuelGeneratorElement;", "(Lmods/eln/transparentnode/FuelGeneratorElement;)V", "getGenerator$Eln", "()Lmods/eln/transparentnode/FuelGeneratorElement;", "process", "", "time", "", "Eln"})
public final class FuelGeneratorSlowProcess
implements IProcess {
    @NotNull
    private final FuelGeneratorElement generator;

    public FuelGeneratorSlowProcess(@NotNull FuelGeneratorElement generator) {
        Intrinsics.checkNotNullParameter(generator, "generator");
        this.generator = generator;
    }

    @NotNull
    public final FuelGeneratorElement getGenerator$Eln() {
        return this.generator;
    }

    @Override
    public void process(double time) {
        if (this.generator.getOn$Eln()) {
            double power2 = Math.max(this.generator.getPowerSource$Eln().getEffectivePower(), this.generator.getDescriptor().getNominalPower$Eln() * FuelGeneratorDescriptor.Companion.getMinimalLoadFractionOfNominalPower());
            this.generator.setTankLevel$Eln(Math.max(0.0, this.generator.getTankLevel$Eln() - time * FuelGeneratorDescriptor.Companion.EfficiencyFactorVsLoadFactor$Eln(power2 / this.generator.getDescriptor().getNominalPower$Eln()) * power2 / this.generator.getDescriptor().getTankEnergyCapacity$Eln()));
            if (this.generator.getTankLevel$Eln() <= 0.0) {
                this.generator.setOn$Eln(false);
            }
            if (this.generator.getVoltageGracePeriod$Eln() > 0.0) {
                FuelGeneratorElement fuelGeneratorElement = this.generator;
                fuelGeneratorElement.setVoltageGracePeriod$Eln(fuelGeneratorElement.getVoltageGracePeriod$Eln() - time);
            } else if (this.generator.getPositiveLoad$Eln().getVoltage() < FuelGeneratorDescriptor.Companion.getGeneratorBailOutVoltageRatio() * this.generator.getDescriptor().getMaxVoltage$Eln()) {
                this.generator.setOn$Eln(false);
            }
        }
        if (this.generator.getOn$Eln()) {
            this.generator.getPowerSource$Eln().setPower(this.generator.getDescriptor().getNominalPower$Eln());
        } else {
            this.generator.getPowerSource$Eln().setPower(0.0);
        }
    }
}

