/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.util.Arrays;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.EntityMetaTag;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ThermalLoadInitializerByPowerDrop;
import mods.eln.transparentnode.FuelHeatFurnaceElement;
import mods.eln.transparentnode.FuelHeatFurnaceRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J+\u0010\u001d\u001a\u00020\u00142\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0016J1\u0010'\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00162\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\n\"\u00020)H\u0016\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010$\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001fH\u0016J \u0010.\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0016R&\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012 \f*\b\u0018\u00010\u000bR\u00020\u00050\u000bR\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001e\u0010\u000e\u001a\u0012 \f*\b\u0018\u00010\u000bR\u00020\u00050\u000bR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012 \f*\b\u0018\u00010\u000bR\u00020\u00050\u000bR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012 \f*\b\u0018\u00010\u000bR\u00020\u00050\u000bR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lmods/eln/transparentnode/FuelHeatFurnaceDescriptor;", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "name", "", "model", "Lmods/eln/misc/Obj3D;", "thermal", "Lmods/eln/sim/ThermalLoadInitializerByPowerDrop;", "(Ljava/lang/String;Lmods/eln/misc/Obj3D;Lmods/eln/sim/ThermalLoadInitializerByPowerDrop;)V", "burners", "", "Lmods/eln/misc/Obj3D$Obj3DPart;", "mods.eln.shadow.kotlin.jvm.PlatformType", "[Lmods/eln/misc/Obj3D$Obj3DPart;", "heatLED", "main", "powerLED", "getThermal", "()Lmods/eln/sim/ThermalLoadInitializerByPowerDrop;", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "draw", "installedBurner", "", "on", "heating", "(Ljava/lang/Integer;ZZ)V", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "renderItem", "data", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setParent", "Lnet/minecraft/item/Item;", "damage", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "Eln"})
public final class FuelHeatFurnaceDescriptor
extends TransparentNodeDescriptor {
    @NotNull
    private final ThermalLoadInitializerByPowerDrop thermal;
    private final Obj3D.Obj3DPart main;
    @NotNull
    private final Obj3D.Obj3DPart[] burners;
    private final Obj3D.Obj3DPart powerLED;
    private final Obj3D.Obj3DPart heatLED;

    public FuelHeatFurnaceDescriptor(@NotNull String name, @NotNull Obj3D model, @NotNull ThermalLoadInitializerByPowerDrop thermal) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(thermal, "thermal");
        super(name, FuelHeatFurnaceElement.class, FuelHeatFurnaceRender.class, EntityMetaTag.Fluid);
        this.thermal = thermal;
        this.main = model.getPart("Main");
        Obj3D.Obj3DPart[] obj3DPartArray = new Obj3D.Obj3DPart[]{model.getPart("BurnerA"), model.getPart("BurnerB"), model.getPart("BurnerC")};
        this.burners = obj3DPartArray;
        this.powerLED = model.getPart("PowerLED");
        this.heatLED = model.getPart("HeatLED");
        this.thermal.setMaximalPower(2000.0);
        this.voltageLevelColor = VoltageLevelColor.Thermal;
    }

    @NotNull
    public final ThermalLoadInitializerByPowerDrop getThermal() {
        return this.thermal;
    }

    @Override
    public void setParent(@NotNull Item item, int damage) {
        Intrinsics.checkNotNullParameter(item, "item");
        super.setParent(item, damage);
        Data.addThermal(this.newItemStack());
    }

    public final void draw(@Nullable Integer installedBurner, boolean on2, boolean heating) {
        Obj3D.Obj3DPart obj3DPart = this.main;
        if (obj3DPart != null) {
            obj3DPart.draw();
        }
        if (installedBurner != null) {
            Obj3D.Obj3DPart obj3DPart2 = this.burners[installedBurner];
            if (obj3DPart2 != null) {
                obj3DPart2.draw();
            }
        }
        if (on2) {
            GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
            UtilsClient.drawLight(this.powerLED);
        } else {
            GL11.glColor3f((float)0.0f, (float)0.5f, (float)0.0f);
            Obj3D.Obj3DPart obj3DPart3 = this.powerLED;
            if (obj3DPart3 != null) {
                obj3DPart3.draw();
            }
        }
        if (heating) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            UtilsClient.drawLight(this.heatLED);
        } else {
            GL11.glColor3f((float)0.5f, (float)0.0f, (float)0.0f);
            Obj3D.Obj3DPart obj3DPart4 = this.heatLED;
            if (obj3DPart4 != null) {
                obj3DPart4.draw();
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static /* synthetic */ void draw$default(FuelHeatFurnaceDescriptor fuelHeatFurnaceDescriptor, Integer n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        fuelHeatFurnaceDescriptor.draw(n, bl, bl2);
    }

    @Override
    public boolean handleRenderType(@NotNull ItemStack item, @NotNull IItemRenderer.ItemRenderType type) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(type, "type");
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, @NotNull IItemRenderer.ItemRendererHelper helper) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(helper, "helper");
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(data, "data");
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, Arrays.copyOf(data, data.length));
        } else {
            FuelHeatFurnaceDescriptor.draw$default(this, null, false, false, 7, null);
        }
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        String string = I18N.tr("Generates heat when supplied with fuel.", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Generates heat when supplied with fuel.\")");
        list.add(string);
        String string2 = I18N.tr("  Max. temperature: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string2, "tr(\"  Max. temperature: \")");
        list.add(Utils.plotCelsius(string2, this.thermal.maximumTemperature));
    }
}

