/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataOutputStream;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ResistorHeatThermalLoad;
import mods.eln.sixnode.resistor.ResistorContainer;
import mods.eln.transparentnode.LargeRheostatDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001VB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u001a\u0010/\u001a\u0004\u0018\u00010=2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0014\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020@0?H\u0016J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020DH\u0016J\u0012\u0010E\u001a\u00020D2\b\u0010\u001d\u001a\u0004\u0018\u00010FH\u0016J\u0010\u0010G\u001a\u00020@2\u0006\u00107\u001a\u000208H\u0016J\u0010\u0010H\u001a\u00020D2\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010K\u001a\u00020L2\u0006\u00107\u001a\u0002082\u0006\u0010M\u001a\u00020NH\u0016J0\u0010O\u001a\u00020B2\u0006\u0010M\u001a\u00020N2\u0006\u00107\u001a\u0002082\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020QH\u0016J\u0006\u0010T\u001a\u00020DJ\u0010\u0010U\u001a\u00020@2\u0006\u00107\u001a\u000208H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0011\u001a\u00060\u0012R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006W"}, d2={"Lmods/eln/transparentnode/LargeRheostatElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "desc_", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "aLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getALoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "bLoad", "getBLoad", "control", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getControl", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "controlProcess", "Lmods/eln/transparentnode/LargeRheostatElement$ControlProcess;", "getControlProcess", "()Lmods/eln/transparentnode/LargeRheostatElement$ControlProcess;", "desc", "Lmods/eln/transparentnode/LargeRheostatDescriptor;", "getDesc", "()Lmods/eln/transparentnode/LargeRheostatDescriptor;", "heater", "Lmods/eln/sim/process/heater/ResistorHeatThermalLoad;", "getHeater", "()Lmods/eln/sim/process/heater/ResistorHeatThermalLoad;", "inventory", "Lmods/eln/node/transparent/TransparentNodeElementInventory;", "getInventory", "()Lmods/eln/node/transparent/TransparentNodeElementInventory;", "setInventory", "(Lmods/eln/node/transparent/TransparentNodeElementInventory;)V", "nominalRs", "", "getNominalRs", "()D", "setNominalRs", "(D)V", "resistor", "Lmods/eln/sim/mna/component/Resistor;", "getResistor", "()Lmods/eln/sim/mna/component/Resistor;", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "", "initialize", "", "inventoryChange", "Lnet/minecraft/inventory/IInventory;", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "newContainer", "Lmods/eln/sixnode/resistor/ResistorContainer;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "vx", "", "vy", "vz", "setupPhysical", "thermoMeterString", "ControlProcess", "Eln"})
@SourceDebugExtension(value={"SMAP\nLargeRheostat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LargeRheostat.kt\nmods/eln/transparentnode/LargeRheostatElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public final class LargeRheostatElement
extends TransparentNodeElement {
    @NotNull
    private final LargeRheostatDescriptor desc;
    private double nominalRs;
    @NotNull
    private TransparentNodeElementInventory inventory;
    @NotNull
    private final NbtElectricalLoad aLoad;
    @NotNull
    private final NbtElectricalLoad bLoad;
    @NotNull
    private final Resistor resistor;
    @NotNull
    private final NbtElectricalGateInput control;
    @NotNull
    private final ControlProcess controlProcess;
    @NotNull
    private final NbtThermalLoad thermalLoad;
    @NotNull
    private final ResistorHeatThermalLoad heater;
    @NotNull
    private final ThermalLoadWatchDog thermalWatchdog;

    /*
     * WARNING - void declaration
     */
    public LargeRheostatElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor desc_) {
        void $this$resistor_u24lambda_u240;
        Resistor resistor;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(desc_, "desc_");
        super(node, desc_);
        this.desc = (LargeRheostatDescriptor)desc_;
        this.nominalRs = 1.0;
        this.inventory = new TransparentNodeElementInventory(2, 64, this);
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.bLoad = new NbtElectricalLoad("bLoad");
        Resistor resistor2 = resistor = new Resistor(this.aLoad, this.bLoad);
        LargeRheostatElement largeRheostatElement = this;
        boolean bl = false;
        $this$resistor_u24lambda_u240.setResistance(this.nominalRs);
        largeRheostatElement.resistor = resistor;
        this.control = new NbtElectricalGateInput("control");
        this.controlProcess = new ControlProcess();
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.heater = new ResistorHeatThermalLoad(this.resistor, this.thermalLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
        this.grounded = false;
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.resistor);
        this.electricalLoadList.add(this.control);
        this.slowProcessList.add(this.controlProcess);
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalFastProcessList.add(this.heater);
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setMaximumTemperature(this.desc.getDissipator().warmLimit).setDestroys(new WorldExplosion(this).machineExplosion());
    }

    @NotNull
    public final LargeRheostatDescriptor getDesc() {
        return this.desc;
    }

    public final double getNominalRs() {
        return this.nominalRs;
    }

    public final void setNominalRs(double d) {
        this.nominalRs = d;
    }

    @NotNull
    public TransparentNodeElementInventory getInventory() {
        return this.inventory;
    }

    public void setInventory(@NotNull TransparentNodeElementInventory transparentNodeElementInventory) {
        Intrinsics.checkNotNullParameter(transparentNodeElementInventory, "<set-?>");
        this.inventory = transparentNodeElementInventory;
    }

    @NotNull
    public final NbtElectricalLoad getALoad() {
        return this.aLoad;
    }

    @NotNull
    public final NbtElectricalLoad getBLoad() {
        return this.bLoad;
    }

    @NotNull
    public final Resistor getResistor() {
        return this.resistor;
    }

    @NotNull
    public final NbtElectricalGateInput getControl() {
        return this.control;
    }

    @NotNull
    public final ControlProcess getControlProcess() {
        return this.controlProcess;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    @NotNull
    public final ResistorHeatThermalLoad getHeater() {
        return this.heater;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog() {
        return this.thermalWatchdog;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        Direction direction = side;
        return direction == this.front.right() ? (ElectricalLoad)this.aLoad : (direction == this.front.left() ? (ElectricalLoad)this.bLoad : (direction == this.front ? (ElectricalLoad)this.control : null));
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        return side == this.front.back() ? (ThermalLoad)this.thermalLoad : null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return 0;
        }
        Direction direction = side;
        return direction == this.front ? 4 : (direction == this.front.back() ? 2 : 1);
    }

    public final void setupPhysical() {
        this.nominalRs = this.desc.getRsValue((IInventory)this.getInventory());
        this.controlProcess.process(0.0);
    }

    @Override
    public void inventoryChange(@Nullable IInventory inventory) {
        super.inventoryChange(inventory);
        this.setupPhysical();
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        double u = -Math.abs(this.aLoad.getVoltage() - this.bLoad.getVoltage());
        double i = Math.abs(this.resistor.getCurrent());
        return Utils.plotOhm(Utils.plotUIP(u, i), this.resistor.getResistance()) + Utils.plotPercent("C", this.control.getNormalized());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotCelsius("T: ", this.thermalLoad.temperatureCelsius) + Utils.plotPower("P: ", this.thermalLoad.getPower());
    }

    @Override
    public void initialize() {
        this.desc.getDissipator().applyTo(this.thermalLoad);
        this.aLoad.setSerialResistance(1.0E-9);
        this.bLoad.setSerialResistance(1.0E-9);
        this.setupPhysical();
        this.connect();
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat((float)this.thermalLoad.temperatureCelsius);
        stream.writeFloat((float)this.control.getNormalized());
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    @NotNull
    public ResistorContainer newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new ResistorContainer(player, (IInventory)this.getInventory());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Pair[] pairArray = new Pair[]{new Pair<String, String>(I18N.tr("Resistance", new Object[0]), Utils.plotOhm("", this.resistor.getResistance())), new Pair<String, String>(I18N.tr("Temperature", new Object[0]), Utils.plotCelsius("", this.thermalLoad.getTemperature())), new Pair<String, String>(I18N.tr("Power loss", new Object[0]), Utils.plotPower("", this.resistor.getPower()))};
        return MapsKt.mutableMapOf(pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000f"}, d2={"Lmods/eln/transparentnode/LargeRheostatElement$ControlProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/transparentnode/LargeRheostatElement;)V", "lastC", "", "getLastC", "()D", "setLastC", "(D)V", "lastH", "getLastH", "setLastH", "process", "", "time", "Eln"})
    public final class ControlProcess
    implements IProcess {
        private double lastC = -1000.0;
        private double lastH = -1000.0;

        public final double getLastC() {
            return this.lastC;
        }

        public final void setLastC(double d) {
            this.lastC = d;
        }

        public final double getLastH() {
            return this.lastH;
        }

        public final void setLastH(double d) {
            this.lastH = d;
        }

        @Override
        public void process(double time) {
            double desiredRs = (LargeRheostatElement.this.getControl().getNormalized() + 0.01) / 1.01 * LargeRheostatElement.this.getNominalRs();
            if (desiredRs > this.lastC * 1.01 || desiredRs < this.lastC * 0.99) {
                LargeRheostatElement.this.getResistor().setResistance(desiredRs);
                this.lastC = desiredRs;
                LargeRheostatElement.this.needPublish();
            }
            if (LargeRheostatElement.this.getThermalLoad().temperatureCelsius > this.lastH * 1.05 || LargeRheostatElement.this.getThermalLoad().temperatureCelsius < this.lastH * 0.95) {
                this.lastH = LargeRheostatElement.this.getThermalLoad().temperatureCelsius;
                LargeRheostatElement.this.needPublish();
            }
        }
    }
}

