/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.NixieTubeElement;
import mods.eln.transparentnode.NixieTubeRender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001fH\u0016J\u001e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020&J\u001a\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016R!\u0010\u0007\u001a\u0012 \t*\b\u0018\u00010\bR\u00020\u00050\bR\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012 \t*\b\u0018\u00010\bR\u00020\u00050\bR\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0012 \t*\b\u0018\u00010\bR\u00020\u00050\bR\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006."}, d2={"Lmods/eln/transparentnode/NixieTubeDescriptor;", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "name", "", "obj", "Lmods/eln/misc/Obj3D;", "(Ljava/lang/String;Lmods/eln/misc/Obj3D;)V", "base", "Lmods/eln/misc/Obj3D$Obj3DPart;", "mods.eln.shadow.kotlin.jvm.PlatformType", "getBase", "()Lmods/eln/misc/Obj3D$Obj3DPart;", "display", "getDisplay", "getName", "()Ljava/lang/String;", "getObj", "()Lmods/eln/misc/Obj3D;", "pinDistance", "", "getPinDistance", "()[F", "tube", "getTube", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "addRealismContext", "Lmods/eln/misc/RealisticEnum;", "draw", "_digit", "", "blank", "_dots", "getFrontFromPlace", "Lmods/eln/misc/Direction;", "side", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "Eln"})
public final class NixieTubeDescriptor
extends TransparentNodeDescriptor {
    @NotNull
    private final String name;
    @NotNull
    private final Obj3D obj;
    private final Obj3D.Obj3DPart display;
    private final Obj3D.Obj3DPart base;
    private final Obj3D.Obj3DPart tube;
    @NotNull
    private final float[] pinDistance;

    public NixieTubeDescriptor(@NotNull String name, @NotNull Obj3D obj) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(obj, "obj");
        super(name, NixieTubeElement.class, NixieTubeRender.class, null, 8, null);
        this.name = name;
        this.obj = obj;
        this.display = this.obj.getPart("display");
        this.base = this.obj.getPart("base");
        this.tube = this.obj.getPart("tube");
        Obj3D.Obj3DPart obj3DPart = this.base;
        Intrinsics.checkNotNullExpressionValue(obj3DPart, "base");
        this.pinDistance = Utils.getSixNodePinDistance(obj3DPart);
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Obj3D getObj() {
        return this.obj;
    }

    public final Obj3D.Obj3DPart getDisplay() {
        return this.display;
    }

    public final Obj3D.Obj3DPart getBase() {
        return this.base;
    }

    public final Obj3D.Obj3DPart getTube() {
        return this.tube;
    }

    @NotNull
    public final float[] getPinDistance() {
        return this.pinDistance;
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @Nullable List<String> list, boolean par4) {
        block0: {
            super.addInformation(itemStack, entityPlayer, list, par4);
            List<String> list2 = list;
            if (list2 == null) break block0;
            String string = I18N.tr("Displays a single glowing digit.", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Displays a single glowing digit.\")");
            list2.add(string);
        }
    }

    @Override
    @NotNull
    public RealisticEnum addRealismContext(@Nullable List<String> list) {
        block1: {
            List<String> list2 = list;
            if (list2 != null) {
                String string = I18N.tr("Signal input doesn't require power, and interfaces are tailored to gameplay", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"Signal input doesn't\u2026re tailored to gameplay\")");
                list2.add(string);
            }
            List<String> list3 = list;
            if (list3 == null) break block1;
            String string = I18N.tr("Nixie tube has been textured realistically", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Nixie tube has been textured realistically\")");
            list3.add(string);
        }
        return RealisticEnum.UNREALISTIC;
    }

    public final void draw(int _digit, boolean blank, int _dots) {
        int dots;
        int digit = _digit;
        if (digit < 0) {
            digit = 0;
        }
        if (digit > 9) {
            digit = 9;
        }
        if ((dots = _dots) < 0) {
            dots = 0;
        }
        if (dots > 3) {
            dots = 3;
        }
        this.base.draw();
        UtilsClient.enableBlend();
        UtilsClient.disableLight();
        UtilsClient.disableCulling();
        this.obj.bindTexture("digit_atlas.png");
        GL11.glColor4f((float)1.0f, (float)0.4f, (float)0.2f, (float)1.0f);
        if (blank) {
            this.display.draw(0.625f, 0.0f);
        } else {
            this.display.draw((float)digit / 16.0f, 0.0f);
            if (dots != 0) {
                this.display.draw((11.0f + (float)dots) / 16.0f, 0.0f);
            }
        }
        UtilsClient.enableLight();
        UtilsClient.enableCulling();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        this.tube.draw();
        UtilsClient.disableBlend();
    }

    @Override
    @NotNull
    public Direction getFrontFromPlace(@NotNull Direction side, @Nullable EntityLivingBase entityLiving) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Direction direction = super.getFrontFromPlace(side, entityLiving);
        Intrinsics.checkNotNull((Object)direction);
        return direction.getInverse();
    }
}

