/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.transparentnode.NixieTubeDescriptor;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001KB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001a\u00106\u001a\u0004\u0018\u0001072\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001a\u00108\u001a\u0004\u0018\u0001092\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0014\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<0;H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020<2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020BH\u0016J0\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u00020E2\u0006\u00102\u001a\u0002032\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020GH\u0016J\u0010\u0010J\u001a\u00020<2\u0006\u00102\u001a\u000203H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR\u0011\u0010 \u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\nR\u001a\u0010\"\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000e\"\u0004\b$\u0010\u0010R\u001a\u0010%\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016R\u001a\u0010(\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\u001e\u0010+\u001a\u00060,R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006L"}, d2={"Lmods/eln/transparentnode/NixieTubeElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "_descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "blankIn", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getBlankIn", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "curBlank", "", "getCurBlank", "()Z", "setCurBlank", "(Z)V", "curDigit", "", "getCurDigit", "()I", "setCurDigit", "(I)V", "curDots", "getCurDots", "setCurDots", "descriptor", "Lmods/eln/transparentnode/NixieTubeDescriptor;", "getDescriptor", "()Lmods/eln/transparentnode/NixieTubeDescriptor;", "digitIn", "getDigitIn", "dotsIn", "getDotsIn", "lastBlank", "getLastBlank", "setLastBlank", "lastDigit", "getLastDigit", "setLastDigit", "lastDots", "getLastDots", "setLastDots", "process", "Lmods/eln/transparentnode/NixieTubeElement$NixieTubeProcess;", "getProcess", "()Lmods/eln/transparentnode/NixieTubeElement$NixieTubeProcess;", "setProcess", "(Lmods/eln/transparentnode/NixieTubeElement$NixieTubeProcess;)V", "getConnectionMask", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "thermoMeterString", "NixieTubeProcess", "Eln"})
public final class NixieTubeElement
extends TransparentNodeElement {
    @NotNull
    private final NixieTubeDescriptor descriptor;
    @NotNull
    private final NbtElectricalGateInput digitIn;
    @NotNull
    private final NbtElectricalGateInput blankIn;
    @NotNull
    private final NbtElectricalGateInput dotsIn;
    private int curDigit;
    private int lastDigit;
    private boolean curBlank;
    private boolean lastBlank;
    private int curDots;
    private int lastDots;
    @NotNull
    private NixieTubeProcess process;

    public NixieTubeElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor _descriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(_descriptor, "_descriptor");
        super(node, _descriptor);
        this.descriptor = (NixieTubeDescriptor)_descriptor;
        this.digitIn = new NbtElectricalGateInput("digitIn");
        this.blankIn = new NbtElectricalGateInput("blankIn");
        this.dotsIn = new NbtElectricalGateInput("dotsIn");
        this.process = new NixieTubeProcess();
    }

    @Override
    @NotNull
    public NixieTubeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final NbtElectricalGateInput getDigitIn() {
        return this.digitIn;
    }

    @NotNull
    public final NbtElectricalGateInput getBlankIn() {
        return this.blankIn;
    }

    @NotNull
    public final NbtElectricalGateInput getDotsIn() {
        return this.dotsIn;
    }

    public final int getCurDigit() {
        return this.curDigit;
    }

    public final void setCurDigit(int n) {
        this.curDigit = n;
    }

    public final int getLastDigit() {
        return this.lastDigit;
    }

    public final void setLastDigit(int n) {
        this.lastDigit = n;
    }

    public final boolean getCurBlank() {
        return this.curBlank;
    }

    public final void setCurBlank(boolean bl) {
        this.curBlank = bl;
    }

    public final boolean getLastBlank() {
        return this.lastBlank;
    }

    public final void setLastBlank(boolean bl) {
        this.lastBlank = bl;
    }

    public final int getCurDots() {
        return this.curDots;
    }

    public final void setCurDots(int n) {
        this.curDots = n;
    }

    public final int getLastDots() {
        return this.lastDots;
    }

    public final void setLastDots(int n) {
        this.lastDots = n;
    }

    @NotNull
    public final NixieTubeProcess getProcess() {
        return this.process;
    }

    public final void setProcess(@NotNull NixieTubeProcess nixieTubeProcess) {
        Intrinsics.checkNotNullParameter(nixieTubeProcess, "<set-?>");
        this.process = nixieTubeProcess;
    }

    @Override
    public void initialize() {
        this.electricalLoadList.add(this.digitIn);
        this.electricalLoadList.add(this.blankIn);
        this.electricalLoadList.add(this.dotsIn);
        this.slowProcessList.add(this.process);
        this.reconnect();
        Utils.println("NTE.initialize");
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        Direction direction = side;
        return direction == this.front ? (ElectricalLoad)this.dotsIn : (direction == this.front.getInverse() ? (ElectricalLoad)this.digitIn : (ElectricalLoad)this.blankIn);
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return 0;
        }
        return 4;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            transparentNode.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
            stream.writeByte(this.curDigit);
            stream.writeBoolean(this.curBlank);
            stream.writeByte(this.curDots);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "";
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotVolt("N:", this.digitIn.getSignalVoltage()) + ' ' + Utils.plotVolt("B:", this.blankIn.getSignalVoltage()) + ' ' + Utils.plotVolt("D:", this.dotsIn.getSignalVoltage());
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        String string;
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Digit", String.valueOf(this.curDigit));
        info.put("Blank", String.valueOf(this.curBlank));
        switch (this.curDots) {
            case 1: {
                string = "low";
                break;
            }
            case 2: {
                string = "high";
                break;
            }
            case 3: {
                string = "both";
                break;
            }
            default: {
                string = "none";
            }
        }
        info.put("Dots", string);
        return info;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmods/eln/transparentnode/NixieTubeElement$NixieTubeProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/transparentnode/NixieTubeElement;)V", "process", "", "time", "", "Eln"})
    public final class NixieTubeProcess
    implements IProcess {
        @Override
        public void process(double time) {
            NixieTubeElement.this.setCurDigit((int)(NixieTubeElement.this.getDigitIn().getNormalized() * 10.0));
            if (NixieTubeElement.this.getCurDigit() > 9) {
                NixieTubeElement.this.setCurDigit(9);
            }
            NixieTubeElement.this.setCurBlank(NixieTubeElement.this.getBlankIn().getNormalized() >= 0.5);
            NixieTubeElement.this.setCurDots((int)(NixieTubeElement.this.getDotsIn().getNormalized() * 4.0));
            if (NixieTubeElement.this.getCurDots() > 3) {
                NixieTubeElement.this.setCurDots(3);
            }
            if (NixieTubeElement.this.getCurDigit() != NixieTubeElement.this.getLastDigit()) {
                NixieTubeElement.this.setLastDigit(NixieTubeElement.this.getCurDigit());
                NixieTubeElement.this.needPublish();
            }
            if (NixieTubeElement.this.getCurBlank() != NixieTubeElement.this.getLastBlank()) {
                NixieTubeElement.this.setLastBlank(NixieTubeElement.this.getCurBlank());
                NixieTubeElement.this.needPublish();
            }
            if (NixieTubeElement.this.getCurDots() != NixieTubeElement.this.getLastDots()) {
                NixieTubeElement.this.setLastDots(NixieTubeElement.this.getCurDots());
                NixieTubeElement.this.needPublish();
            }
        }
    }
}

