/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.item.ElectricalDrillDescriptor;
import mods.eln.item.MiningPipeDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.autominer.AutoMinerContainer;
import mods.eln.transparentnode.autominer.AutoMinerDescriptor;
import mods.eln.transparentnode.autominer.AutoMinerPowerNode;
import mods.eln.transparentnode.autominer.AutoMinerSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class AutoMinerElement
extends TransparentNodeElement {
    AutoAcceptInventoryProxy inventory = new AutoAcceptInventoryProxy((IInventory)new TransparentNodeElementInventory(3, 64, this)).acceptIfIncrement(2, 64, MiningPipeDescriptor.class).acceptIfEmpty(0, ElectricalDrillDescriptor.class);
    NbtElectricalLoad inPowerLoad = new NbtElectricalLoad("inPowerLoad");
    AutoMinerSlowProcess slowProcess = new AutoMinerSlowProcess(this);
    Resistor powerResistor = new Resistor(this.inPowerLoad, null);
    final AutoMinerDescriptor descriptor;
    Coordinate lightCoordinate;
    private final VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.inPowerLoad);
    private final ArrayList<AutoMinerPowerNode> powerNodeList = new ArrayList();
    boolean powerOk = false;
    public static final byte pushLogId = 1;
    public static final byte toggleSilkTouch = 2;

    public AutoMinerElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (AutoMinerDescriptor)descriptor;
        this.electricalLoadList.add(this.inPowerLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.setNominalVoltage(this.descriptor.nominalVoltage).setDestroys(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.inPowerLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        return 1;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotUIP(this.inPowerLoad.getVoltage(), this.inPowerLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return "";
    }

    @Override
    public void initialize() {
        this.lightCoordinate = new Coordinate(this.descriptor.lightCoord);
        this.lightCoordinate.applyTransformation(this.front, this.node.coordinate);
        int idx = 0;
        for (Coordinate c : this.descriptor.getPowerCoordonate(this.node.coordinate.world())) {
            AutoMinerPowerNode n = new AutoMinerPowerNode();
            n.setElement(this);
            c.applyTransformation(this.front, this.node.coordinate);
            Direction dir = idx != 0 ? this.front.left() : this.front.right();
            n.onBlockPlacedBy(c, dir, null, null);
            this.powerNodeList.add(n);
            ++idx;
        }
        this.descriptor.applyTo(this.inPowerLoad);
        this.connect();
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        this.slowProcess.onBreakElement();
        for (AutoMinerPowerNode n : this.powerNodeList) {
            n.onBreakBlock();
        }
        this.powerNodeList.clear();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return this.inventory.take(player.func_71045_bC());
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new AutoMinerContainer(player, this.inventory.getInventory());
    }

    @Override
    public IInventory getInventory() {
        return this.inventory.getInventory();
    }

    @Override
    public void ghostDestroyed(int UUID) {
        if (UUID == this.descriptor.getGhostGroupUuid()) {
            super.ghostDestroyed(UUID);
        }
        this.slowProcess.ghostDestroyed();
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeShort(this.slowProcess.pipeLength);
            stream.writeByte(this.slowProcess.job.ordinal());
            stream.writeBoolean(this.powerOk);
            stream.writeBoolean(this.slowProcess.silkTouch);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPowerOk(boolean b) {
        this.powerOk = b;
        if (this.powerOk != this.powerOk) {
            this.needPublish();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powerOk", this.powerOk);
        nbt.func_74757_a("silkTouch", this.slowProcess.silkTouch);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerOk = nbt.func_74767_n("powerOk");
        this.slowProcess.silkTouch = nbt.func_74767_n("silkTouch");
    }

    void pushLog(String log) {
        this.sendStringToAllClient((byte)1, log);
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        switch (packetType) {
            case 2: {
                this.slowProcess.toggleSilkTouch();
                this.needPublish();
                break;
            }
            default: {
                return packetType;
            }
        }
        return -128;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Silk touch", new Object[0]), this.slowProcess.silkTouch ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        info.put(I18N.tr("Depth", new Object[0]), Utils.plotValue(this.slowProcess.pipeLength, "m "));
        return info;
    }
}

