/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import mods.eln.gui.GuiButtonEln;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.transparentnode.autominer.AutoMinerContainer;
import mods.eln.transparentnode.autominer.AutoMinerRender;
import mods.eln.transparentnode.autominer.AutoMinerSlowProcess;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class AutoMinerGuiDraw
extends GuiContainerEln {
    private static final String SK_TOUCH = I18N.tr("Silk Touch", new Object[0]);
    private final AutoMinerRender render;
    private GuiButtonEln silkTouch;

    public AutoMinerGuiDraw(EntityPlayer player, IInventory inventory, AutoMinerRender render) {
        super(new AutoMinerContainer(player, inventory));
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.silkTouch = this.newGuiButton(7, 6, 122, SK_TOUCH);
        this.silkTouch.setComment(0, I18N.tr("Halves speed, triples power draw", new Object[0]));
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        String text = this.render.silkTouch ? I18N.tr("On", new Object[0]) : I18N.tr("Off", new Object[0]);
        this.silkTouch.field_146126_j = String.format("%s %s", SK_TOUCH, text);
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        if (this.render.job == AutoMinerSlowProcess.jobType.chestFull) {
            this.silkTouch.field_146125_m = false;
            String[] text = I18N.tr("Chest missing on the\nback of the auto miner!", new Object[0]).split("\n");
            this.drawString(8, 7, text[0]);
            if (text.length >= 2) {
                this.drawString(8, 16, text[1]);
            }
        } else {
            this.silkTouch.field_146125_m = true;
        }
        super.postDraw(f, x, y);
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        if (object == this.silkTouch) {
            this.render.clientSendId((byte)2);
        }
        super.guiObjectEvent(object);
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new GuiHelperContainer((GuiScreen)this, 176, 112, 8, 30);
    }
}

