/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.GhostNode;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.transparentnode.autominer.AutoMinerElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AutoMinerPowerNode
extends GhostNode {
    private Direction front;
    private AutoMinerElement element;

    @Override
    public void initializeFromThat(@NotNull Direction front, @Nullable EntityLivingBase entityLiving, @Nullable ItemStack itemStack) {
        this.front = front;
        this.connect();
    }

    @Override
    public int getSideConnectionMask(Direction directionA, LRDU lrduA) {
        if (this.element == null) {
            return 0;
        }
        if (directionA != this.front) {
            return 0;
        }
        if (lrduA != LRDU.Down) {
            return 0;
        }
        return 1;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction directionA, LRDU lrduA, int mask) {
        return null;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction directionB, LRDU lrduB, int mask) {
        if (this.element == null) {
            return null;
        }
        return this.element.inPowerLoad;
    }

    @Override
    public void initializeFromNBT() {
    }

    void setElement(AutoMinerElement e) {
        this.element = e;
    }

    public void writeToNBT(NBTTagCompound nbt, String str) {
        this.front.writeToNBT(nbt, str + "front");
    }

    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.front = Direction.readFromNBT(nbt, str + "front");
    }
}

