/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import mods.eln.Eln;
import mods.eln.item.electricalitem.PortableOreScannerItem;
import mods.eln.misc.Direction;
import mods.eln.misc.FC;
import mods.eln.misc.PhysicalInterpolatorNoRebound;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import mods.eln.transparentnode.autominer.AutoMinerDescriptor;
import mods.eln.transparentnode.autominer.AutoMinerGuiDraw;
import mods.eln.transparentnode.autominer.AutoMinerSlowProcess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public class AutoMinerRender
extends TransparentNodeElementRender {
    private final AutoMinerDescriptor descriptor;
    private final float[] buttonsState;
    private final boolean[] ledsAState;
    private final boolean[] ledsPState;
    private final PortableOreScannerItem.RenderStorage render;
    private final PhysicalInterpolatorNoRebound pipeLengthInterpol;
    private final RcInterpolator rotSpeed;
    private float pipeAlpha;
    private final LinkedList<String> logs;
    private final int logSizeMax = 9;
    private boolean powerOk;
    private float recalcTimeout;
    private final TransparentNodeElementInventory inventory;
    private short pipeLength;
    AutoMinerSlowProcess.jobType job;
    private boolean boot;
    public boolean silkTouch;

    public AutoMinerRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        int idx;
        this.render = new PortableOreScannerItem.RenderStorage(Eln.instance.autominerRange, 130.0f, 24, 24);
        this.pipeLengthInterpol = new PhysicalInterpolatorNoRebound(0.4f, 2.0f, 0.8f);
        this.rotSpeed = new RcInterpolator(1.0f);
        this.pipeAlpha = 0.0f;
        this.logs = new LinkedList();
        this.logSizeMax = 9;
        this.recalcTimeout = 0.0f;
        this.inventory = new TransparentNodeElementInventory(3, 64, this);
        this.pipeLength = 0;
        this.boot = true;
        this.silkTouch = false;
        this.descriptor = (AutoMinerDescriptor)descriptor;
        this.buttonsState = new float[this.descriptor.buttonsCount];
        for (idx = 0; idx < this.descriptor.buttonsCount; ++idx) {
            this.buttonsState[idx] = (float)Math.random();
        }
        this.ledsAState = new boolean[this.descriptor.ledsACount];
        for (idx = 0; idx < this.descriptor.ledsACount; ++idx) {
            this.ledsAState[idx] = Math.random() > 0.5;
        }
        this.ledsPState = new boolean[this.descriptor.ledsPCount];
        for (idx = 0; idx < this.descriptor.ledsPCount; ++idx) {
            this.ledsPState[idx] = Math.random() > 0.5;
        }
        this.addLoopedSound(new LoopedSound("eln:autominer", this.coordinate(), ISound.AttenuationType.LINEAR){

            @Override
            public float func_147653_e() {
                if (AutoMinerRender.this.powerOk && (AutoMinerRender.this.job == AutoMinerSlowProcess.jobType.ore || AutoMinerRender.this.job == AutoMinerSlowProcess.jobType.pipeAdd || AutoMinerRender.this.job == AutoMinerSlowProcess.jobType.pipeRemove)) {
                    return 2.13f;
                }
                return 0.0f;
            }
        });
    }

    private void pushLog(String string) {
        this.logs.addFirst(string);
        if (this.logs.size() > 9) {
            this.logs.removeLast();
        }
    }

    @Override
    public void draw() {
        int idx;
        GL11.glPushMatrix();
        GL11.glRotatef((float)this.pipeAlpha, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        this.descriptor.pipe.draw();
        GL11.glPopMatrix();
        int len = (int)this.pipeLengthInterpol.get();
        GL11.glTranslatef((float)0.0f, (float)(-(this.pipeLengthInterpol.get() - (float)len)), (float)0.0f);
        for (idx = len + 2; idx != 0; --idx) {
            if (idx != 1) {
                this.descriptor.pipe.draw();
            } else {
                this.descriptor.head.draw();
            }
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
        for (idx = 0; idx < this.descriptor.buttonsCount; ++idx) {
            this.buttonsState[idx] = idx == this.job.ordinal() && this.powerOk ? 1.0f : 0.0f;
        }
        this.front.glRotateXnRef();
        boolean drawScreen = UtilsClient.clientDistanceTo(this.getTileEntity()) < 20.0 && this.powerOk;
        boolean drawRay = drawScreen && this.job != null;
        UtilsClient.disableCulling();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.57031f, (float)0.2925f, (float)-0.2925f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (drawScreen) {
            UtilsClient.disableLight();
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.0078125f, (float)-0.0078125f, (float)1.0f);
            int idx2 = 0;
            for (String log : this.logs) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(idx2 == 0 ? FC.BRIGHT_GREEN + "> " + log.substring(2) : FC.DARK_GREEN + log, 80, 1 + idx2, -3092272);
                idx2 += 8;
            }
            GL11.glPopMatrix();
            UtilsClient.enableLight();
        }
        if (drawRay) {
            float raySize = 0.585f;
            float scale = 1.0f / (float)this.render.resWidth * raySize;
            GL11.glTranslatef((float)(-raySize), (float)0.0f, (float)0.0f);
            GL11.glScalef((float)scale, (float)(-scale), (float)1.0f);
            this.render.draw(0.4f, 1.3f, 0.8f);
        }
        GL11.glPopMatrix();
        UtilsClient.enableCulling();
        this.descriptor.draw(false, this.buttonsState, this.ledsAState, this.ledsPState);
    }

    @Override
    public void refresh(float deltaT) {
        int idx;
        super.refresh(deltaT);
        this.pipeAlpha += this.rotSpeed.get() * deltaT;
        if (this.pipeAlpha > 360.0f) {
            this.pipeAlpha -= 360.0f;
        }
        for (idx = 0; idx < this.descriptor.ledsACount; ++idx) {
            if (this.powerOk) {
                if (!(Math.random() < 0.2 * (double)deltaT)) continue;
                this.ledsAState[idx] = !this.ledsAState[idx];
                continue;
            }
            this.ledsAState[idx] = true;
        }
        for (idx = 0; idx < this.descriptor.ledsPCount; ++idx) {
            if (this.powerOk) {
                if (!(Math.random() < 0.2 * (double)deltaT)) continue;
                this.ledsPState[idx] = !this.ledsPState[idx];
                continue;
            }
            this.ledsPState[idx] = true;
        }
        if (this.powerOk) {
            this.recalcTimeout -= deltaT;
            if (this.recalcTimeout < 0.0f) {
                float camAlpha;
                this.recalcTimeout = (float)((double)this.recalcTimeout + 0.5);
                switch (this.front) {
                    default: {
                        camAlpha = (float)Math.PI;
                        break;
                    }
                    case XP: {
                        camAlpha = 0.0f;
                        break;
                    }
                    case ZN: {
                        camAlpha = -1.5707964f;
                        break;
                    }
                    case ZP: {
                        camAlpha = 1.5707964f;
                    }
                }
                this.render.generate(this.getTileEntity().func_145831_w(), (double)this.getTileEntity().field_145851_c + 0.5, (double)this.getTileEntity().field_145848_d + 0.5 - (double)Math.max(0, this.pipeLength - 5), (double)this.getTileEntity().field_145849_e + 0.5, -1.5707964f + camAlpha, -1.5707964f);
            }
        }
        this.pipeLengthInterpol.step(deltaT);
        if (this.pipeLengthInterpol.get() < 0.0f) {
            this.pipeLengthInterpol.setPos(0.0f);
        }
        this.rotSpeed.step(deltaT);
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new AutoMinerGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.pipeLength = stream.readShort();
            if (this.pipeLength != this.pipeLength) {
                this.recalcTimeout = 0.0f;
            }
            if ((this.job = AutoMinerSlowProcess.jobType.values()[stream.readByte()]) != this.job) {
                switch (this.job) {
                    case ore: {
                        this.rotSpeed.setTarget(360.0f);
                        break;
                    }
                    default: {
                        this.rotSpeed.setTarget(0.0f);
                    }
                }
            }
            this.powerOk = stream.readBoolean();
            this.silkTouch = stream.readBoolean();
            if (!this.powerOk) {
                this.logs.clear();
                this.pushLog("[i] Boot... Done.");
                this.pushLog("* Waiting opcode.");
            }
            if (this.boot) {
                this.boot = false;
                this.pipeLengthInterpol.setPos(this.pipeLength);
            }
            this.pipeLengthInterpol.setTarget(this.pipeLength);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) {
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.pushLog(stream.readUTF());
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }
}

