/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.autominer;

import java.util.ArrayList;
import mods.eln.Eln;
import mods.eln.item.ElectricalDrillDescriptor;
import mods.eln.item.MiningPipeDescriptor;
import mods.eln.item.electricalitem.OreColorMapping;
import mods.eln.misc.Coordinate;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.ore.OreBlock;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.lampsocket.LightBlockEntity;
import mods.eln.transparentnode.autominer.AutoMinerElement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AutoMinerSlowProcess
implements IProcess,
INBTTReady {
    private final AutoMinerElement miner;
    int pipeLength = 0;
    private double energyCounter = 0.0;
    private double energyTarget = 0.0;
    private boolean oneJobDone = true;
    boolean silkTouch = false;
    jobType job = jobType.none;
    private jobType oldJob = jobType.none;
    private final Coordinate jobCoord = new Coordinate();
    private int blinkCounter = 0;
    private int drillCount = 1;
    private ArrayList<ItemStack> itemsToDrop = new ArrayList(4);

    public AutoMinerSlowProcess(AutoMinerElement autoMiner) {
        this.miner = autoMiner;
    }

    void toggleSilkTouch() {
        this.silkTouch = !this.silkTouch;
    }

    private boolean isReadyToDrill() {
        ElectricalDrillDescriptor drill = (ElectricalDrillDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.getInventory().func_70301_a(0));
        if (drill == null) {
            return false;
        }
        return this.isStorageReady();
    }

    private boolean isStorageReady() {
        IInventory i = this.getDropInventory();
        if (i == null) {
            return false;
        }
        for (int idx = 0; idx < i.func_70302_i_(); ++idx) {
            if (i.func_70301_a(idx) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(double time) {
        ElectricalDrillDescriptor drill = (ElectricalDrillDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.getInventory().func_70301_a(0));
        if (++this.blinkCounter >= 9) {
            this.blinkCounter = 0;
            if ((this.miner.inPowerLoad.getVoltage() / this.miner.descriptor.nominalVoltage - 0.5) * 3.0 > Math.random()) {
                this.miner.setPowerOk(true);
                LightBlockEntity.addLight(this.miner.lightCoordinate, 12, 11);
            } else {
                this.miner.setPowerOk(false);
            }
        }
        this.energyCounter += this.miner.powerResistor.getPower() * time;
        if (this.job != jobType.none && this.job != jobType.full && this.job != jobType.chestFull && this.job != jobType.done) {
            if (this.energyCounter >= this.energyTarget || this.job == jobType.ore && !this.isReadyToDrill() || !this.miner.powerOk) {
                this.setupJob();
            }
            if (this.energyCounter >= this.energyTarget) {
                this.oneJobDone = true;
                switch (this.job) {
                    case ore: {
                        ++this.drillCount;
                        Block block = this.jobCoord.world().func_147439_a(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        int meta = this.jobCoord.world().func_72805_g(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        if (this.silkTouch) {
                            this.itemsToDrop.add(new ItemStack(block, 1, meta));
                        } else {
                            this.itemsToDrop.addAll(block.getDrops(this.jobCoord.world(), this.jobCoord.x, this.jobCoord.y, this.jobCoord.z, meta, 0));
                        }
                        int xDist = this.jobCoord.x - this.miner.node.coordinate.x;
                        int zDist = this.jobCoord.z - this.miner.node.coordinate.z;
                        if (xDist * xDist + zDist * zDist > 25) {
                            this.jobCoord.world().func_147449_b(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z, Blocks.field_150347_e);
                        } else {
                            this.jobCoord.world().func_147468_f(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        }
                        this.energyCounter -= this.energyTarget;
                        this.setupJob();
                        break;
                    }
                    case pipeAdd: {
                        Eln.ghostManager.createGhost(this.jobCoord, this.miner.node.coordinate, this.jobCoord.y);
                        this.miner.getInventory().func_70298_a(2, 1);
                        ++this.pipeLength;
                        this.miner.needPublish();
                        this.energyCounter -= this.energyTarget;
                        this.setupJob();
                        break;
                    }
                    case pipeRemove: {
                        Eln.ghostManager.removeGhostAndBlock(this.jobCoord);
                        if (this.miner.getInventory().func_70301_a(2) == null) {
                            this.miner.getInventory().func_70299_a(2, Eln.miningPipeDescriptor.newItemStack(1));
                        } else {
                            this.miner.getInventory().func_70298_a(2, -1);
                        }
                        --this.pipeLength;
                        this.miner.needPublish();
                        this.energyCounter -= this.energyTarget;
                        this.setupJob();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this.setupJob();
        }
        switch (this.job) {
            default: {
                this.miner.powerResistor.highImpedance();
                break;
            }
            case ore: {
                if (drill == null) {
                    this.miner.powerResistor.highImpedance();
                    break;
                }
                double p = drill.nominalPower;
                if (this.silkTouch) {
                    p *= 3.0;
                }
                this.miner.powerResistor.setResistance(Math.pow(this.miner.descriptor.nominalVoltage, 2.0) / p);
                break;
            }
            case pipeAdd: {
                this.miner.powerResistor.setResistance(this.miner.descriptor.pipeOperationRp);
                break;
            }
            case pipeRemove: {
                this.miner.powerResistor.setResistance(this.miner.descriptor.pipeOperationRp);
            }
        }
        if (this.oldJob != this.job) {
            this.miner.needPublish();
        }
        if (this.oneJobDone || this.oldJob != this.job) {
            switch (this.job) {
                case chestFull: {
                    this.miner.pushLog("* Storage full!");
                    break;
                }
                case done: {
                    this.miner.pushLog("- SLEEP");
                    break;
                }
                case full: {
                    this.miner.pushLog("* Pipe stack full!");
                    break;
                }
                case none: {
                    this.miner.pushLog("* Waiting opcode.");
                    break;
                }
                case ore: {
                    this.miner.pushLog("- DRILL #" + this.drillCount);
                    break;
                }
                case pipeAdd: {
                    this.miner.pushLog("- ADD PIPE #" + (this.pipeLength + 1));
                    break;
                }
                case pipeRemove: {
                    this.miner.pushLog("- REMOVE PIPE #" + this.pipeLength);
                    break;
                }
            }
        }
        this.oneJobDone = false;
        this.oldJob = this.job;
    }

    private IInventory getDropInventory() {
        IInventory inventoryEntity = null;
        Coordinate outputLocation = new Coordinate(1, -1, 0, this.miner.world());
        outputLocation.applyTransformation(this.miner.front, this.miner.coordinate());
        if (outputLocation.getTileEntity() instanceof IInventory) {
            IInventory possibleDoubleInventoryEntity;
            inventoryEntity = (IInventory)outputLocation.getTileEntity();
            Block inventoryBlock = this.miner.world().func_147439_a(outputLocation.x, outputLocation.y, outputLocation.z);
            if (inventoryBlock instanceof BlockChest && (possibleDoubleInventoryEntity = ((BlockChest)inventoryBlock).func_149951_m(this.miner.world(), outputLocation.x, outputLocation.y, outputLocation.z)) != null) {
                inventoryEntity = possibleDoubleInventoryEntity;
            }
        }
        return inventoryEntity;
    }

    private boolean drop(ItemStack stack) {
        return Utils.tryPutStackInInventory(stack, this.getDropInventory());
    }

    private boolean isMinable(Block block) {
        return block != Blocks.field_150350_a && block != Blocks.field_150358_i && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150353_l && block != Blocks.field_150343_Z && block != Blocks.field_150357_h;
    }

    private void setupJob() {
        ElectricalDrillDescriptor drill = (ElectricalDrillDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.getInventory().func_70301_a(0));
        MiningPipeDescriptor pipe = (MiningPipeDescriptor)ElectricalDrillDescriptor.getDescriptor(this.miner.getInventory().func_70301_a(2));
        int scannerRadius = Eln.instance.autominerRange;
        double scannerEnergy = 0.0;
        this.jobCoord.dimension = this.miner.node.coordinate.dimension;
        this.jobCoord.x = this.miner.node.coordinate.x;
        this.jobCoord.y = this.miner.node.coordinate.y - this.pipeLength;
        this.jobCoord.z = this.miner.node.coordinate.z;
        while (this.itemsToDrop.size() > 0) {
            int index = this.itemsToDrop.size() - 1;
            if (!this.drop(this.itemsToDrop.get(index))) continue;
            this.itemsToDrop.remove(index);
        }
        boolean jobFind = false;
        if (!this.miner.node.coordinate.getBlockExist()) {
            this.setJob(jobType.none);
        } else if (!this.miner.powerOk) {
            this.setJob(jobType.none);
        } else if (drill == null) {
            if (this.jobCoord.y != this.miner.node.coordinate.y) {
                ItemStack pipeStack = this.miner.getInventory().func_70301_a(2);
                if (pipeStack == null || pipeStack.field_77994_a != pipeStack.func_77976_d() && pipeStack.field_77994_a != this.miner.getInventory().func_70297_j_()) {
                    jobFind = true;
                    this.setJob(jobType.pipeRemove);
                } else {
                    jobFind = true;
                    this.setJob(jobType.full);
                }
            }
        } else if (!this.isStorageReady() || this.itemsToDrop.size() != 0) {
            this.setJob(jobType.chestFull);
            jobFind = true;
        } else if (pipe != null) {
            if (this.jobCoord.y < this.miner.node.coordinate.y - 2) {
                int depth = this.miner.node.coordinate.y - this.jobCoord.y;
                double miningRay = (double)depth / 10.0 + 0.1;
                miningRay = Math.min(miningRay, 2.0);
                if (depth < scannerRadius) {
                    scannerRadius = depth + 1;
                }
                miningRay = Math.min(miningRay, (double)(scannerRadius - 2));
                this.jobCoord.z = this.miner.node.coordinate.z - scannerRadius;
                while (this.jobCoord.z <= this.miner.node.coordinate.z + scannerRadius) {
                    this.jobCoord.x = this.miner.node.coordinate.x - scannerRadius;
                    while (this.jobCoord.x <= this.miner.node.coordinate.x + scannerRadius) {
                        double dx = this.jobCoord.x - this.miner.node.coordinate.x;
                        double dy = 0.0;
                        double dz = this.jobCoord.z - this.miner.node.coordinate.z;
                        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        Block block = this.jobCoord.world().func_147439_a(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                        if (this.checkIsOre(this.jobCoord) || distance > 0.1 && distance < miningRay && this.isMinable(block)) {
                            jobFind = true;
                            this.setJob(jobType.ore);
                            break;
                        }
                        ++this.jobCoord.x;
                    }
                    if (jobFind) break;
                    ++this.jobCoord.z;
                }
            }
            if (!jobFind) {
                if (this.jobCoord.y < 3) {
                    jobFind = true;
                    this.setJob(jobType.done);
                } else {
                    this.jobCoord.x = this.miner.node.coordinate.x;
                    --this.jobCoord.y;
                    this.jobCoord.z = this.miner.node.coordinate.z;
                    Block block = this.jobCoord.world().func_147439_a(this.jobCoord.x, this.jobCoord.y, this.jobCoord.z);
                    if (block != Blocks.field_150350_a && block != Blocks.field_150358_i && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150353_l) {
                        if (block != Blocks.field_150343_Z && block != Blocks.field_150357_h) {
                            jobFind = true;
                            this.setJob(jobType.ore);
                        } else {
                            jobFind = true;
                            this.setJob(jobType.done);
                        }
                    } else {
                        jobFind = true;
                        this.setJob(jobType.pipeAdd);
                    }
                }
            }
        }
        if (!jobFind) {
            this.setJob(jobType.none);
        }
        switch (this.job) {
            case ore: {
                this.energyTarget = drill.OperationEnergy + scannerEnergy;
                if (!this.silkTouch) break;
                this.energyTarget *= 6.0;
                break;
            }
            case pipeAdd: {
                this.energyTarget = this.miner.descriptor.pipeOperationEnergy;
                break;
            }
            case pipeRemove: {
                this.energyTarget = this.miner.descriptor.pipeOperationEnergy;
                break;
            }
            default: {
                this.energyTarget = 0.0;
            }
        }
    }

    private void setJob(jobType job) {
        if (job != this.job) {
            this.miner.needPublish();
            this.energyCounter = 0.0;
        }
        this.job = job;
    }

    private boolean checkIsOre(Coordinate coordinate) {
        Block block = coordinate.world().func_147439_a(coordinate.x, coordinate.y, coordinate.z);
        if (block instanceof BlockOre) {
            return true;
        }
        if (block instanceof OreBlock) {
            return true;
        }
        if (block instanceof BlockRedstoneOre) {
            return true;
        }
        return OreColorMapping.INSTANCE.getMap()[Block.func_149682_b((Block)block) + (coordinate.world().func_72805_g(coordinate.x, coordinate.y, coordinate.z) << 12)] != 0.0f;
    }

    public void onBreakElement() {
        this.destroyPipe();
    }

    private void destroyPipe() {
        this.dropPipe();
        Eln.ghostManager.removeGhostAndBlockWithObserverAndNotUuid(this.miner.node.coordinate, this.miner.descriptor.getGhostGroupUuid());
        this.pipeLength = 0;
        this.miner.needPublish();
    }

    private void dropPipe() {
        Coordinate coord = new Coordinate(this.miner.node.coordinate);
        coord.y = this.miner.node.coordinate.y - 1;
        while (coord.y >= this.miner.node.coordinate.y - this.pipeLength) {
            Utils.dropItem(Eln.miningPipeDescriptor.newItemStack(1), coord);
            --coord.y;
        }
    }

    void ghostDestroyed() {
        this.destroyPipe();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.pipeLength = nbt.func_74762_e(str + "AMSPpipeLength");
        this.drillCount = nbt.func_74762_e(str + "AMSPdrillCount");
        if (this.drillCount == 0) {
            ++this.drillCount;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74768_a(str + "AMSPpipeLength", this.pipeLength);
        nbt.func_74768_a(str + "AMSPdrillCount", this.drillCount);
    }

    static enum jobType {
        none,
        done,
        full,
        chestFull,
        ore,
        pipeAdd,
        pipeRemove;

    }
}

