/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import java.util.Arrays;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.BatteryProcess;
import mods.eln.sim.BatterySlowProcess;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.Simulator;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.transparentnode.battery.BatteryElement;
import mods.eln.transparentnode.battery.BatteryRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\bA\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0006\u0012\u0006\u0010\u0011\u001a\u00020\u0006\u0012\u0006\u0010\u0012\u001a\u00020\u0006\u0012\u0006\u0010\u0013\u001a\u00020\u0006\u0012\u0006\u0010\u0014\u001a\u00020\u0006\u0012\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0016J0\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\b\u0010z\u001a\u0004\u0018\u00010{2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00030}2\u0006\u0010~\u001a\u00020\bH\u0016J\u0019\u0010\u007f\u001a\u00030\u0080\u00012\u000e\u0010|\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010}H\u0016J\u0010\u0010\u0081\u0001\u001a\u00020w2\u0007\u0010\u001c\u001a\u00030\u0082\u0001J\u0011\u0010\u0081\u0001\u001a\u00020w2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u001d\u0010\u0081\u0001\u001a\u00020w2\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001J\u0011\u0010\u0081\u0001\u001a\u00020w2\b\u0010\u0085\u0001\u001a\u00030\u0089\u0001J\u0011\u0010\u0081\u0001\u001a\u00020w2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J\u0019\u0010\u008c\u0001\u001a\u00020w2\u0007\u0010\u008d\u0001\u001a\u00020\b2\u0007\u0010\u008e\u0001\u001a\u00020\bJ\u0010\u0010\u008f\u0001\u001a\u00020\u00062\u0007\u0010\u0090\u0001\u001a\u00020yJ\n\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0016J\u0019\u0010\u0093\u0001\u001a\u00020\u00062\u0007\u0010\u0094\u0001\u001a\u00020\u00062\u0007\u0010\u0095\u0001\u001a\u00020\u0006J\u0010\u0010\u0096\u0001\u001a\u00020\u00062\u0007\u0010\u0090\u0001\u001a\u00020yJ\u0012\u0010\u0097\u0001\u001a\u00020\u00032\u0007\u0010\u0090\u0001\u001a\u00020yH\u0016J\u001c\u0010\u0098\u0001\u001a\u00020\b2\u0007\u0010\u0099\u0001\u001a\u00020y2\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0016J\u0013\u0010\u009c\u0001\u001a\u00020\b2\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0016J:\u0010\u009f\u0001\u001a\u00020w2\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u0099\u0001\u001a\u00020y2\u0016\u0010\u00a0\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00a2\u00010\u00a1\u0001\"\u00030\u00a2\u0001H\u0016\u00a2\u0006\u0003\u0010\u00a3\u0001J\u0017\u0010\u00a4\u0001\u001a\u00020w2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006J\u001c\u0010\u00a5\u0001\u001a\u00020w2\b\u0010\u0099\u0001\u001a\u00030\u00a6\u00012\u0007\u0010\u00a7\u0001\u001a\u00020`H\u0016J\u000f\u0010\u00a8\u0001\u001a\u00020w2\u0006\u0010^\u001a\u00020\u0003J&\u0010\u00a9\u0001\u001a\u00020\b2\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u0099\u0001\u001a\u00020y2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001H\u0016R\u0012\u0010\u0017\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010&\"\u0004\b*\u0010(R\u001a\u0010+\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010&\"\u0004\b-\u0010(R\u0012\u0010.\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010&\"\u0004\b1\u0010(R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010&\"\u0004\b3\u0010(R\u0012\u00104\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010&\"\u0004\b6\u0010(R\u001a\u00107\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010&\"\u0004\b9\u0010(R\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010&\"\u0004\b;\u0010(R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010&\"\u0004\b=\u0010(R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010>\"\u0004\b?\u0010@R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010>\"\u0004\bB\u0010@R\u001a\u0010C\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010&\"\u0004\bE\u0010(R\u001a\u0010F\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010&\"\u0004\bH\u0010(R \u0010I\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010 \"\u0004\bK\u0010\"R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR \u0010P\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010 \"\u0004\bR\u0010\"R\u001c\u0010S\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR \u0010X\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010 \"\u0004\bZ\u0010\"R \u0010[\u001a\b\u0018\u00010\u001dR\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010 \"\u0004\b]\u0010\"R\u0010\u0010^\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010_\u001a\u00020`X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010&\"\u0004\bf\u0010(R\u001a\u0010g\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010&\"\u0004\bi\u0010(R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010&\"\u0004\bk\u0010(R\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010&\"\u0004\bm\u0010(R\u001a\u0010n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010&\"\u0004\bp\u0010(R\u001a\u0010q\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010&\"\u0004\bs\u0010(R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010&\"\u0004\bu\u0010(\u00a8\u0006\u00ac\u0001"}, d2={"Lmods/eln/transparentnode/battery/BatteryDescriptor;", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "name", "", "modelName", "startCharge", "", "isRechargable", "", "lifeEnable", "UfCharge", "Lmods/eln/misc/FunctionTable;", "electricalU", "electricalPMax", "electricalDischargeRate", "electricalStdP", "electricalStdDischargeTime", "electricalStdEfficiency", "electricalStdHalfLife", "thermalHeatTime", "thermalWarmLimit", "thermalCoolLimit", "(Ljava/lang/String;Ljava/lang/String;DZZLmods/eln/misc/FunctionTable;DDDDDDDDDD)V", "IMax", "getUfCharge", "()Lmods/eln/misc/FunctionTable;", "setUfCharge", "(Lmods/eln/misc/FunctionTable;)V", "battery", "Lmods/eln/misc/Obj3D$Obj3DPart;", "Lmods/eln/misc/Obj3D;", "getBattery", "()Lmods/eln/misc/Obj3D$Obj3DPart;", "setBattery", "(Lmods/eln/misc/Obj3D$Obj3DPart;)V", "currentDropFactor", "currentDropVoltage", "getElectricalDischargeRate", "()D", "setElectricalDischargeRate", "(D)V", "getElectricalPMax", "setElectricalPMax", "electricalQ", "getElectricalQ", "setElectricalQ", "electricalRp", "electricalRs", "getElectricalStdDischargeTime", "setElectricalStdDischargeTime", "getElectricalStdEfficiency", "setElectricalStdEfficiency", "electricalStdEnergy", "getElectricalStdHalfLife", "setElectricalStdHalfLife", "electricalStdI", "getElectricalStdI", "setElectricalStdI", "getElectricalStdP", "setElectricalStdP", "getElectricalU", "setElectricalU", "()Z", "setRechargable", "(Z)V", "getLifeEnable", "setLifeEnable", "lifeNominalCurrent", "getLifeNominalCurrent", "setLifeNominalCurrent", "lifeNominalLost", "getLifeNominalLost", "setLifeNominalLost", "main", "getMain", "setMain", "getModelName", "()Ljava/lang/String;", "setModelName", "(Ljava/lang/String;)V", "modelPart", "getModelPart", "setModelPart", "obj", "getObj", "()Lmods/eln/misc/Obj3D;", "setObj", "(Lmods/eln/misc/Obj3D;)V", "plugPlus", "getPlugPlus", "setPlugPlus", "plusMinus", "getPlusMinus", "setPlusMinus", "renderSpec", "renderType", "", "getRenderType", "()I", "setRenderType", "(I)V", "getStartCharge", "setStartCharge", "thermalC", "getThermalC", "setThermalC", "getThermalCoolLimit", "setThermalCoolLimit", "getThermalHeatTime", "setThermalHeatTime", "thermalPMax", "getThermalPMax", "setThermalPMax", "thermalRp", "getThermalRp", "setThermalRp", "getThermalWarmLimit", "setThermalWarmLimit", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "addRealismContext", "Lmods/eln/misc/RealisticEnum;", "applyTo", "Lmods/eln/sim/BatteryProcess;", "process", "Lmods/eln/sim/BatterySlowProcess;", "load", "Lmods/eln/sim/ElectricalLoad;", "simulator", "Lmods/eln/sim/Simulator;", "Lmods/eln/sim/ThermalLoad;", "resistor", "Lmods/eln/sim/mna/component/Resistor;", "draw", "plus", "minus", "getChargeInTag", "stack", "getDefaultNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "getEnergy", "charge", "life", "getLifeInTag", "getName", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "onEntityItemUpdate", "entityItem", "Lnet/minecraft/entity/item/EntityItem;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setCurrentDrop", "setParent", "Lnet/minecraft/item/Item;", "damage", "setRenderSpec", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "Eln"})
public final class BatteryDescriptor
extends TransparentNodeDescriptor {
    private double startCharge;
    private boolean isRechargable;
    private boolean lifeEnable;
    @NotNull
    private FunctionTable UfCharge;
    private double electricalU;
    private double electricalPMax;
    private double electricalDischargeRate;
    private double electricalStdP;
    private double electricalStdDischargeTime;
    private double electricalStdEfficiency;
    private double electricalStdHalfLife;
    private double thermalHeatTime;
    private double thermalWarmLimit;
    private double thermalCoolLimit;
    @JvmField
    public double electricalStdEnergy;
    private double electricalStdI;
    private double electricalQ;
    @JvmField
    public double electricalRs;
    @JvmField
    public double electricalRp;
    private double thermalC;
    private double thermalRp;
    private double thermalPMax;
    private double lifeNominalCurrent;
    private double lifeNominalLost;
    @Nullable
    private String modelName;
    @Nullable
    private Obj3D.Obj3DPart modelPart;
    @JvmField
    public double IMax;
    @Nullable
    private Obj3D obj;
    @Nullable
    private Obj3D.Obj3DPart main;
    @Nullable
    private Obj3D.Obj3DPart plugPlus;
    @Nullable
    private Obj3D.Obj3DPart plusMinus;
    @Nullable
    private Obj3D.Obj3DPart battery;
    private int renderType;
    @Nullable
    private String renderSpec;
    @JvmField
    public double currentDropVoltage;
    @JvmField
    public double currentDropFactor;

    public BatteryDescriptor(@NotNull String name, @NotNull String modelName, double startCharge, boolean isRechargable, boolean lifeEnable, @NotNull FunctionTable UfCharge, double electricalU, double electricalPMax, double electricalDischargeRate, double electricalStdP, double electricalStdDischargeTime, double electricalStdEfficiency, double electricalStdHalfLife, double thermalHeatTime, double thermalWarmLimit, double thermalCoolLimit) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(modelName, "modelName");
        Intrinsics.checkNotNullParameter(UfCharge, "UfCharge");
        super(name, BatteryElement.class, BatteryRender.class, null, 8, null);
        this.startCharge = startCharge;
        this.isRechargable = isRechargable;
        this.lifeEnable = lifeEnable;
        this.UfCharge = UfCharge;
        this.electricalU = electricalU;
        this.electricalPMax = electricalPMax;
        this.electricalDischargeRate = electricalDischargeRate;
        this.electricalStdP = electricalStdP;
        this.electricalStdDischargeTime = electricalStdDischargeTime;
        this.electricalStdEfficiency = electricalStdEfficiency;
        this.electricalStdHalfLife = electricalStdHalfLife;
        this.thermalHeatTime = thermalHeatTime;
        this.thermalWarmLimit = thermalWarmLimit;
        this.thermalCoolLimit = thermalCoolLimit;
        this.currentDropVoltage = 1000000.0;
        this.electricalStdI = this.electricalStdP / this.electricalU;
        this.electricalStdEnergy = this.electricalStdDischargeTime * this.electricalStdP;
        this.electricalQ = this.electricalStdP * this.electricalStdDischargeTime / this.electricalU;
        this.electricalQ = 1.0;
        double energy = this.getEnergy(1.0, 1.0);
        this.electricalQ *= this.electricalStdEnergy / energy;
        this.electricalRs = this.electricalStdP * (1.0 - this.electricalStdEfficiency) / this.electricalStdI / this.electricalStdI / (double)2;
        this.electricalRp = Math.min(this.electricalU * this.electricalU / this.electricalStdP / this.electricalDischargeRate, 1.0E9);
        this.lifeNominalCurrent = this.electricalStdP / this.electricalU;
        this.lifeNominalLost = 0.5 / this.electricalStdHalfLife;
        this.thermalPMax = this.electricalPMax / this.electricalU * this.electricalPMax / this.electricalU * this.electricalRs * (double)2;
        this.thermalC = Math.pow(this.electricalPMax / this.electricalU, 2.0) * this.electricalRs * this.thermalHeatTime / this.thermalWarmLimit;
        this.thermalRp = this.thermalWarmLimit / this.thermalPMax;
        this.IMax = this.electricalStdI * (double)3;
        this.obj = Eln.obj.getObj(modelName);
        if (this.obj != null) {
            Obj3D obj3D = this.obj;
            Intrinsics.checkNotNull(obj3D);
            if (Intrinsics.areEqual(obj3D.getString("type"), "A")) {
                this.renderType = 0;
            }
            Obj3D obj3D2 = this.obj;
            Intrinsics.checkNotNull(obj3D2);
            if (Intrinsics.areEqual(obj3D2.getString("type"), "B")) {
                this.renderType = 1;
            }
            switch (this.renderType) {
                case 0: {
                    Obj3D obj3D3 = this.obj;
                    Intrinsics.checkNotNull(obj3D3);
                    this.modelPart = obj3D3.getPart("Battery");
                }
            }
        }
        this.voltageLevelColor = VoltageLevelColor.Companion.fromVoltage(this.electricalU);
    }

    public final double getStartCharge() {
        return this.startCharge;
    }

    public final void setStartCharge(double d) {
        this.startCharge = d;
    }

    public final boolean isRechargable() {
        return this.isRechargable;
    }

    public final void setRechargable(boolean bl) {
        this.isRechargable = bl;
    }

    public final boolean getLifeEnable() {
        return this.lifeEnable;
    }

    public final void setLifeEnable(boolean bl) {
        this.lifeEnable = bl;
    }

    @NotNull
    public final FunctionTable getUfCharge() {
        return this.UfCharge;
    }

    public final void setUfCharge(@NotNull FunctionTable functionTable) {
        Intrinsics.checkNotNullParameter(functionTable, "<set-?>");
        this.UfCharge = functionTable;
    }

    public final double getElectricalU() {
        return this.electricalU;
    }

    public final void setElectricalU(double d) {
        this.electricalU = d;
    }

    public final double getElectricalPMax() {
        return this.electricalPMax;
    }

    public final void setElectricalPMax(double d) {
        this.electricalPMax = d;
    }

    public final double getElectricalDischargeRate() {
        return this.electricalDischargeRate;
    }

    public final void setElectricalDischargeRate(double d) {
        this.electricalDischargeRate = d;
    }

    public final double getElectricalStdP() {
        return this.electricalStdP;
    }

    public final void setElectricalStdP(double d) {
        this.electricalStdP = d;
    }

    public final double getElectricalStdDischargeTime() {
        return this.electricalStdDischargeTime;
    }

    public final void setElectricalStdDischargeTime(double d) {
        this.electricalStdDischargeTime = d;
    }

    public final double getElectricalStdEfficiency() {
        return this.electricalStdEfficiency;
    }

    public final void setElectricalStdEfficiency(double d) {
        this.electricalStdEfficiency = d;
    }

    public final double getElectricalStdHalfLife() {
        return this.electricalStdHalfLife;
    }

    public final void setElectricalStdHalfLife(double d) {
        this.electricalStdHalfLife = d;
    }

    public final double getThermalHeatTime() {
        return this.thermalHeatTime;
    }

    public final void setThermalHeatTime(double d) {
        this.thermalHeatTime = d;
    }

    public final double getThermalWarmLimit() {
        return this.thermalWarmLimit;
    }

    public final void setThermalWarmLimit(double d) {
        this.thermalWarmLimit = d;
    }

    public final double getThermalCoolLimit() {
        return this.thermalCoolLimit;
    }

    public final void setThermalCoolLimit(double d) {
        this.thermalCoolLimit = d;
    }

    public final double getElectricalStdI() {
        return this.electricalStdI;
    }

    public final void setElectricalStdI(double d) {
        this.electricalStdI = d;
    }

    public final double getElectricalQ() {
        return this.electricalQ;
    }

    public final void setElectricalQ(double d) {
        this.electricalQ = d;
    }

    public final double getThermalC() {
        return this.thermalC;
    }

    public final void setThermalC(double d) {
        this.thermalC = d;
    }

    public final double getThermalRp() {
        return this.thermalRp;
    }

    public final void setThermalRp(double d) {
        this.thermalRp = d;
    }

    public final double getThermalPMax() {
        return this.thermalPMax;
    }

    public final void setThermalPMax(double d) {
        this.thermalPMax = d;
    }

    public final double getLifeNominalCurrent() {
        return this.lifeNominalCurrent;
    }

    public final void setLifeNominalCurrent(double d) {
        this.lifeNominalCurrent = d;
    }

    public final double getLifeNominalLost() {
        return this.lifeNominalLost;
    }

    public final void setLifeNominalLost(double d) {
        this.lifeNominalLost = d;
    }

    @Nullable
    public final String getModelName() {
        return this.modelName;
    }

    public final void setModelName(@Nullable String string) {
        this.modelName = string;
    }

    @Nullable
    public final Obj3D.Obj3DPart getModelPart() {
        return this.modelPart;
    }

    public final void setModelPart(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.modelPart = obj3DPart;
    }

    @Nullable
    public final Obj3D getObj() {
        return this.obj;
    }

    public final void setObj(@Nullable Obj3D obj3D) {
        this.obj = obj3D;
    }

    @Nullable
    public final Obj3D.Obj3DPart getMain() {
        return this.main;
    }

    public final void setMain(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.main = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getPlugPlus() {
        return this.plugPlus;
    }

    public final void setPlugPlus(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.plugPlus = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getPlusMinus() {
        return this.plusMinus;
    }

    public final void setPlusMinus(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.plusMinus = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getBattery() {
        return this.battery;
    }

    public final void setBattery(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.battery = obj3DPart;
    }

    public final int getRenderType() {
        return this.renderType;
    }

    public final void setRenderType(int n) {
        this.renderType = n;
    }

    public final void draw(boolean plus2, boolean minus2) {
        switch (this.renderType) {
            case 0: {
                if (this.modelPart == null) {
                    return;
                }
                Obj3D.Obj3DPart obj3DPart = this.modelPart;
                Intrinsics.checkNotNull(obj3DPart);
                obj3DPart.draw();
                break;
            }
            case 1: {
                if (this.main != null) {
                    Obj3D.Obj3DPart obj3DPart = this.main;
                    Intrinsics.checkNotNull(obj3DPart);
                    obj3DPart.draw();
                }
                if (this.plugPlus != null && plus2) {
                    Obj3D.Obj3DPart obj3DPart = this.plugPlus;
                    Intrinsics.checkNotNull(obj3DPart);
                    obj3DPart.draw();
                }
                if (this.plusMinus != null && minus2) {
                    Obj3D.Obj3DPart obj3DPart = this.plusMinus;
                    Intrinsics.checkNotNull(obj3DPart);
                    obj3DPart.draw();
                }
                if (this.battery == null) break;
                Obj3D.Obj3DPart obj3DPart = this.battery;
                Intrinsics.checkNotNull(obj3DPart);
                obj3DPart.draw();
            }
        }
    }

    @Override
    public void setParent(@NotNull Item item, int damage) {
        Intrinsics.checkNotNullParameter(item, "item");
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    public final void applyTo(@NotNull Resistor resistor) {
        Intrinsics.checkNotNullParameter(resistor, "resistor");
        resistor.setResistance(this.electricalRp);
    }

    public final void applyTo(@NotNull BatteryProcess battery) {
        Intrinsics.checkNotNullParameter(battery, "battery");
        battery.setUNominal(this.electricalU);
        battery.setQNominal(this.electricalQ);
        battery.setVoltageFunction(this.UfCharge);
        battery.setRechargeable(this.isRechargable);
        if (battery.Q > 1.5 && battery.getU() > battery.getUNominal() / (double)4) {
            battery.Q /= this.electricalQ;
        }
    }

    public final void applyTo(@NotNull ElectricalLoad load, @Nullable Simulator simulator) {
        Intrinsics.checkNotNullParameter(load, "load");
        load.setSerialResistance(this.electricalRs);
    }

    public final void applyTo(@NotNull ThermalLoad load) {
        Intrinsics.checkNotNullParameter(load, "load");
        load.Rp = this.thermalRp;
        load.heatCapacity = this.thermalC;
    }

    public final void applyTo(@NotNull BatterySlowProcess process) {
        Intrinsics.checkNotNullParameter(process, "process");
        process.setLifeNominalCurrent(this.lifeNominalCurrent);
        process.setLifeNominalLost(this.lifeNominalLost);
    }

    @Override
    @NotNull
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("charge", this.startCharge);
        nbt.func_74780_a("life", 1.0);
        return nbt;
    }

    @Override
    public void addInformation(@NotNull ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        String string = I18N.tr("Nominal voltage: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Nominal voltage: \")");
        list.add(Utils.plotVolt(string, this.electricalU));
        String string2 = I18N.tr("Nominal power: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string2, "tr(\"Nominal power: \")");
        list.add(Utils.plotPower(string2, this.electricalStdP));
        String string3 = I18N.tr("Energy capacity: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string3, "tr(\"Energy capacity: \")");
        list.add(Utils.plotEnergy(string3, this.electricalStdDischargeTime * this.electricalStdP));
        String string4 = I18N.tr("Internal resistance: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Internal resistance: \")");
        list.add(Utils.plotOhm(string4, this.electricalRs * (double)2));
        list.add("");
        String string5 = I18N.tr("Actual charge: ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Actual charge: \")");
        list.add(Utils.plotPercent(string5, this.getChargeInTag(itemStack)));
        if (this.lifeEnable) {
            String string6 = I18N.tr("Life: ", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Life: \")");
            list.add(Utils.plotPercent(string6, this.getLifeInTag(itemStack)));
        }
    }

    @Override
    @NotNull
    public RealisticEnum addRealismContext(@Nullable List<String> list) {
        block6: {
            List<String> list2 = list;
            if (list2 != null) {
                String string = I18N.tr("Battery could be realistic in the future", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"Battery could be realistic in the future\")");
                list2.add(string);
            }
            List<String> list3 = list;
            if (list3 != null) {
                String string = I18N.tr("  * Batteries have internal resistance", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"  * Batteries have internal resistance\")");
                list3.add(string);
            }
            List<String> list4 = list;
            if (list4 != null) {
                String string = I18N.tr("  * Not currently simulating any particular chemistry of battery", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"  * Not currently si\u2026ar chemistry of battery\")");
                list4.add(string);
            }
            List<String> list5 = list;
            if (list5 != null) {
                String string = I18N.tr("Batteries are based in realistic battery designs that someone might implement realistically:", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"Batteries are based \u2026mplement realistically:\")");
                list5.add(string);
            }
            List<String> list6 = list;
            if (list6 != null) {
                String string = I18N.tr("  * Single use batteries emulate a voltaic pile", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"  * Single use batte\u2026 emulate a voltaic pile\")");
                list6.add(string);
            }
            List<String> list7 = list;
            if (list7 != null) {
                String string = I18N.tr("  * Current oriented uses two smaller batteries in parallel to increase current capability", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "tr(\"  * Current oriented\u2026ease current capability\")");
                list7.add(string);
            }
            List<String> list8 = list;
            if (list8 == null) break block6;
            String string = I18N.tr("  * Voltage oriented uses two smaller batteries in series to increase voltage", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"  * Voltage oriented\u2026ies to increase voltage\")");
            list8.add(string);
        }
        return RealisticEnum.IDEAL;
    }

    @Override
    @NotNull
    public String getName(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        StringBuilder stringBuilder = new StringBuilder().append(super.getName(stack));
        String string = I18N.tr(" charged at ", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\" charged at \")");
        return stringBuilder.append(Utils.plotPercent(string, this.getChargeInTag(stack))).toString();
    }

    public final double getChargeInTag(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        return stack.func_77978_p().func_74769_h("charge");
    }

    public final double getLifeInTag(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        return stack.func_77978_p().func_74769_h("life");
    }

    public final double getEnergy(double charge, double life) {
        int stepNbr = 50;
        double chargeStep = charge / (double)stepNbr;
        double chargeIntegrator = 0.0;
        double energy = 0.0;
        double QperStep = this.electricalQ * life * charge / (double)stepNbr;
        for (int step = 0; step < stepNbr; ++step) {
            double voltage = this.UfCharge.getValue(chargeIntegrator) * this.electricalU;
            energy += voltage * QperStep;
            chargeIntegrator += chargeStep;
        }
        return energy;
    }

    @Override
    public boolean handleRenderType(@NotNull ItemStack item, @NotNull IItemRenderer.ItemRenderType type) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(type, "type");
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, @NotNull IItemRenderer.ItemRendererHelper helper) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(helper, "helper");
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(data, "data");
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, Arrays.copyOf(data, data.length));
        } else {
            this.draw(true, true);
        }
    }

    @Override
    public boolean onEntityItemUpdate(@NotNull EntityItem entityItem) {
        Intrinsics.checkNotNullParameter(entityItem, "entityItem");
        if (entityItem.func_70027_ad()) {
            entityItem.field_70170_p.func_72876_a((Entity)entityItem, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 2.0f, true);
            entityItem.func_70066_B();
            entityItem.func_70106_y();
        }
        return false;
    }

    public final void setRenderSpec(@NotNull String renderSpec) {
        Intrinsics.checkNotNullParameter(renderSpec, "renderSpec");
        this.renderSpec = renderSpec;
        if (this.obj != null) {
            switch (this.renderType) {
                case 0: 
                case 1: {
                    Obj3D obj3D = this.obj;
                    Intrinsics.checkNotNull(obj3D);
                    this.main = obj3D.getPart("main");
                    Obj3D obj3D2 = this.obj;
                    Intrinsics.checkNotNull(obj3D2);
                    this.plugPlus = obj3D2.getPart("plugPlus");
                    Obj3D obj3D3 = this.obj;
                    Intrinsics.checkNotNull(obj3D3);
                    this.plusMinus = obj3D3.getPart("plugMinus");
                    Obj3D obj3D4 = this.obj;
                    Intrinsics.checkNotNull(obj3D4);
                    this.battery = obj3D4.getPart("battery_" + renderSpec);
                }
            }
        }
    }

    public final void setCurrentDrop(double currentDropVoltage, double currentDropFactor) {
        this.currentDropFactor = currentDropFactor;
        this.currentDropVoltage = currentDropVoltage;
    }
}

