/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.nbt.NbtBatteryProcess;
import mods.eln.sim.nbt.NbtBatterySlowProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.transparentnode.battery.BatteryDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J\u001a\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010V\u001a\u00020WH\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010X2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J\u0014\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020[0ZH\u0016J\b\u0010\\\u001a\u00020\u001fH\u0016J\b\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020[2\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010`\u001a\u00020^2\u0006\u0010a\u001a\u00020bH\u0016J0\u0010c\u001a\u00020\u001f2\u0006\u0010d\u001a\u00020e2\u0006\u0010P\u001a\u00020Q2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020g2\u0006\u0010i\u001a\u00020gH\u0016J\u0012\u0010j\u001a\u00020^2\b\u0010k\u001a\u0004\u0018\u00010WH\u0016J\b\u0010l\u001a\u00020^H\u0016J\u0010\u0010m\u001a\u00020[2\u0006\u0010P\u001a\u00020QH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00106\"\u0004\b;\u00108R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010M\u00a8\u0006n"}, d2={"Lmods/eln/transparentnode/battery/BatteryElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "transparentNode", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "batteryProcess", "Lmods/eln/sim/nbt/NbtBatteryProcess;", "getBatteryProcess", "()Lmods/eln/sim/nbt/NbtBatteryProcess;", "setBatteryProcess", "(Lmods/eln/sim/nbt/NbtBatteryProcess;)V", "batterySlowProcess", "Lmods/eln/sim/nbt/NbtBatterySlowProcess;", "getBatterySlowProcess", "()Lmods/eln/sim/nbt/NbtBatterySlowProcess;", "setBatterySlowProcess", "(Lmods/eln/sim/nbt/NbtBatterySlowProcess;)V", "Lmods/eln/transparentnode/battery/BatteryDescriptor;", "getDescriptor", "()Lmods/eln/transparentnode/battery/BatteryDescriptor;", "setDescriptor", "(Lmods/eln/transparentnode/battery/BatteryDescriptor;)V", "dischargeResistor", "Lmods/eln/sim/mna/component/Resistor;", "getDischargeResistor", "()Lmods/eln/sim/mna/component/Resistor;", "setDischargeResistor", "(Lmods/eln/sim/mna/component/Resistor;)V", "fromItemStack", "", "getFromItemStack", "()Z", "setFromItemStack", "(Z)V", "fromItemstackCharge", "", "getFromItemstackCharge", "()D", "setFromItemstackCharge", "(D)V", "fromItemstackLife", "getFromItemstackLife", "setFromItemstackLife", "negativeETProcess", "Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "getNegativeETProcess", "()Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "setNegativeETProcess", "(Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;)V", "negativeLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getNegativeLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setNegativeLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "positiveLoad", "getPositiveLoad", "setPositiveLoad", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "setThermalLoad", "(Lmods/eln/sim/nbt/NbtThermalLoad;)V", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "setThermalWatchdog", "(Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;)V", "voltageSource", "Lmods/eln/sim/mna/component/VoltageSource;", "getVoltageSource", "()Lmods/eln/sim/mna/component/VoltageSource;", "setVoltageSource", "(Lmods/eln/sim/mna/component/VoltageSource;)V", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "getItemStackNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readItemStackNBT", "nbt", "reconnect", "thermoMeterString", "Eln"})
public final class BatteryElement
extends TransparentNodeElement {
    @NotNull
    private BatteryDescriptor descriptor;
    @NotNull
    private NbtElectricalLoad positiveLoad;
    @NotNull
    private NbtElectricalLoad negativeLoad;
    @NotNull
    private VoltageSource voltageSource;
    @NotNull
    private NbtThermalLoad thermalLoad;
    @NotNull
    private ElectricalLoadHeatThermalLoad negativeETProcess;
    @NotNull
    private ThermalLoadWatchDog thermalWatchdog;
    @NotNull
    private NbtBatteryProcess batteryProcess;
    @NotNull
    private Resistor dischargeResistor;
    @NotNull
    private NbtBatterySlowProcess batterySlowProcess;
    private boolean fromItemStack;
    private double fromItemstackCharge;
    private double fromItemstackLife;

    public BatteryElement(@NotNull TransparentNode transparentNode, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(transparentNode, "transparentNode");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(transparentNode, descriptor);
        this.descriptor = (BatteryDescriptor)descriptor;
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.negativeLoad = new NbtElectricalLoad("negativeLoad");
        this.voltageSource = new VoltageSource("volSrc", this.positiveLoad, this.negativeLoad);
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.negativeETProcess = new ElectricalLoadHeatThermalLoad(this.negativeLoad, this.thermalLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
        this.batteryProcess = new NbtBatteryProcess(this.positiveLoad, this.negativeLoad, this.getDescriptor().getUfCharge(), 0.0, this.voltageSource, this.thermalLoad);
        this.dischargeResistor = new Resistor(this.positiveLoad, this.negativeLoad);
        TransparentNode transparentNode2 = this.node;
        Intrinsics.checkNotNull(transparentNode2);
        this.batterySlowProcess = new NbtBatterySlowProcess(transparentNode2, this.batteryProcess, this.thermalLoad);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(new Resistor(this.positiveLoad, null));
        this.electricalComponentList.add(new Resistor(this.negativeLoad, null));
        this.electricalComponentList.add(this.dischargeResistor);
        this.electricalComponentList.add(this.voltageSource);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalProcessList.add(this.batteryProcess);
        this.thermalFastProcessList.add(this.negativeETProcess);
        this.slowProcessList.add(this.batterySlowProcess);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 1.0, 0.0));
        this.batteryProcess.IMax = this.getDescriptor().IMax;
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setMaximumTemperature(this.getDescriptor().getThermalWarmLimit()).setDestroys(new WorldExplosion(this).machineExplosion());
    }

    @Override
    @NotNull
    public BatteryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(@NotNull BatteryDescriptor batteryDescriptor) {
        Intrinsics.checkNotNullParameter(batteryDescriptor, "<set-?>");
        this.descriptor = batteryDescriptor;
    }

    @NotNull
    public final NbtElectricalLoad getPositiveLoad() {
        return this.positiveLoad;
    }

    public final void setPositiveLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.positiveLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtElectricalLoad getNegativeLoad() {
        return this.negativeLoad;
    }

    public final void setNegativeLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.negativeLoad = nbtElectricalLoad;
    }

    @NotNull
    public final VoltageSource getVoltageSource() {
        return this.voltageSource;
    }

    public final void setVoltageSource(@NotNull VoltageSource voltageSource) {
        Intrinsics.checkNotNullParameter(voltageSource, "<set-?>");
        this.voltageSource = voltageSource;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    public final void setThermalLoad(@NotNull NbtThermalLoad nbtThermalLoad) {
        Intrinsics.checkNotNullParameter(nbtThermalLoad, "<set-?>");
        this.thermalLoad = nbtThermalLoad;
    }

    @NotNull
    public final ElectricalLoadHeatThermalLoad getNegativeETProcess() {
        return this.negativeETProcess;
    }

    public final void setNegativeETProcess(@NotNull ElectricalLoadHeatThermalLoad electricalLoadHeatThermalLoad) {
        Intrinsics.checkNotNullParameter(electricalLoadHeatThermalLoad, "<set-?>");
        this.negativeETProcess = electricalLoadHeatThermalLoad;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog() {
        return this.thermalWatchdog;
    }

    public final void setThermalWatchdog(@NotNull ThermalLoadWatchDog thermalLoadWatchDog) {
        Intrinsics.checkNotNullParameter(thermalLoadWatchDog, "<set-?>");
        this.thermalWatchdog = thermalLoadWatchDog;
    }

    @NotNull
    public final NbtBatteryProcess getBatteryProcess() {
        return this.batteryProcess;
    }

    public final void setBatteryProcess(@NotNull NbtBatteryProcess nbtBatteryProcess) {
        Intrinsics.checkNotNullParameter(nbtBatteryProcess, "<set-?>");
        this.batteryProcess = nbtBatteryProcess;
    }

    @NotNull
    public final Resistor getDischargeResistor() {
        return this.dischargeResistor;
    }

    public final void setDischargeResistor(@NotNull Resistor resistor) {
        Intrinsics.checkNotNullParameter(resistor, "<set-?>");
        this.dischargeResistor = resistor;
    }

    @NotNull
    public final NbtBatterySlowProcess getBatterySlowProcess() {
        return this.batterySlowProcess;
    }

    public final void setBatterySlowProcess(@NotNull NbtBatterySlowProcess nbtBatterySlowProcess) {
        Intrinsics.checkNotNullParameter(nbtBatterySlowProcess, "<set-?>");
        this.batterySlowProcess = nbtBatterySlowProcess;
    }

    public final boolean getFromItemStack() {
        return this.fromItemStack;
    }

    public final void setFromItemStack(boolean bl) {
        this.fromItemStack = bl;
    }

    public final double getFromItemstackCharge() {
        return this.fromItemstackCharge;
    }

    public final void setFromItemstackCharge(double d) {
        this.fromItemstackCharge = d;
    }

    public final double getFromItemstackLife() {
        return this.fromItemstackLife;
    }

    public final void setFromItemstackLife(double d) {
        this.fromItemstackLife = d;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.positiveLoad;
        }
        return side == this.front.right() ? (ElectricalLoad)this.negativeLoad : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.thermalLoad;
        }
        return side == this.front.right() ? (ThermalLoad)this.thermalLoad : null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front.left()) {
            return 1;
        }
        return side == this.front.right() ? 1 : 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        String str = "";
        str = str + Utils.plotVolt("Ubat:", this.batteryProcess.getU());
        str = str + Utils.plotAmpere("I:", this.batteryProcess.getDischargeCurrent());
        str = str + Utils.plotPercent("Charge:", this.batteryProcess.getCharge());
        str = str + Utils.plotPercent("Life:", this.batteryProcess.life);
        return str;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotCelsius("Tbat:", this.thermalLoad.temperatureCelsius);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)(this.batteryProcess.getU() * this.batteryProcess.getDischargeCurrent()));
            stream.writeFloat((float)this.batteryProcess.getEnergy());
            stream.writeShort((int)(this.batteryProcess.life * (double)1000));
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            transparentNode.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.getDescriptor().applyTo(this.batteryProcess);
        this.getDescriptor().applyTo(this.thermalLoad);
        this.getDescriptor().applyTo(this.dischargeResistor);
        this.getDescriptor().applyTo(this.batterySlowProcess);
        this.positiveLoad.setSerialResistance(this.getDescriptor().electricalRs);
        this.negativeLoad.setSerialResistance(this.getDescriptor().electricalRs);
        this.dischargeResistor.setResistance(1.0E9);
        if (this.fromItemStack) {
            this.batteryProcess.life = this.fromItemstackLife;
            this.batteryProcess.setCharge(this.fromItemstackCharge);
            this.fromItemStack = false;
        }
        this.connect();
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void readItemStackNBT(@Nullable NBTTagCompound nbt) {
        double d;
        double d2;
        super.readItemStackNBT(nbt);
        NBTTagCompound nBTTagCompound = nbt;
        if (nBTTagCompound != null) {
            d2 = nBTTagCompound.func_74769_h("charge");
        } else {
            BatteryDescriptor batteryDescriptor = this.getDescriptor();
            ItemStack itemStack = this.getDescriptor().newItemStack();
            Intrinsics.checkNotNullExpressionValue(itemStack, "this.descriptor.newItemStack()");
            d2 = batteryDescriptor.getChargeInTag(itemStack);
        }
        this.fromItemstackCharge = d2;
        NBTTagCompound nBTTagCompound2 = nbt;
        if (nBTTagCompound2 != null) {
            d = nBTTagCompound2.func_74769_h("life");
        } else {
            BatteryDescriptor batteryDescriptor = this.getDescriptor();
            ItemStack itemStack = this.getDescriptor().newItemStack();
            Intrinsics.checkNotNullExpressionValue(itemStack, "this.descriptor.newItemStack()");
            d = batteryDescriptor.getLifeInTag(itemStack);
        }
        this.fromItemstackLife = d;
        this.fromItemStack = true;
    }

    @Override
    @NotNull
    public NBTTagCompound getItemStackNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("charge", this.batteryProcess.getCharge());
        nbt.func_74780_a("life", this.batteryProcess.life);
        return nbt;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info;
        Map map = info = (Map)new HashMap();
        String string = I18N.tr("Charge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Charge\")");
        String string2 = string;
        String string3 = Utils.plotPercent("", this.batteryProcess.getCharge());
        map.put(string2, string3);
        map = info;
        String string4 = I18N.tr("Energy", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Energy\")");
        string2 = string4;
        string3 = Utils.plotEnergy("", this.batteryProcess.getEnergy());
        map.put(string2, string3);
        map = info;
        String string5 = I18N.tr("Life", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Life\")");
        string2 = string5;
        string3 = Utils.plotPercent("", this.batteryProcess.life);
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string6 = I18N.tr("Voltage", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Voltage\")");
            string2 = string6;
            string3 = Utils.plotVolt("", this.batteryProcess.getU());
            map.put(string2, string3);
            map = info;
            String string7 = I18N.tr("Current", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string7, "tr(\"Current\")");
            string2 = string7;
            string3 = Utils.plotAmpere("", this.batteryProcess.getDischargeCurrent());
            map.put(string2, string3);
            map = info;
            String string8 = I18N.tr("Temperature", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string8, "tr(\"Temperature\")");
            string2 = string8;
            string3 = Utils.plotCelsius("", this.thermalLoad.temperatureCelsius);
            map.put(string2, string3);
        }
        map = info;
        String string9 = I18N.tr("Subsystem Matrix Size", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string9, "tr(\"Subsystem Matrix Size\")");
        string2 = string9;
        string3 = Utils.renderSubSystemWaila(this.positiveLoad.getSubSystem());
        map.put(string2, string3);
        return info;
    }
}

