/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiVerticalProgressBar;
import mods.eln.gui.HelperStdContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.text.StringsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.battery.BatteryRender;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0004\u00a8\u0006\u001c"}, d2={"Lmods/eln/transparentnode/battery/BatteryGuiDraw;", "Lmods/eln/gui/GuiScreenEln;", "render", "Lmods/eln/transparentnode/battery/BatteryRender;", "(Lmods/eln/transparentnode/battery/BatteryRender;)V", "energyBar", "Lmods/eln/gui/GuiVerticalProgressBar;", "getEnergyBar", "()Lmods/eln/gui/GuiVerticalProgressBar;", "setEnergyBar", "(Lmods/eln/gui/GuiVerticalProgressBar;)V", "getRender", "()Lmods/eln/transparentnode/battery/BatteryRender;", "setRender", "guiObjectEvent", "", "object", "Lmods/eln/gui/IGuiObject;", "initGui", "newHelper", "Lmods/eln/gui/GuiHelperContainer;", "postDraw", "f", "", "x", "", "y", "preDraw", "Eln"})
public final class BatteryGuiDraw
extends GuiScreenEln {
    @NotNull
    private BatteryRender render;
    @Nullable
    private GuiVerticalProgressBar energyBar;

    public BatteryGuiDraw(@NotNull BatteryRender render) {
        Intrinsics.checkNotNullParameter(render, "render");
        this.render = render;
    }

    @NotNull
    public final BatteryRender getRender() {
        return this.render;
    }

    public final void setRender(@NotNull BatteryRender batteryRender) {
        Intrinsics.checkNotNullParameter(batteryRender, "<set-?>");
        this.render = batteryRender;
    }

    @Nullable
    public final GuiVerticalProgressBar getEnergyBar() {
        return this.energyBar;
    }

    public final void setEnergyBar(@Nullable GuiVerticalProgressBar guiVerticalProgressBar) {
        this.energyBar = guiVerticalProgressBar;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.helper.ySize = 50;
        GuiVerticalProgressBar guiVerticalProgressBar = this.energyBar = this.newGuiVerticalProgressBar(151, 8, 16, 35);
        Intrinsics.checkNotNull(guiVerticalProgressBar);
        guiVerticalProgressBar.setColor(0.2f, 0.5f, 0.8f);
    }

    @Override
    public void guiObjectEvent(@NotNull IGuiObject object) {
        Intrinsics.checkNotNullParameter(object, "object");
        super.guiObjectEvent(object);
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        GuiVerticalProgressBar guiVerticalProgressBar = this.energyBar;
        Intrinsics.checkNotNull(guiVerticalProgressBar);
        guiVerticalProgressBar.setValue((float)((double)this.render.getEnergy() / (this.render.getDescriptor().electricalStdEnergy * (double)this.render.getLife())));
        GuiVerticalProgressBar guiVerticalProgressBar2 = this.energyBar;
        Intrinsics.checkNotNull(guiVerticalProgressBar2);
        Object[] objectArray = new Object[1];
        GuiVerticalProgressBar guiVerticalProgressBar3 = this.energyBar;
        Intrinsics.checkNotNull(guiVerticalProgressBar3);
        objectArray[0] = StringsKt.replace$default(Utils.plotPercent("", guiVerticalProgressBar3.getValue()), " ", "", false, 4, null);
        guiVerticalProgressBar2.setComment(0, I18N.tr("Energy: %1$", objectArray));
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        super.postDraw(f, x, y);
        String str1 = null;
        String str2 = "";
        double p = this.render.getPower();
        double energyMiss = this.render.getDescriptor().electricalStdEnergy * (double)this.render.getLife() - (double)this.render.getEnergy();
        if (Math.abs(p) < 5.0) {
            String string = I18N.tr("No charge", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"No charge\")");
            str1 = string;
        } else if (p > 0.0) {
            String string = I18N.tr("Discharge", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Discharge\")");
            str1 = string;
            str2 = Utils.plotTime("", (double)this.render.getEnergy() / p);
        } else if (energyMiss > 0.0) {
            String string = I18N.tr("Charge", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Charge\")");
            str1 = string;
            str2 = Utils.plotTime("", -energyMiss / p);
        } else {
            String string = I18N.tr("Charged", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Charged\")");
            str1 = string;
        }
        int xDelta = 70;
        if (this.render.getDescriptor().getLifeEnable()) {
            this.drawString(8, 8, I18N.tr("Life:", new Object[0]));
            this.drawString(xDelta, 8, Utils.plotPercent("", this.render.getLife()));
        }
        this.drawString(8, 17, I18N.tr("Energy:", new Object[0]));
        this.drawString(xDelta, 17, Utils.plotValue(this.render.getEnergy(), "J/") + Utils.plotValue(this.render.getDescriptor().electricalStdEnergy * (double)this.render.getLife(), "J"));
        if (this.render.getPower() >= 0.0f) {
            this.drawString(8, 26, I18N.tr("Power out:", new Object[0]));
        } else {
            this.drawString(8, 26, I18N.tr("Power in:", new Object[0]));
        }
        this.drawString(xDelta, 26, Utils.plotValue(Math.abs(this.render.getPower()), "W/") + Utils.plotValue(this.render.getDescriptor().getElectricalStdP(), "W"));
        this.drawString(8, 35, str1);
        this.drawString(xDelta, 35, str2);
    }

    @Override
    @NotNull
    protected GuiHelperContainer newHelper() {
        return new HelperStdContainer(this);
    }
}

