/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.battery;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDUMask;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.transparentnode.battery.BatteryDescriptor;
import mods.eln.transparentnode.battery.BatteryGuiDraw;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u001a\u0010\u0004\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000f\"\u0004\b&\u0010\u0011\u00a8\u00062"}, d2={"Lmods/eln/transparentnode/battery/BatteryRender;", "Lmods/eln/node/transparent/TransparentNodeElementRender;", "tileEntity", "Lmods/eln/node/transparent/TransparentNodeEntity;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNodeEntity;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "Lmods/eln/transparentnode/battery/BatteryDescriptor;", "getDescriptor", "()Lmods/eln/transparentnode/battery/BatteryDescriptor;", "setDescriptor", "(Lmods/eln/transparentnode/battery/BatteryDescriptor;)V", "energy", "", "getEnergy", "()F", "setEnergy", "(F)V", "life", "getLife", "setLife", "lrdu", "Lmods/eln/misc/LRDUMask;", "getLrdu", "()Lmods/eln/misc/LRDUMask;", "setLrdu", "(Lmods/eln/misc/LRDUMask;)V", "minus", "", "getMinus", "()Z", "setMinus", "(Z)V", "plus", "getPlus", "setPlus", "power", "getPower", "setPower", "draw", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "side", "Lmods/eln/misc/Direction;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "Eln"})
public final class BatteryRender
extends TransparentNodeElementRender {
    private float energy;
    private float life;
    @NotNull
    private BatteryDescriptor descriptor;
    private boolean plus;
    private boolean minus;
    @NotNull
    private LRDUMask lrdu;
    private float power;

    public BatteryRender(@NotNull TransparentNodeEntity tileEntity, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(tileEntity, descriptor);
        this.descriptor = (BatteryDescriptor)descriptor;
        this.lrdu = new LRDUMask();
    }

    public final float getEnergy() {
        return this.energy;
    }

    public final void setEnergy(float f) {
        this.energy = f;
    }

    public final float getLife() {
        return this.life;
    }

    public final void setLife(float f) {
        this.life = f;
    }

    @NotNull
    public final BatteryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@NotNull BatteryDescriptor batteryDescriptor) {
        Intrinsics.checkNotNullParameter(batteryDescriptor, "<set-?>");
        this.descriptor = batteryDescriptor;
    }

    public final boolean getPlus() {
        return this.plus;
    }

    public final void setPlus(boolean bl) {
        this.plus = bl;
    }

    public final boolean getMinus() {
        return this.minus;
    }

    public final void setMinus(boolean bl) {
        this.minus = bl;
    }

    @NotNull
    public final LRDUMask getLrdu() {
        return this.lrdu;
    }

    public final void setLrdu(@NotNull LRDUMask lRDUMask) {
        Intrinsics.checkNotNullParameter(lRDUMask, "<set-?>");
        this.lrdu = lRDUMask;
    }

    public final float getPower() {
        return this.power;
    }

    public final void setPower(float f) {
        this.power = f;
    }

    @Override
    public void draw() {
        Direction direction = this.front;
        if (direction != null) {
            direction.glRotateXnRef();
        }
        this.descriptor.draw(this.plus, this.minus);
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            this.power = stream.readFloat();
            this.energy = stream.readFloat();
            this.life = (float)stream.readShort() / 1000.0f;
            this.lrdu.deserialize(stream);
            this.plus = true;
            this.minus = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new BatteryGuiDraw(this);
    }
}

