/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.eggincubator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.eggincubator.EggIncubatorContainer;
import mods.eln.transparentnode.eggincubator.EggIncubatorDescriptor;
import mods.eln.transparentnode.eggincubator.EggIncubatorInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class EggIncubatorElement
extends TransparentNodeElement {
    public NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    public Resistor powerResistor = new Resistor(this.powerLoad, null);
    TransparentNodeElementInventory inventory = new EggIncubatorInventory(1, 64, this);
    EggIncubatorProcess slowProcess = new EggIncubatorProcess();
    EggIncubatorDescriptor descriptor;
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.powerLoad);
    double lastVoltagePublish;

    public EggIncubatorElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.electricalLoadList.add(this.powerLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (EggIncubatorDescriptor)descriptor;
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.setNominalVoltage(this.descriptor.nominalVoltage).setDestroys(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        return this.powerLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotUIP(this.powerLoad.getVoltage(), this.powerLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.powerLoad);
        this.connect();
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        this.needPublish();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new EggIncubatorContainer(player, (IInventory)this.inventory, this.node);
    }

    @Override
    public float getLightOpacity() {
        return 1.0f;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            if (this.inventory.func_70301_a(0) == null) {
                stream.writeByte(0);
            } else {
                stream.writeByte(this.inventory.func_70301_a((int)0).field_77994_a);
            }
            this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
            stream.writeFloat((float)this.powerLoad.getVoltage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lastVoltagePublish = this.powerLoad.getVoltage();
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Has egg", new Object[0]), this.inventory.func_70301_a(0) != null ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Power consumption", new Object[0]), Utils.plotPower("", this.powerResistor.getPower()));
        }
        return info;
    }

    class EggIncubatorProcess
    implements IProcess,
    INBTTReady {
        double energy = 5000.0;

        public EggIncubatorProcess() {
            this.resetEnergy();
        }

        void resetEnergy() {
            this.energy = 10000.0 + Math.random() * 10000.0;
        }

        @Override
        public void process(double time) {
            this.energy -= EggIncubatorElement.this.powerResistor.getPower() * time;
            if (EggIncubatorElement.this.inventory.func_70301_a(0) != null) {
                EggIncubatorElement.this.descriptor.setState(EggIncubatorElement.this.powerResistor, true);
                if (this.energy <= 0.0) {
                    EggIncubatorElement.this.inventory.func_70298_a(0, 1);
                    EntityChicken chicken = new EntityChicken(EggIncubatorElement.this.node.coordinate.world());
                    chicken.func_70873_a(-24000);
                    EntityChicken entityliving = chicken;
                    entityliving.func_70012_b((double)EggIncubatorElement.this.node.coordinate.x + 0.5, (double)EggIncubatorElement.this.node.coordinate.y + 0.5, (double)EggIncubatorElement.this.node.coordinate.z + 0.5, MathHelper.func_76142_g((float)(EggIncubatorElement.this.node.coordinate.world().field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    entityliving.field_70759_as = entityliving.field_70177_z;
                    entityliving.field_70761_aq = entityliving.field_70177_z;
                    EggIncubatorElement.this.node.coordinate.world().func_72838_d((Entity)entityliving);
                    entityliving.func_70642_aH();
                    this.resetEnergy();
                    EggIncubatorElement.this.needPublish();
                }
            } else {
                EggIncubatorElement.this.descriptor.setState(EggIncubatorElement.this.powerResistor, false);
                this.resetEnergy();
            }
            if (Math.abs(EggIncubatorElement.this.powerLoad.getVoltage() - EggIncubatorElement.this.lastVoltagePublish) / EggIncubatorElement.this.descriptor.nominalVoltage > 0.1) {
                EggIncubatorElement.this.needPublish();
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String str) {
            this.energy = nbt.func_74769_h(str + "energyCounter");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String str) {
            nbt.func_74780_a(str + "energyCounter", this.energy);
        }
    }
}

