/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalantennarx;

import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxDescriptor;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalAntennaRxElement
extends TransparentNodeElement {
    ElectricalAntennaRxSlowProcess slowProcess = new ElectricalAntennaRxSlowProcess(this);
    NbtElectricalLoad powerOut = new NbtElectricalLoad("powerOut");
    NbtElectricalGateInput signalIn = new NbtElectricalGateInput("signalIn");
    PowerSource powerSrc = new PowerSource("powerSrc", (State)this.powerOut);
    LRDU rot = LRDU.Up;
    Coordinate rxCoord = null;
    ElectricalAntennaRxDescriptor descriptor;

    public double getSignal() {
        return this.signalIn.getSignalVoltage();
    }

    public void setPowerOut(double power2) {
        this.powerSrc.setPower(power2);
    }

    public void rxDisconnect() {
        this.powerSrc.setPower(0.0);
    }

    public ElectricalAntennaRxElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.slowProcessList.add(this.slowProcess);
        this.electricalLoadList.add(this.powerOut);
        this.electricalLoadList.add(this.signalIn);
        this.electricalComponentList.add(this.powerSrc);
        this.descriptor = (ElectricalAntennaRxDescriptor)descriptor;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return null;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return this.powerOut;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return this.signalIn;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return 0;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return 1;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return 4;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return "";
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return "";
    }

    @Override
    public void initialize() {
        this.descriptor.cable.applyTo(this.powerOut);
        this.powerSrc.setMaximumVoltage(this.descriptor.electricalMaximalVoltage * 2.0);
        this.powerSrc.setMaximumCurrent(this.descriptor.electricalMaximalVoltage * this.descriptor.electricalMaximalPower * 2.0);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(player)) {
            this.rot = this.rot.getNextClockwise();
            this.node.reconnect();
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.rot = LRDU.readFromNBT(nbt, "rot");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.rot.writeToNBT(nbt, "rot");
    }

    public boolean mustHaveFloor() {
        return false;
    }

    public boolean mustHaveCeiling() {
        return false;
    }

    public boolean mustHaveWall() {
        return false;
    }

    public boolean mustHaveWallFrontInverse() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        this.rot.serialize(stream);
        this.node.lrduCubeMask.getTranslate(this.front.getInverse()).serialize(stream);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Receiving", new Object[0]), this.powerSrc.getPower() != 0.0 ? "Yes" : "No");
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Power received", new Object[0]), Utils.plotPower("", this.powerSrc.getPower()));
            info.put(I18N.tr("Effective power", new Object[0]), Utils.plotPower("", this.powerSrc.getEffectivePower()));
        }
        return info;
    }
}

