/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalantennarx;

import java.io.DataInputStream;
import mods.eln.Eln;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.electricalantennarx.ElectricalAntennaRxDescriptor;
import org.lwjgl.opengl.GL11;

public class ElectricalAntennaRxRender
extends TransparentNodeElementRender {
    ElectricalAntennaRxDescriptor descriptor;
    LRDUMask maskTemp = new LRDUMask();
    LRDU rot;
    LRDUMask lrduConnection = new LRDUMask();
    CableRenderType connectionType;
    boolean cableRefresh = false;

    public ElectricalAntennaRxRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (ElectricalAntennaRxDescriptor)descriptor;
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        this.rot.glRotateOnX();
        this.descriptor.draw();
        GL11.glPopMatrix();
        this.glCableTransform(this.front.getInverse());
        this.descriptor.cable.bindCableTexture();
        if (this.cableRefresh) {
            this.cableRefresh = false;
            this.connectionType = CableRender.connectionType(this.getTileEntity(), this.lrduConnection, this.front.getInverse());
        }
        for (LRDU lrdu : LRDU.values()) {
            Utils.setGlColorFromDye(this.connectionType.otherdry[lrdu.toInt()]);
            if (!this.lrduConnection.get(lrdu)) continue;
            this.maskTemp.set(1 << lrdu.toInt());
            Direction side = this.front.getInverse().applyLRDU(lrdu);
            CableRenderDescriptor crd = this.getCableRenderSide(side, side.getLRDUGoingTo(this.front.getInverse()));
            CableRender.drawCable(crd, this.maskTemp, this.connectionType, crd.getWidthDiv2() / 2.0f, false);
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        this.rot = LRDU.deserialize(stream);
        this.lrduConnection.deserialize(stream);
        this.cableRefresh = true;
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRenderSide(Direction side, LRDU lrdu) {
        if (this.front.getInverse() != side.applyLRDU(lrdu)) {
            return null;
        }
        if (side == this.front.applyLRDU(this.rot.left())) {
            return this.descriptor.cable.render;
        }
        if (side == this.front.applyLRDU(this.rot.right())) {
            return Eln.instance.signalCableDescriptor.render;
        }
        return null;
    }

    @Override
    public void notifyNeighborSpawn() {
        super.notifyNeighborSpawn();
        this.cableRefresh = true;
    }
}

