/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalfurnace;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.client.FrameTime;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceGuiDraw;
import mods.eln.transparentnode.electricalfurnace.ElectricalFurnaceInventory;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class ElectricalFurnaceRender
extends TransparentNodeElementRender {
    TransparentNodeElementInventory inventory = new ElectricalFurnaceInventory(5, 64, this);
    public float temperature = 0.0f;
    public boolean powerOn;
    public boolean heatingCorpOn;
    EntityItem entityItemIn = null;
    long time = System.currentTimeMillis();
    float processState;
    float processStatePerSecond;
    float counter = 0.0f;
    short heatingCorpResistorP = 0;
    public boolean temperatureTargetSyncNew = false;
    public float temperatureTargetSyncValue = -1234.0f;
    public boolean autoShutDown;
    float voltage;

    public ElectricalFurnaceRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
    }

    @Override
    public void draw() {
        this.front.glRotateXnRef();
        Eln.obj.draw("ElectricFurnace", "furnace");
        this.drawEntityItem(this.entityItemIn, -0.1, -0.2, 0.0, this.counter, 0.8f);
    }

    @Override
    public void refresh(float deltaT) {
        this.processState += this.processStatePerSecond * FrameTime.getNotCaped2();
        if (this.processState > 1.0f) {
            this.processState = 1.0f;
        }
        this.counter = (float)((double)this.counter + (double)(System.currentTimeMillis() - this.time) * 0.001 * 360.0 / 4.0);
        if (this.counter > 360.0f) {
            this.counter -= 360.0f;
        }
        this.time = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalFurnaceGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.powerOn = (b & 1) != 0;
            this.heatingCorpOn = (b & 2) != 0;
            float temperatureTargetIncoming = stream.readShort();
            if (temperatureTargetIncoming != this.temperatureTargetSyncValue) {
                this.temperatureTargetSyncValue = temperatureTargetIncoming;
                this.temperatureTargetSyncNew = true;
            }
            this.temperature = stream.readShort();
            short read = stream.readShort();
            if (read == -1) {
                this.entityItemIn = null;
                stream.readShort();
            } else {
                this.entityItemIn = new EntityItem(this.getTileEntity().func_145831_w(), (double)this.getTileEntity().field_145851_c + 0.5, (double)this.getTileEntity().field_145848_d + 0.5, (double)this.getTileEntity().field_145849_e + 1.2, Utils.newItemStack(read, 1, (int)stream.readShort()));
            }
            this.heatingCorpResistorP = stream.readShort();
            this.voltage = stream.readFloat();
            this.processState = stream.readFloat();
            this.processStatePerSecond = stream.readFloat();
            this.autoShutDown = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetPowerOn(boolean value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(1);
            stream.writeByte(value ? 1 : 0);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetTemperatureTarget(float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(2);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getPowerOn() {
        return this.powerOn;
    }
}

