/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import mods.eln.generic.GenericItemUsingDamageSlot;
import mods.eln.gui.ISlotSkin;
import mods.eln.gui.SlotWithSkin;
import mods.eln.i18n.I18N;
import mods.eln.item.MachineBoosterDescriptor;
import mods.eln.misc.BasicContainer;
import mods.eln.node.INodeContainer;
import mods.eln.node.NodeBase;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ElectricalMachineContainer
extends BasicContainer
implements INodeContainer {
    private NodeBase node = null;

    public ElectricalMachineContainer(NodeBase node, EntityPlayer player, IInventory inventory, ElectricalMachineDescriptor descriptor) {
        super(player, inventory, ElectricalMachineContainer.getSlot(inventory, descriptor));
        this.node = node;
    }

    private static Slot[] getSlot(IInventory inventory, ElectricalMachineDescriptor descriptor) {
        Slot[] slots = new Slot[2 + descriptor.outStackCount];
        for (int idx = 0; idx < descriptor.outStackCount; ++idx) {
            slots[idx] = new SlotWithSkin(inventory, idx, 98 + idx * 18, 12, ISlotSkin.SlotSkin.medium);
        }
        slots[descriptor.outStackCount] = new SlotWithSkin(inventory, descriptor.outStackCount, 44, 12, ISlotSkin.SlotSkin.medium);
        slots[descriptor.outStackCount + 1] = new GenericItemUsingDamageSlot(inventory, descriptor.outStackCount + 1, 8, 12, 5, MachineBoosterDescriptor.class, ISlotSkin.SlotSkin.medium, new String[]{I18N.tr("Booster slot", new Object[0])});
        return slots;
    }

    @Override
    public NodeBase getNode() {
        return this.node;
    }

    @Override
    public int getRefreshRateDivider() {
        return 1;
    }
}

