/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.item.MachineBoosterDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ElectricalStackMachineProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineContainer;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineInventory;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalMachineElement
extends TransparentNodeElement
implements ElectricalStackMachineProcess.ElectricalStackMachineProcessObserver,
IConfigurable {
    private final TransparentNodeElementInventory inventory;
    AutoAcceptInventoryProxy booterAccepter;
    private final NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    final Resistor electricalResistor = new Resistor(this.electricalLoad, null);
    private final ElectricalStackMachineProcess slowRefreshProcess;
    private final ElectricalMachineSlowProcess slowProcess = new ElectricalMachineSlowProcess(this);
    private boolean powerOn = false;
    final ElectricalMachineDescriptor descriptor;
    public int inSlotId = 0;
    public final int outSlotId = 0;
    private int boosterSlotId = 1;
    private final VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.electricalLoad);

    public ElectricalMachineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (ElectricalMachineDescriptor)descriptor;
        this.inSlotId += this.descriptor.outStackCount;
        this.boosterSlotId += this.descriptor.outStackCount;
        this.inventory = new ElectricalMachineInventory(2 + this.descriptor.outStackCount, 64, this);
        this.booterAccepter = new AutoAcceptInventoryProxy((IInventory)this.inventory).acceptIfIncrement(this.descriptor.outStackCount + 1, 5, MachineBoosterDescriptor.class);
        this.slowRefreshProcess = new ElectricalStackMachineProcess((IInventory)this.inventory, this.inSlotId, 0, this.descriptor.outStackCount, this.electricalResistor, Double.POSITIVE_INFINITY, this.descriptor.recipe);
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.electricalResistor);
        this.slowProcessList.add(this.slowRefreshProcess);
        this.slowProcessList.add(this.slowProcess);
        this.slowRefreshProcess.setObserver(this);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 2.0, 1.0));
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.setNominalVoltage(this.descriptor.nominalU).setDestroys(exp));
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalMachineContainer(this.node, player, (IInventory)this.inventory, this.descriptor);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.electricalLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (!this.descriptor.powerLrdu(side, this.front)) {
            return 0;
        }
        return 1;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotUIP(this.electricalLoad.getVoltage(), this.electricalLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.inventoryChange(this.getInventory());
        this.connect();
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        super.inventoryChange(inventory);
        this.setPhysicalValue();
        this.needPublish();
    }

    private void setPhysicalValue() {
        int boosterCount = 0;
        ItemStack stack = this.getInventory().func_70301_a(this.boosterSlotId);
        if (stack != null) {
            boosterCount = stack.field_77994_a;
        }
        double speedUp = Math.pow(this.descriptor.boosterSpeedUp, boosterCount);
        this.slowRefreshProcess.setEfficiency(Math.pow(this.descriptor.boosterEfficiency, boosterCount));
        this.slowRefreshProcess.setSpeedUp(speedUp);
        this.descriptor.applyTo(this.electricalLoad);
        this.descriptor.applyTo(this.slowRefreshProcess);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return this.booterAccepter.take(player.func_71045_bC(), this, false, true);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        double fPower = this.electricalResistor.getPower() / this.descriptor.nominalP;
        if (this.electricalResistor.getPower() < 11.0) {
            fPower = 0.0;
        }
        if (fPower > 1.9) {
            fPower = 1.9;
        }
        try {
            stream.writeByte((int)(fPower * 64.0));
            this.serialiseItemStack(stream, this.inventory.func_70301_a(this.inSlotId));
            this.serialiseItemStack(stream, this.inventory.func_70301_a(0));
            stream.writeFloat((float)this.slowRefreshProcess.processState());
            stream.writeFloat((float)this.slowRefreshProcess.processStatePerSecond());
            this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
            stream.writeFloat((float)(this.electricalLoad.getVoltage() / this.descriptor.nominalU));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powerOn", this.powerOn);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerOn = nbt.func_74767_n("powerOn");
    }

    @Override
    public void done(ElectricalStackMachineProcess who) {
        this.needPublish();
        if (this.descriptor.endSound != null) {
            this.play(this.descriptor.endSound);
        }
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Power consumption", new Object[0]), Utils.plotPower("", this.slowRefreshProcess.getPower()));
        info.put(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.electricalLoad.getVoltage()));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Power provided", new Object[0]), Utils.plotPower("", this.electricalLoad.getCurrent() * this.electricalLoad.getVoltage()));
        }
        return info;
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (ConfigCopyToolDescriptor.readGenDescriptor(compound, "booster", (IInventory)this.inventory, this.descriptor.outStackCount + 1, invoker)) {
            this.inventoryChange((IInventory)this.inventory);
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        ConfigCopyToolDescriptor.writeGenDescriptor(compound, "booster", this.inventory.func_70301_a(this.descriptor.outStackCount + 1));
    }
}

