/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import mods.eln.sim.IProcess;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineElement;

public class ElectricalMachineSlowProcess
implements IProcess {
    private final ElectricalMachineElement element;
    private double lastPublishAt = 0.0;
    private double lastUpdate = 0.0;
    private boolean boot = true;

    public ElectricalMachineSlowProcess(ElectricalMachineElement element) {
        this.element = element;
    }

    @Override
    public void process(double time) {
        double P = this.element.electricalResistor.getPower();
        this.lastUpdate += time;
        if (!this.boot && Math.abs((P - this.lastPublishAt) / (this.lastPublishAt + 1.0)) > 0.03125 && this.lastUpdate > 0.2) {
            this.element.needPublish();
            this.lastPublishAt = P;
            this.lastUpdate = 0.0;
        }
        this.boot = false;
    }
}

