/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.electricalmachine;

import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.RecipesList;
import mods.eln.misc.UtilsClient;
import mods.eln.sim.ThermalLoadInitializer;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineDescriptor;
import mods.eln.transparentnode.electricalmachine.ElectricalMachineRender;
import net.minecraft.entity.item.EntityItem;

public class PlateMachineDescriptor
extends ElectricalMachineDescriptor {
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart rot1;
    private Obj3D.Obj3DPart rot2;

    public PlateMachineDescriptor(String name, Obj3D obj, double nominalU, double nominalP, double maximalU, ThermalLoadInitializer thermal, ElectricalCableDescriptor cable, RecipesList recipe) {
        super(name, nominalU, nominalP, maximalU, thermal, cable, recipe);
        if (obj != null) {
            this.main = obj.getPart("main");
            this.rot1 = obj.getPart("rot1");
            this.rot2 = obj.getPart("rot2");
        }
    }

    @Override
    Object newDrawHandle() {
        return new PlateMachineDescriptorHandle();
    }

    @Override
    void draw(ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
        PlateMachineDescriptorHandle handle = (PlateMachineDescriptorHandle)handleO;
        this.main.draw();
        this.rot1.draw(handle.counter, 0.0f, 0.0f, -1.0f);
        this.rot2.draw(handle.counter, 0.0f, 0.0f, 1.0f);
        UtilsClient.drawEntityItem(inEntity, -0.35f, 0.1f, 0.0, handle.itemCounter, 1.0f);
        UtilsClient.drawEntityItem(outEntity, 0.35f, 0.1f, 0.0, -handle.itemCounter + 139.0f, 1.0f);
    }

    @Override
    void refresh(float deltaT, ElectricalMachineRender render, Object handleO, EntityItem inEntity, EntityItem outEntity, float powerFactor, float processState) {
        PlateMachineDescriptorHandle handle = (PlateMachineDescriptorHandle)handleO;
        handle.interpolator.setTarget(powerFactor);
        handle.interpolator.step(deltaT);
        handle.counter += deltaT * handle.interpolator.get() * 360.0f;
        while (handle.counter >= 360.0f) {
            handle.counter -= 360.0f;
        }
        handle.itemCounter += deltaT * 90.0f;
        while (handle.itemCounter >= 360.0f) {
            handle.itemCounter -= 360.0f;
        }
    }

    @Override
    public boolean powerLrdu(Direction side, Direction front) {
        return side != front && side != front.getInverse();
    }

    class PlateMachineDescriptorHandle {
        float counter = 0.0f;
        final RcInterpolator interpolator = new RcInterpolator(0.5f);
        float itemCounter = 0.0f;

        PlateMachineDescriptorHandle() {
        }
    }
}

