/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.festive;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNode;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.comparisons.ComparisonsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.ranges.RangesKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lmods/eln/transparentnode/festive/FestiveElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "node", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getElectricalLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "loadResistor", "Lmods/eln/sim/mna/component/Resistor;", "getLoadResistor", "()Lmods/eln/sim/mna/component/Resistor;", "powerChannel", "", "getPowerChannel", "()Ljava/lang/String;", "setPowerChannel", "(Ljava/lang/String;)V", "getConnectionMask", "", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "Lmods/eln/sim/ElectricalLoad;", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "thermoMeterString", "FestiveElementProcess", "Eln"})
public final class FestiveElement
extends TransparentNodeElement {
    @NotNull
    private final NbtElectricalLoad electricalLoad;
    @NotNull
    private final Resistor loadResistor;
    @NotNull
    private String powerChannel;

    public FestiveElement(@NotNull TransparentNode node, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(node, descriptor);
        this.electricalLoad = new NbtElectricalLoad("electricalLoad");
        this.loadResistor = new Resistor(this.electricalLoad, null);
        this.powerChannel = "xmas";
        this.loadResistor.setResistance(1000.0);
        this.slowProcessList.add(new FestiveElementProcess(this));
    }

    @NotNull
    public final NbtElectricalLoad getElectricalLoad() {
        return this.electricalLoad;
    }

    @NotNull
    public final Resistor getLoadResistor() {
        return this.loadResistor;
    }

    @NotNull
    public final String getPowerChannel() {
        return this.powerChannel;
    }

    public final void setPowerChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.powerChannel = string;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "Not as warm as it could be";
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return "It probably works if you apply ~200v to the xmas wireless channel";
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 0;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public void initialize() {
        this.connect();
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            TransparentNode transparentNode = this.node;
            Intrinsics.checkNotNull(transparentNode);
            stream.writeBoolean(transparentNode.getLightValue() > 4);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R(\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lmods/eln/transparentnode/festive/FestiveElement$FestiveElementProcess;", "Lmods/eln/sim/IProcess;", "elem", "Lmods/eln/transparentnode/festive/FestiveElement;", "(Lmods/eln/transparentnode/festive/FestiveElement;)V", "bestChannelHandle", "Lmods/eln/shadow/kotlin/Pair;", "", "Lmods/eln/sixnode/lampsupply/LampSupplyElement$PowerSupplyChannelHandle;", "getBestChannelHandle", "()Lkotlin/Pair;", "setBestChannelHandle", "(Lkotlin/Pair;)V", "getElem", "()Lmods/eln/transparentnode/festive/FestiveElement;", "findBestSupply", "here", "Lmods/eln/misc/Coordinate;", "forceUpdate", "", "process", "", "time", "Eln"})
    @SourceDebugExtension(value={"SMAP\nFestiveElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FestiveElement.kt\nmods/eln/transparentnode/festive/FestiveElement$FestiveElementProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,3:102\n1045#2:105\n*S KotlinDebug\n*F\n+ 1 FestiveElement.kt\nmods/eln/transparentnode/festive/FestiveElement$FestiveElementProcess\n*L\n78#1:101\n78#1:102,3\n79#1:105\n*E\n"})
    public static final class FestiveElementProcess
    implements IProcess {
        @NotNull
        private final FestiveElement elem;
        @Nullable
        private Pair<Double, ? extends LampSupplyElement.PowerSupplyChannelHandle> bestChannelHandle;

        public FestiveElementProcess(@NotNull FestiveElement elem) {
            Intrinsics.checkNotNullParameter(elem, "elem");
            this.elem = elem;
        }

        @NotNull
        public final FestiveElement getElem() {
            return this.elem;
        }

        @Nullable
        public final Pair<Double, LampSupplyElement.PowerSupplyChannelHandle> getBestChannelHandle() {
            return this.bestChannelHandle;
        }

        public final void setBestChannelHandle(@Nullable Pair<Double, ? extends LampSupplyElement.PowerSupplyChannelHandle> pair) {
            this.bestChannelHandle = pair;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Double, LampSupplyElement.PowerSupplyChannelHandle> findBestSupply(Coordinate here, boolean forceUpdate) {
            Pair chanHand;
            void $this$mapTo$iv$iv;
            ArrayList<LampSupplyElement.PowerSupplyChannelHandle> arrayList = LampSupplyElement.channelMap.get(this.elem.getPowerChannel());
            if (arrayList == null) {
                return null;
            }
            ArrayList<LampSupplyElement.PowerSupplyChannelHandle> chanMap = arrayList;
            Pair<Double, LampSupplyElement.PowerSupplyChannelHandle> bestChanHand = this.bestChannelHandle;
            if (bestChanHand != null && !forceUpdate && chanMap.contains(bestChanHand.getSecond())) {
                return bestChanHand;
            }
            List<LampSupplyElement.PowerSupplyChannelHandle> list = LampSupplyElement.channelMap.get(this.elem.getPowerChannel());
            if (list == null || (list = CollectionsKt.filterNotNull((Iterable)list)) == null) {
                return null;
            }
            List<LampSupplyElement.PowerSupplyChannelHandle> list2 = list;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LampSupplyElement.PowerSupplyChannelHandle powerSupplyChannelHandle = (LampSupplyElement.PowerSupplyChannelHandle)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SixNode sixNode = it.element.sixNode;
                Intrinsics.checkNotNull(sixNode);
                collection.add(new Pair<Double, void>(sixNode.coordinate.trueDistanceTo(here), it));
            }
            List map = (List)destination$iv$iv;
            Iterable $this$sortedBy$iv = map;
            boolean $i$f$sortedBy = false;
            List sortedBy2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
                }
            });
            this.bestChannelHandle = chanHand = (Pair)CollectionsKt.first(sortedBy2);
            return this.bestChannelHandle;
        }

        static /* synthetic */ Pair findBestSupply$default(FestiveElementProcess festiveElementProcess, Coordinate coordinate, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return festiveElementProcess.findBestSupply(coordinate, bl);
        }

        @Override
        public void process(double time) {
            LampSupplyElement.PowerSupplyChannelHandle best;
            Pair lampSupplyList;
            TransparentNode transparentNode = this.elem.node;
            Intrinsics.checkNotNull(transparentNode);
            Pair pair = lampSupplyList = FestiveElementProcess.findBestSupply$default(this, transparentNode.coordinate, false, 2, null);
            LampSupplyElement.PowerSupplyChannelHandle powerSupplyChannelHandle = best = pair != null ? (LampSupplyElement.PowerSupplyChannelHandle)pair.getSecond() : null;
            if (best != null && best.element.getChannelState(best.id)) {
                best.element.addToRp(this.elem.getLoadResistor().getResistance());
                this.elem.getElectricalLoad().state = best.element.powerLoad.state;
            } else {
                this.elem.getElectricalLoad().state = 0.0;
            }
            double lightDouble = (double)12 * (Math.abs(this.elem.getLoadResistor().getVoltage()) - 180.0) / 20.0;
            TransparentNode transparentNode2 = this.elem.node;
            Intrinsics.checkNotNull(transparentNode2);
            transparentNode2.setLightValue(RangesKt.coerceIn((int)(lightDouble *= (double)16), 0, 15));
        }
    }
}

