/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.heatfurnace;

import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.FurnaceProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.ThermalLoadInitializerByPowerDrop;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceElement;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class HeatFurnaceDescriptor
extends TransparentNodeDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart tiroir;
    Obj3D.Obj3DPart main;
    float alphaClose;
    float alphaOpen;
    double nominalPower;
    double nominalCombustibleEnergy;
    int combustionChamberMax;
    double combustionChamberPower;
    ThermalLoadInitializerByPowerDrop thermal;
    double flameStartX;
    double flameStartY;
    double flameStartZ;
    double flameEndX;
    double flameEndY;
    double flameEndZ;
    double flameDeltaX;
    double flameDeltaY;
    double flameDeltaZ;
    double flamePopRate;

    public HeatFurnaceDescriptor(String name, String modelName, double nominalPower, double nominalCombustibleEnergy, int combustionChamberMax, double combustionChamberPower, ThermalLoadInitializerByPowerDrop thermal) {
        super(name, HeatFurnaceElement.class, HeatFurnaceRender.class);
        this.thermal = thermal;
        this.nominalCombustibleEnergy = nominalCombustibleEnergy;
        this.combustionChamberMax = combustionChamberMax;
        this.combustionChamberPower = combustionChamberPower;
        this.nominalPower = nominalPower;
        this.obj = Eln.obj.getObj(modelName);
        if (this.obj != null) {
            this.tiroir = this.obj.getPart("tiroir");
            this.main = this.obj.getPart("main");
            if (this.tiroir != null) {
                this.alphaClose = this.tiroir.getFloat("alphaClose");
                this.alphaOpen = this.tiroir.getFloat("alphaOpen");
            }
            if (this.main != null) {
                this.flameStartX = this.main.getFloat("flameStartX");
                this.flameStartY = this.main.getFloat("flameStartY");
                this.flameStartZ = this.main.getFloat("flameStartZ");
                this.flameEndX = this.main.getFloat("flameEndX");
                this.flameEndY = this.main.getFloat("flameEndY");
                this.flameEndZ = this.main.getFloat("flameEndZ");
                this.flameDeltaX = this.flameEndX - this.flameStartX;
                this.flameDeltaY = this.flameEndY - this.flameStartY;
                this.flameDeltaZ = this.flameEndZ - this.flameStartZ;
                this.flamePopRate = this.main.getFloat("flamePopRate");
            }
        }
        thermal.setMaximalPower(nominalPower);
        this.voltageLevelColor = VoltageLevelColor.Thermal;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addThermal(this.newItemStack());
    }

    public void applyTo(ThermalLoad load) {
        this.thermal.applyToThermalLoad(load);
    }

    public void applyTo(FurnaceProcess process) {
        process.nominalCombustibleEnergy = this.nominalCombustibleEnergy;
        process.nominalPower = this.nominalPower;
    }

    void draw(float tiroirFactor) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.tiroir != null) {
            this.tiroir.draw(this.alphaClose + tiroirFactor * (this.alphaOpen - this.alphaClose), 0.0f, 0.0f, 1.0f);
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(1.0f);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Generates heat when supplied with fuel.", new Object[0]));
        list.add("  " + I18N.tr("Nominal power: %1$W", Utils.plotValue(this.nominalPower)));
        list.add("  " + I18N.tr("Max. temperature: %1$\u00b0C", Utils.plotValue(this.thermal.maximumTemperature)));
    }
}

