/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.heatfurnace;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceDescriptor;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceGuiDraw;
import mods.eln.transparentnode.heatfurnace.HeatFurnaceInventory;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class HeatFurnaceRender
extends TransparentNodeElementRender {
    double temperature;
    float gainSyncValue = -1234.0f;
    float temperatureTargetSyncValue = -1234.0f;
    boolean gainSyncNew = false;
    boolean temperatureTargetSyncNew = false;
    short power;
    public boolean controleExternal;
    public boolean takeFuel;
    HeatFurnaceDescriptor descriptor;
    Coordinate coord;
    PhysicalInterpolator interpolator;
    float counter = 0.0f;
    TransparentNodeElementInventory inventory = new HeatFurnaceInventory(4, 64, this);
    boolean boot = true;
    EntityItem entityItemIn;

    public HeatFurnaceRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (HeatFurnaceDescriptor)descriptor;
        this.interpolator = new PhysicalInterpolator(0.4f, 8.0f, 0.9f, 0.2f);
        this.coord = new Coordinate(tileEntity);
    }

    @Override
    public void draw() {
        this.front.glRotateXnRef();
        this.descriptor.draw(this.interpolator.get());
        if (this.entityItemIn != null) {
            this.drawEntityItem(this.entityItemIn, -0.1, -0.3, 0.0, this.counter, 0.8f);
        }
    }

    @Override
    public void refresh(float deltaT) {
        if (!Utils.isPlayerAround(this.getTileEntity().func_145831_w(), this.coord.getAxisAlignedBB(1))) {
            this.interpolator.setTarget(0.0f);
        } else {
            this.interpolator.setTarget(1.0f);
        }
        this.interpolator.step(deltaT);
        this.counter += deltaT * 60.0f;
        if (this.counter >= 360.0f) {
            this.counter -= 360.0f;
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new HeatFurnaceGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.controleExternal = stream.readBoolean();
            this.takeFuel = stream.readBoolean();
            this.temperature = (double)stream.readShort() / 10.0;
            float readF = stream.readFloat();
            if (this.gainSyncValue != readF || this.controleExternal) {
                this.gainSyncValue = readF;
                this.gainSyncNew = true;
            }
            if (this.temperatureTargetSyncValue != (readF = stream.readFloat()) || this.controleExternal) {
                this.temperatureTargetSyncValue = readF;
                this.temperatureTargetSyncNew = true;
            }
            this.power = stream.readShort();
            this.entityItemIn = this.unserializeItemStackToEntityItem(stream, this.entityItemIn);
            if (this.boot) {
                this.coord.move(this.front);
                this.boot = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientToogleControl() {
        this.clientSendId((byte)3);
    }

    public void clientToogleTakeFuel() {
        this.clientSendId((byte)4);
    }

    public void clientSetGain(float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(1);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetTemperatureTarget(float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(2);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }
}

