/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.powercapacitor;

import mods.eln.item.DielectricItem;
import mods.eln.misc.IFunction;
import mods.eln.misc.Obj3D;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.transparentnode.powercapacitor.PowerCapacitorElement;
import mods.eln.transparentnode.powercapacitor.PowerCapacitorRender;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class PowerCapacitorDescriptor
extends TransparentNodeDescriptor {
    private Obj3D obj;
    IFunction serie;
    public double dischargeTao;

    public PowerCapacitorDescriptor(String name, Obj3D obj, IFunction serie, double dischargeTao) {
        super(name, PowerCapacitorElement.class, PowerCapacitorRender.class);
        this.serie = serie;
        this.dischargeTao = dischargeTao;
        this.obj = obj;
        if (obj != null) {
            // empty if block
        }
    }

    public double getCValue(int cableCount, double nominalDielVoltage) {
        if (cableCount == 0) {
            return 0.0;
        }
        double uTemp = nominalDielVoltage / 50.0;
        return this.serie.getValue(cableCount - 1) / uTemp / uTemp;
    }

    public double getCValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(0);
        ItemStack diel = inventory.func_70301_a(1);
        if (core == null || diel == null) {
            return this.getCValue(0, 0.0);
        }
        return this.getCValue(core.field_77994_a, this.getUNominalValue(inventory));
    }

    public double getUNominalValue(IInventory inventory) {
        ItemStack diel = inventory.func_70301_a(1);
        if (diel == null) {
            return 10000.0;
        }
        DielectricItem desc = (DielectricItem)DielectricItem.getDescriptor(diel);
        return desc.uNominal * (double)diel.field_77994_a;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
    }

    void draw() {
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.draw();
    }
}

