/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.powercapacitor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Capacitor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.BipoleVoltageWatchdog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.powercapacitor.PowerCapacitorContainer;
import mods.eln.transparentnode.powercapacitor.PowerCapacitorDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class PowerCapacitorElement
extends TransparentNodeElement {
    PowerCapacitorDescriptor descriptor;
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    Capacitor capacitor = new Capacitor(this.positiveLoad, this.negativeLoad);
    Resistor dischargeResistor = new Resistor(this.positiveLoad, this.negativeLoad);
    PunkProcess punkProcess = new PunkProcess();
    BipoleVoltageWatchdog watchdog = new BipoleVoltageWatchdog(this.capacitor);
    double stdDischargeResistor;
    boolean fromNbt = false;
    public static final byte unserializePannelAlpha = 0;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(2, 64, this);

    public PowerCapacitorElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (PowerCapacitorDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.capacitor);
        this.electricalComponentList.add(this.dischargeResistor);
        this.electricalProcessList.add(this.punkProcess);
        this.slowProcessList.add(this.watchdog);
        this.watchdog.setDestroys(new WorldExplosion(this).machineExplosion());
        this.positiveLoad.setAsMustBeFarFromInterSystem();
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.positiveLoad;
        }
        if (side == this.front.right()) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front.left()) {
            return 1;
        }
        if (side == this.front.right()) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotAmpere("I", this.capacitor.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        Eln.applySmallRs(this.positiveLoad);
        Eln.applySmallRs(this.negativeLoad);
        this.setupPhysical();
        this.connect();
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        super.inventoryChange(inventory);
        this.setupPhysical();
    }

    public void setupPhysical() {
        double eOld = this.capacitor.getEnergy();
        this.capacitor.setCoulombs(this.descriptor.getCValue((IInventory)this.inventory));
        this.stdDischargeResistor = this.descriptor.dischargeTao / this.capacitor.getCoulombs();
        this.watchdog.setNominalVoltage(this.descriptor.getUNominalValue((IInventory)this.inventory));
        this.punkProcess.eLegaliseResistor = Math.pow(this.descriptor.getUNominalValue((IInventory)this.inventory), 2.0) / 400.0;
        if (this.fromNbt) {
            this.dischargeResistor.setResistance(this.stdDischargeResistor);
            this.fromNbt = false;
        } else {
            double deltaE = this.capacitor.getEnergy() - eOld;
            this.punkProcess.eLeft += deltaE;
            if (deltaE < 0.0) {
                this.dischargeResistor.setResistance(this.stdDischargeResistor);
            } else {
                this.dischargeResistor.setResistance(this.punkProcess.eLegaliseResistor);
            }
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74780_a("punkELeft", this.punkProcess.eLeft);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.punkProcess.eLeft = nbt.func_74769_h("punkELeft");
        if (Double.isNaN(this.punkProcess.eLeft)) {
            this.punkProcess.eLeft = 0.0;
        }
        this.fromNbt = true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        return -128;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new PowerCapacitorContainer(player, (IInventory)this.inventory);
    }

    class PunkProcess
    implements IProcess {
        double eLeft = 0.0;
        double eLegaliseResistor;

        PunkProcess() {
        }

        @Override
        public void process(double time) {
            if (this.eLeft <= 0.0) {
                this.eLeft = 0.0;
                PowerCapacitorElement.this.dischargeResistor.setResistance(PowerCapacitorElement.this.stdDischargeResistor);
            } else {
                this.eLeft -= PowerCapacitorElement.this.dischargeResistor.getPower() * time;
                PowerCapacitorElement.this.dischargeResistor.setResistance(this.eLegaliseResistor);
            }
        }
    }
}

