/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.powerinductor;

import mods.eln.Eln;
import mods.eln.item.FerromagneticCoreDescriptor;
import mods.eln.misc.IFunction;
import mods.eln.misc.Obj3D;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.transparentnode.powerinductor.PowerInductorElement;
import mods.eln.transparentnode.powerinductor.PowerInductorRender;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class PowerInductorDescriptor
extends TransparentNodeDescriptor {
    private Obj3D obj;
    IFunction serie;

    public PowerInductorDescriptor(String name, Obj3D obj, IFunction serie) {
        super(name, PowerInductorElement.class, PowerInductorRender.class);
        this.serie = serie;
        this.obj = obj;
        if (obj != null) {
            // empty if block
        }
    }

    public double getlValue(int cableCount) {
        if (cableCount == 0) {
            return 0.0;
        }
        return this.serie.getValue(cableCount - 1);
    }

    public double getlValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(0);
        if (core == null) {
            return this.getlValue(0);
        }
        return this.getlValue(core.field_77994_a);
    }

    public double getRsValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(1);
        if (core == null) {
            return 1.0E9;
        }
        FerromagneticCoreDescriptor coreDescriptor = (FerromagneticCoreDescriptor)FerromagneticCoreDescriptor.getDescriptor(core);
        double coreFactor = coreDescriptor.cableMultiplicator;
        return Eln.instance.lowVoltageCableDescriptor.electricalRs * coreFactor;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
    }

    void draw() {
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.draw();
    }
}

