/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.powerinductor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Inductor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.powerinductor.PowerInductorContainer;
import mods.eln.transparentnode.powerinductor.PowerInductorDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class PowerInductorElement
extends TransparentNodeElement {
    PowerInductorDescriptor descriptor;
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    Inductor inductor = new Inductor("inductor", this.positiveLoad, this.negativeLoad);
    boolean fromNbt = false;
    public static final byte unserializePannelAlpha = 0;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(2, 64, this);

    public PowerInductorElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (PowerInductorDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.inductor);
        this.positiveLoad.setAsMustBeFarFromInterSystem();
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.positiveLoad;
        }
        if (side == this.front.right()) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front.left()) {
            return 1;
        }
        if (side == this.front.right()) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotAmpere("I", this.inductor.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.setupPhysical();
        this.connect();
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        super.inventoryChange(inventory);
        this.setupPhysical();
    }

    public void setupPhysical() {
        double rs = this.descriptor.getRsValue((IInventory)this.inventory);
        this.inductor.setInductance(this.descriptor.getlValue((IInventory)this.inventory));
        this.positiveLoad.setSerialResistance(rs);
        this.negativeLoad.setSerialResistance(rs);
        if (this.fromNbt) {
            this.fromNbt = false;
        } else {
            this.inductor.resetStates();
        }
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.fromNbt = true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        return -128;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new PowerInductorContainer(player, (IInventory)this.inventory);
    }
}

