/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import java.util.List;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.ghost.GhostGroup;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.transparentnode.solarpanel.SolarPanelElement;
import mods.eln.transparentnode.solarpanel.SolarPanelRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class SolarPanelDescriptor
extends TransparentNodeDescriptor {
    final Coordinate groundCoordinate;
    boolean basicModel;
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart panel;
    CableRenderDescriptor cableRender;
    double electricalUmax;
    double electricalPmax;
    int solarOffsetX;
    int solarOffsetY;
    int solarOffsetZ;
    double alphaMin;
    double alphaMax;
    double electricalRs;
    boolean canRotate;

    public SolarPanelDescriptor(String name, Obj3D obj, CableRenderDescriptor cableRender, GhostGroup ghostGroup, int solarOffsetX, int solarOffsetY, int solarOffsetZ, Coordinate groundCoordinate, double electricalUmax, double electricalPmax, double electricalDropFactor, double alphaMin, double alphaMax) {
        super(name, SolarPanelElement.class, SolarPanelRender.class);
        this.groundCoordinate = groundCoordinate;
        this.ghostGroup = ghostGroup;
        this.electricalRs = electricalUmax * electricalUmax * electricalDropFactor / electricalPmax / 2.0;
        this.electricalPmax = electricalPmax;
        this.solarOffsetX = solarOffsetX;
        this.solarOffsetY = solarOffsetY;
        this.solarOffsetZ = solarOffsetZ;
        this.alphaMax = alphaMax;
        this.alphaMin = alphaMin;
        this.basicModel = true;
        this.electricalUmax = electricalUmax;
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.panel = obj.getPart("panel");
        }
        this.cableRender = cableRender;
        this.canRotate = alphaMax != alphaMin;
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(electricalUmax);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    public void applyTo(ElectricalLoad load) {
        load.setSerialResistance(this.electricalRs);
    }

    public double alphaTrunk(double alpha) {
        if (alpha > this.alphaMax) {
            return this.alphaMax;
        }
        if (alpha < this.alphaMin) {
            return this.alphaMin;
        }
        return alpha;
    }

    @Override
    public Direction getFrontFromPlace(Direction side, EntityLivingBase entityLiving) {
        if (this.canRotate && this.groundCoordinate != null) {
            return Direction.ZN;
        }
        return super.getFrontFromPlace(side, entityLiving);
    }

    void draw(float alpha, Direction front) {
        front.glRotateZnRef();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.main.getFloat("offZ"));
        if (this.main != null) {
            this.main.draw();
        }
        if (this.panel != null) {
            front.glRotateZnRefInv();
            this.panel.draw(alpha, 0.0f, 0.0f, 1.0f);
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw((float)this.alphaMin, Direction.XN);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Produces power from solar radiation.", new Object[0]));
        list.add("  " + I18N.tr("Max. voltage: %1$V", Utils.plotValue(this.electricalUmax)));
        list.add("  " + I18N.tr("Max. power: %1$W", Utils.plotValue(this.electricalPmax)));
        if (this.canRotate) {
            list.add(I18N.tr("Can be geared towards the sun.", new Object[0]));
        }
    }

    public void addCollisionBoxesToList(AxisAlignedBB par5AxisAlignedBB, List list, World world, int x, int y, int z) {
        if (this.canRotate) {
            super.addCollisionBoxesToList(par5AxisAlignedBB, list, world, x, y, z);
            return;
        }
        AxisAlignedBB bb = Blocks.field_150348_b.func_149668_a(world, x, y, z);
        bb.field_72337_e -= 0.5;
        if (par5AxisAlignedBB.func_72326_a(bb)) {
            list.add(bb);
        }
    }
}

