/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.SolarTrackerDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.GhostPowerNode;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.DiodeProcess;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.PowerSourceBipole;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.solarpanel.SolarPanelContainer;
import mods.eln.transparentnode.solarpanel.SolarPanelDescriptor;
import mods.eln.transparentnode.solarpanel.SolarPannelSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class SolarPanelElement
extends TransparentNodeElement {
    SolarPanelDescriptor descriptor;
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    VoltageSource positiveSrc = new VoltageSource("posSrc", this.positiveLoad, null);
    VoltageSource negativeSrc = new VoltageSource("negSrc", this.negativeLoad, null);
    DiodeProcess diode;
    PowerSourceBipole powerSource;
    SolarPannelSlowProcess slowProcess = new SolarPannelSlowProcess(this);
    public double panelAlpha = 1.5707963267948966;
    private GhostPowerNode groundNode = null;
    public static final byte unserializePannelAlpha = 0;
    private final AutoAcceptInventoryProxy inventory = new AutoAcceptInventoryProxy((IInventory)new TransparentNodeElementInventory(1, 64, this)).acceptIfEmpty(0, SolarTrackerDescriptor.class);

    public SolarPanelElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (SolarPanelDescriptor)descriptor;
        this.grounded = false;
        this.powerSource = new PowerSourceBipole(this.positiveLoad, this.negativeLoad, this.positiveSrc, this.negativeSrc);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.positiveSrc);
        this.electricalComponentList.add(this.negativeSrc);
        this.slowProcessList.add(this.slowProcess);
    }

    @Override
    public void connectJob() {
        Eln.simulator.mna.addProcess(this.powerSource);
        super.connectJob();
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.powerSource);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (this.groundNode == null) {
            if (side == this.front.left()) {
                return this.positiveLoad;
            }
            if (side == this.front.right() && !this.grounded) {
                return this.negativeLoad;
            }
        } else {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (this.groundNode == null) {
            if (side == this.front.left()) {
                return 1;
            }
            if (side == this.front.right() && !this.grounded) {
                return 1;
            }
        } else if (side == this.front) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotUIP(this.positiveLoad.getVoltage() - this.negativeLoad.getVoltage(), this.positiveLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return "";
    }

    @Override
    public void initialize() {
        this.powerSource.setMaximumVoltage(this.descriptor.electricalUmax);
        this.powerSource.setMaximumCurrent(this.descriptor.electricalPmax / this.descriptor.electricalUmax * 1.5);
        this.descriptor.applyTo(this.positiveLoad);
        this.descriptor.applyTo(this.negativeLoad);
        if (this.descriptor.groundCoordinate != null) {
            GhostPowerNode n = new GhostPowerNode(this.node.coordinate, this.front, this.descriptor.groundCoordinate, this.negativeLoad, 1);
            n.initialize();
            this.groundNode = n;
        }
        this.connect();
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        if (this.groundNode != null) {
            this.groundNode.onBreakBlock();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return this.descriptor.canRotate && this.inventory.take(player.func_71045_bC(), this, true, false);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.powerSource.writeToNBT(nbt, "powerSource");
        nbt.func_74780_a("panelAlpha", this.panelAlpha);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerSource.readFromNBT(nbt, "powerSource");
        this.panelAlpha = nbt.func_74769_h("panelAlpha");
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.getInventory().func_70301_a(0) != null);
            stream.writeFloat((float)this.panelAlpha);
            this.node.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        try {
            switch (packetType) {
                case 0: {
                    this.panelAlpha = stream.readFloat();
                    this.needPublish();
                    break;
                }
                default: {
                    return packetType;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -128;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory.getInventory();
    }

    @Override
    public boolean hasGui() {
        return this.descriptor.canRotate;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new SolarPanelContainer(this.node, player, this.inventory.getInventory());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Sun angle", new Object[0]), Utils.plotValue(this.slowProcess.getSolarAlpha() * 57.29577951308232 - 90.0, "\u00b0"));
        info.put(I18N.tr("Panel angle", new Object[0]), Utils.plotValue(this.panelAlpha * 57.29577951308232 - 90.0, "\u00b0"));
        info.put(I18N.tr("Producing energy", new Object[0]), this.slowProcess.getSolarLight() != 0.0 ? "Yes" : "No");
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Produced power", new Object[0]), Utils.plotPower("", this.powerSource.getPower()));
        }
        return info;
    }
}

