/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.solarpanel.SolarPanelDescriptor;
import mods.eln.transparentnode.solarpanel.SolarPannelGuiDraw;
import mods.eln.transparentnode.solarpanel.SolarPannelSlowProcess;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class SolarPanelRender
extends TransparentNodeElementRender {
    public SolarPanelDescriptor descriptor;
    private CableRenderType renderPreProcess;
    RcInterpolator interpol = new RcInterpolator(1.0f);
    boolean boot = true;
    public boolean pannelAlphaSyncNew = false;
    public float pannelAlphaSyncValue = -1234.0f;
    public boolean hasTracker;
    LRDUMask eConn = new LRDUMask();
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(1, 64, this);

    public SolarPanelRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (SolarPanelDescriptor)descriptor;
    }

    @Override
    public void draw() {
        this.renderPreProcess = this.drawCable(Direction.YN, this.descriptor.cableRender, this.eConn, this.renderPreProcess);
        this.descriptor.draw((float)((double)(this.interpol.get() * 180.0f) / Math.PI - 90.0), this.front);
    }

    @Override
    public void refresh(float deltaT) {
        float alpha = !this.hasTracker ? (float)this.descriptor.alphaTrunk(this.pannelAlphaSyncValue) : (float)this.descriptor.alphaTrunk(SolarPannelSlowProcess.getSolarAlpha(this.getTileEntity().func_145831_w()));
        this.interpol.setTarget(alpha);
        if (this.boot) {
            this.boot = false;
            this.interpol.setValueFromTarget();
        }
        this.interpol.step(deltaT);
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRenderSide(@NotNull Direction side, @NotNull LRDU lrdu) {
        return this.descriptor.cableRender;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.hasTracker = stream.readBoolean();
            float pannelAlphaIncoming = stream.readFloat();
            if (pannelAlphaIncoming != this.pannelAlphaSyncValue) {
                this.pannelAlphaSyncValue = pannelAlphaIncoming;
                this.pannelAlphaSyncNew = true;
            }
            this.eConn.deserialize(stream);
            this.renderPreProcess = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetPannelAlpha(float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(0);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new SolarPannelGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }
}

