/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.solarpanel;

import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.transparentnode.solarpanel.SolarPanelContainer;
import mods.eln.transparentnode.solarpanel.SolarPanelRender;
import mods.eln.transparentnode.solarpanel.SolarPannelSlowProcess;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class SolarPannelGuiDraw
extends GuiContainerEln {
    private TransparentNodeElementInventory inventory;
    SolarPanelRender render;
    GuiVerticalTrackBar vuMeterTemperature;

    public SolarPannelGuiDraw(EntityPlayer player, IInventory inventory, SolarPanelRender render) {
        super(new SolarPanelContainer(null, player, inventory));
        this.inventory = (TransparentNodeElementInventory)inventory;
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.vuMeterTemperature = this.newGuiVerticalTrackBar(100, 8, 20, 69);
        this.vuMeterTemperature.setStepIdMax(181);
        this.vuMeterTemperature.setEnable(true);
        this.vuMeterTemperature.setRange((float)this.render.descriptor.alphaMin, (float)this.render.descriptor.alphaMax);
        this.syncVumeter();
    }

    public void syncVumeter() {
        this.vuMeterTemperature.setValue(this.render.pannelAlphaSyncValue);
        this.render.pannelAlphaSyncNew = false;
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (this.vuMeterTemperature == object) {
            this.render.clientSetPannelAlpha(this.vuMeterTemperature.getValue());
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (this.render.pannelAlphaSyncNew) {
            this.syncVumeter();
        }
        this.vuMeterTemperature.setEnable(!this.render.hasTracker);
        int sunAlpha = (int)(57.29577951308232 * SolarPannelSlowProcess.getSolarAlpha(this.render.getTileEntity().func_145831_w())) - 90;
        this.vuMeterTemperature.setComment(0, I18N.tr("Solar panel angle: %1$\u00b0", (int)(57.29577951308232 * (double)this.vuMeterTemperature.getValue()) - 90));
        if (Math.abs(sunAlpha) > 90) {
            this.vuMeterTemperature.setComment(1, I18N.tr("It is night", new Object[0]));
        } else {
            this.vuMeterTemperature.setComment(1, I18N.tr("Sun angle: %1$\u00b0", sunAlpha));
        }
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        super.postDraw(f, x, y);
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new GuiHelperContainer((GuiScreen)this, 176, 166, 8, 84);
    }
}

