/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.teleporter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.lampsocket.LightBlockEntity;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.teleporter.ITeleporter;
import mods.eln.transparentnode.teleporter.TeleporterDescriptor;
import mods.eln.transparentnode.teleporter.TeleporterPowerNode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TeleporterElement
extends TransparentNodeElement
implements ITeleporter {
    TeleporterDescriptor descriptor;
    NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    Resistor powerResistor = new Resistor(this.powerLoad, null);
    TeleporterSlowProcess slowProcess = new TeleporterSlowProcess();
    NodePeriodicPublishProcess publisher;
    public static final ArrayList<ITeleporter> teleporterList = new ArrayList();
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.powerLoad);
    Coordinate lightCoordinate;
    ArrayList<TeleporterPowerNode> powerNodeList = new ArrayList();
    String name = "Unnamed";
    String targetName = "Unnamed";
    double energyHit = 0.0;
    double energyTarget = 0.0;
    double powerCharge = 2000.0;
    public static final byte StateIdle = 0;
    public static final byte StateStart = 1;
    public static final byte StateClose = 2;
    public static final byte StateCharge = 3;
    public static final byte StateTeleport = 4;
    public static final byte StateOpen = 5;
    public static final byte StateReserved = 6;
    public static final byte StateReset = 7;
    byte state = 0;
    float timeCounter;
    boolean doorState = true;
    boolean reservateRefreshed = false;
    float processRatio = 0.0f;
    public static final byte eventNoTargetFind = 1;
    public static final byte eventMultipleoTargetFind = 2;
    public static final byte eventTargetFind = 3;
    public static final byte eventSameTarget = 4;
    public static final byte eventNotSameDimensionTarget = 5;
    public static final byte eventTargetBusy = 6;
    public static final byte eventInstablePowerSupply = 7;
    boolean imMaster = false;
    boolean startFlag = false;
    public static final byte setNameId = 1;
    public static final byte startId = 2;
    public static final byte setTargetNameId = 3;
    public static final byte setChargePowerId = 4;

    public TeleporterElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (TeleporterDescriptor)descriptor;
        this.publisher = new NodePeriodicPublishProcess(this.node, 2.0, 1.0);
        this.powerLoad.isPrivateSubSystem();
        this.electricalLoadList.add(this.powerLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        this.slowProcessList.add(this.publisher);
        teleporterList.add(this);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.setNominalVoltage(this.descriptor.cable.electricalNominalVoltage).setDestroys(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.powerLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (side == Direction.YP || side == Direction.YN) {
            return 0;
        }
        if (lrdu != LRDU.Down) {
            return 0;
        }
        return 1;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void initialize() {
        this.descriptor.cable.applyTo(this.powerLoad);
        this.powerResistor.highImpedance();
        for (Coordinate c : this.descriptor.getPowerCoordonate(this.node.coordinate.world())) {
            TeleporterPowerNode n = new TeleporterPowerNode();
            n.setElement(this);
            c.applyTransformation(this.front, this.node.coordinate);
            n.onBlockPlacedBy(c, Direction.XN, null, null);
            this.powerNodeList.add(n);
        }
        this.lightCoordinate = new Coordinate(this.descriptor.lightCoordinate);
        this.lightCoordinate.applyTransformation(this.front, this.node.coordinate);
        this.descriptor.ghostDoorClose.newRotate(this.front).eraseGeo(this.node.coordinate);
        this.descriptor.ghostDoorOpen.newRotate(this.front).plot(this.node.coordinate, this.node.coordinate, this.descriptor.getGhostGroupUuid());
        this.connect();
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        for (TeleporterPowerNode n : this.powerNodeList) {
            n.onBreakBlock();
        }
        this.powerNodeList.clear();
        this.unregister();
    }

    @Override
    public void unload() {
        super.unload();
        this.unregister();
    }

    void unregister() {
        teleporterList.remove(this);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("targetName", this.targetName);
        nbt.func_74780_a("powerCharge", this.powerCharge);
        nbt.func_74757_a("reset", this.state != 0);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.name = nbt.func_74779_i("name");
        this.targetName = nbt.func_74779_i("targetName");
        this.powerCharge = nbt.func_74769_h("powerCharge");
        if (nbt.func_74767_n("reset")) {
            this.state = (byte)7;
        }
    }

    void setState(byte state) {
        if (state != this.state) {
            this.timeCounter = 0.0f;
            switch (this.state) {
                case 3: {
                    this.powerResistor.highImpedance();
                    this.publisher.reconfigure(2.0, 1.0);
                    this.energyHit = 0.0;
                    this.processRatio = 0.0f;
                    break;
                }
                case 6: {
                    this.publisher.reconfigure(2.0, 1.0);
                    this.doorState = true;
                    this.processRatio = 0.0f;
                    break;
                }
                case 2: {
                    this.descriptor.ghostDoorOpen.newRotate(this.front).eraseGeo(this.node.coordinate);
                    break;
                }
                case 5: {
                    this.descriptor.ghostDoorClose.newRotate(this.front).eraseGeo(this.node.coordinate);
                    break;
                }
            }
            this.state = state;
            switch (this.state) {
                case 2: {
                    this.doorState = false;
                    this.descriptor.ghostDoorClose.newRotate(this.front).plot(this.node.coordinate, this.node.coordinate, this.descriptor.getGhostGroupUuid());
                    break;
                }
                case 5: {
                    this.doorState = true;
                    this.descriptor.ghostDoorOpen.newRotate(this.front).plot(this.node.coordinate, this.node.coordinate, this.descriptor.getGhostGroupUuid());
                    break;
                }
                case 3: {
                    this.powerResistor.setResistance(Math.pow(this.descriptor.cable.electricalNominalVoltage, 2.0) / this.powerCharge);
                    this.publisher.reconfigure(0.4, 0.0);
                    break;
                }
                case 6: {
                    this.publisher.reconfigure(0.4, 0.0);
                    break;
                }
            }
            Utils.println("Teleporter state=" + state);
            this.needPublish();
        }
    }

    @Override
    public boolean reservate() {
        if (this.state != 0) {
            return false;
        }
        if (this.powerLoad.getVoltage() < this.descriptor.cable.electricalNominalVoltage * 0.8) {
            return false;
        }
        this.setState((byte)6);
        this.imMaster = false;
        return true;
    }

    @Override
    public void reservateRefresh(boolean doorState, float processRatio) {
        this.reservateRefreshed = true;
        if (!this.doorState && doorState) {
            this.setState((byte)5);
        }
        if (this.doorState && !doorState) {
            this.setState((byte)2);
        }
        this.processRatio = processRatio;
    }

    int getTargetCount(String str) {
        int count = 0;
        for (ITeleporter t : teleporterList) {
            if (!t.getName().equals(str) || this.node.coordinate.dimension != t.getTeleportCoordonate().dimension) continue;
            ++count;
        }
        return count;
    }

    ITeleporter getTarget(String str) {
        ITeleporter target = null;
        for (ITeleporter t : teleporterList) {
            if (!t.getName().equals(str) || this.node.coordinate.dimension != t.getTeleportCoordonate().dimension) continue;
            if (target != null) {
                return null;
            }
            target = t;
        }
        return target;
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        switch (super.networkUnserialize(stream)) {
            case 1: {
                if (this.state != 0) break;
                try {
                    this.name = stream.readUTF();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.needPublish();
                break;
            }
            case 3: {
                if (this.state != 0) break;
                try {
                    this.targetName = stream.readUTF();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.needPublish();
                break;
            }
            case 2: {
                this.startFlag = true;
                break;
            }
            case 4: {
                if (this.state != 0) break;
                try {
                    this.powerCharge = stream.readFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.needPublish();
            }
        }
        return -128;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeUTF(this.name);
            stream.writeUTF(this.targetName);
            stream.writeFloat((float)this.powerCharge);
            stream.writeByte(this.state);
            stream.writeByte(this.doorState ? 1 : 0);
            stream.writeFloat(this.processRatio);
            stream.writeFloat((float)this.powerLoad.getVoltage());
            stream.writeFloat((float)this.energyHit);
            stream.writeFloat((float)this.energyTarget);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Coordinate getTeleportCoordonate() {
        return this.descriptor.getTeleportCoordonate(this.front, this.node.coordinate);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Destination", new Object[0]), this.targetName);
        info.put(I18N.tr("Distance", new Object[0]), Utils.plotValue(this.getTeleportCoordonate().trueDistanceTo(this.getTarget(this.targetName).getTeleportCoordonate()), "m"));
        info.put(I18N.tr("Required energy", new Object[0]), Utils.plotEnergy("", this.energyTarget));
        info.put(I18N.tr("Charge power", new Object[0]), Utils.plotPower("", this.powerCharge));
        return info;
    }

    class TeleporterSlowProcess
    implements IProcess {
        int dx;
        int dy;
        int dz;
        int blinkCounter = 0;
        int soundCounter = 0;
        String targetNameCopy = "";

        TeleporterSlowProcess() {
        }

        @Override
        public void process(double time) {
            ITeleporter target = TeleporterElement.this.getTarget(TeleporterElement.this.state == 0 ? TeleporterElement.this.targetName : this.targetNameCopy);
            if (target == null) {
                TeleporterElement.this.energyTarget = 0.0;
            } else {
                Coordinate c = TeleporterElement.this.getTeleportCoordonate();
                double distance = TeleporterElement.this.getTeleportCoordonate().trueDistanceTo(target.getTeleportCoordonate());
                AxisAlignedBB bb = TeleporterElement.this.descriptor.getBB(TeleporterElement.this.node.coordinate, TeleporterElement.this.front);
                int playerCount = c.world().func_72872_a(EntityPlayer.class, bb).size();
                int itemCount = c.world().func_72872_a(EntityItem.class, bb).size();
                int petCount = c.world().func_72872_a(EntityLivingBase.class, bb).size() - playerCount;
                TeleporterElement.this.energyTarget = 10000 + 40000 * playerCount + 5000 * petCount + 5000 * itemCount;
                TeleporterElement.this.energyTarget *= 1.0 + Math.pow(distance / 250.0, 0.5);
            }
            if (++this.blinkCounter >= 9) {
                this.blinkCounter = 0;
                if ((TeleporterElement.this.powerLoad.getVoltage() / TeleporterElement.this.descriptor.cable.electricalNominalVoltage - 0.5) * 3.0 > Math.random()) {
                    LightBlockEntity.addLight(TeleporterElement.this.lightCoordinate, 12, 11);
                }
            }
            switch (TeleporterElement.this.state) {
                case 6: {
                    if (TeleporterElement.this.reservateRefreshed) break;
                    if (!TeleporterElement.this.doorState) {
                        TeleporterElement.this.setState((byte)5);
                        break;
                    }
                    TeleporterElement.this.setState((byte)0);
                    break;
                }
                case 0: {
                    TeleporterElement.this.imMaster = false;
                    if (!TeleporterElement.this.startFlag) break;
                    this.targetNameCopy = TeleporterElement.this.targetName;
                    TeleporterElement.this.energyHit = 0.0;
                    if (this.targetNameCopy.equals(TeleporterElement.this.name)) {
                        TeleporterElement.this.sendIdToAllClient((byte)4);
                        break;
                    }
                    int count = TeleporterElement.this.getTargetCount(this.targetNameCopy);
                    if (count == 0) {
                        TeleporterElement.this.sendIdToAllClient((byte)1);
                        break;
                    }
                    if (count > 1) {
                        TeleporterElement.this.sendIdToAllClient((byte)2);
                        break;
                    }
                    if (TeleporterElement.this.powerLoad.getVoltage() < TeleporterElement.this.descriptor.cable.electricalNominalVoltage * 0.8) break;
                    ITeleporter target2 = TeleporterElement.this.getTarget(this.targetNameCopy);
                    if (!target2.reservate()) {
                        TeleporterElement.this.sendIdToAllClient((byte)6);
                        break;
                    }
                    TeleporterElement.this.sendIdToAllClient((byte)3);
                    TeleporterElement.this.imMaster = true;
                    TeleporterElement.this.setState((byte)1);
                    break;
                }
                case 1: {
                    int count = TeleporterElement.this.node.coordinate.world().func_72872_a(Entity.class, TeleporterElement.this.descriptor.getBB(TeleporterElement.this.node.coordinate, TeleporterElement.this.front)).size();
                    if (count == 0) {
                        TeleporterElement.this.timeCounter = 0.0f;
                        break;
                    }
                    TeleporterElement.this.timeCounter = (float)((double)TeleporterElement.this.timeCounter + time);
                    if (!(TeleporterElement.this.timeCounter > 2.0f)) break;
                    TeleporterElement.this.setState((byte)2);
                    break;
                }
                case 2: {
                    TeleporterElement.this.timeCounter = (float)((double)TeleporterElement.this.timeCounter + time);
                    if (!(TeleporterElement.this.timeCounter > 3.0f)) break;
                    if (TeleporterElement.this.reservateRefreshed) {
                        TeleporterElement.this.setState((byte)6);
                        break;
                    }
                    TeleporterElement.this.setState((byte)3);
                    this.soundCounter = 0;
                    break;
                }
                case 3: {
                    if (this.soundCounter++ % 18 == 0) {
                        TeleporterElement.this.play(new SoundCommand(TeleporterElement.this.descriptor.chargeSound).mulVolume(TeleporterElement.this.descriptor.chargeVolume, 1.0f));
                    }
                    if (this.targetNameCopy.equals(TeleporterElement.this.name)) {
                        TeleporterElement.this.sendIdToAllClient((byte)4);
                        TeleporterElement.this.setState((byte)5);
                        break;
                    }
                    int count = TeleporterElement.this.getTargetCount(this.targetNameCopy);
                    if (count == 0) {
                        TeleporterElement.this.sendIdToAllClient((byte)1);
                        TeleporterElement.this.setState((byte)5);
                        break;
                    }
                    if (count > 1) {
                        TeleporterElement.this.sendIdToAllClient((byte)2);
                        TeleporterElement.this.setState((byte)5);
                        break;
                    }
                    if (TeleporterElement.this.powerLoad.getVoltage() < TeleporterElement.this.descriptor.cable.electricalNominalVoltage * 0.8) {
                        TeleporterElement.this.sendIdToAllClient((byte)7);
                        AxisAlignedBB bb = TeleporterElement.this.descriptor.getBB(TeleporterElement.this.node.coordinate, TeleporterElement.this.front);
                        List list = TeleporterElement.this.node.coordinate.world().func_72872_a(Entity.class, bb);
                        for (Object o : list) {
                            Entity e = (Entity)o;
                            double failDistance = 1000.0;
                            int x = (int)(e.field_70165_t + (Math.random() * 2.0 - 1.0) * failDistance);
                            int z = (int)(e.field_70161_v + (Math.random() * 2.0 - 1.0) * failDistance);
                            int y = 20;
                            while (e.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150350_a && e.field_70170_p.func_147439_a(x, y + 1, z) != Blocks.field_150350_a) {
                                ++y;
                            }
                            Utils.serverTeleport(e, (double)x + 0.5, y, (double)z + 0.5);
                        }
                        TeleporterElement.this.setState((byte)5);
                        break;
                    }
                    ITeleporter target2 = TeleporterElement.this.getTarget(this.targetNameCopy);
                    Coordinate c = TeleporterElement.this.getTeleportCoordonate();
                    TeleporterElement.this.energyHit += TeleporterElement.this.powerResistor.getPower() * time;
                    TeleporterElement.this.processRatio = (float)(TeleporterElement.this.energyHit / TeleporterElement.this.energyTarget);
                    if (!(TeleporterElement.this.energyHit >= TeleporterElement.this.energyTarget)) break;
                    this.dx = target2.getTeleportCoordonate().x - c.x;
                    this.dy = target2.getTeleportCoordonate().y - c.y;
                    this.dz = target2.getTeleportCoordonate().z - c.z;
                    TeleporterElement.this.setState((byte)4);
                    break;
                }
                case 4: {
                    TeleporterElement.this.timeCounter = (float)((double)TeleporterElement.this.timeCounter + time);
                    if (!(TeleporterElement.this.timeCounter > 0.0f)) break;
                    AxisAlignedBB bb = TeleporterElement.this.descriptor.getBB(TeleporterElement.this.node.coordinate, TeleporterElement.this.front);
                    List list = TeleporterElement.this.node.coordinate.world().func_72872_a(Entity.class, bb);
                    for (Object o : list) {
                        Entity e = (Entity)o;
                        Utils.serverTeleport(e, e.field_70165_t + (double)this.dx, e.field_70163_u + (double)this.dy, e.field_70161_v + (double)this.dz);
                    }
                    TeleporterElement.this.setState((byte)5);
                    break;
                }
                case 5: {
                    TeleporterElement.this.timeCounter = (float)((double)TeleporterElement.this.timeCounter + time);
                    if (!(TeleporterElement.this.timeCounter > 3.0f)) break;
                    if (TeleporterElement.this.reservateRefreshed) {
                        TeleporterElement.this.setState((byte)6);
                        break;
                    }
                    TeleporterElement.this.setState((byte)0);
                    break;
                }
                case 7: {
                    TeleporterElement.this.setState((byte)0);
                }
            }
            if (TeleporterElement.this.state != 0 && TeleporterElement.this.imMaster && (target = TeleporterElement.this.getTarget(this.targetNameCopy)) != null) {
                target.reservateRefresh(TeleporterElement.this.doorState, TeleporterElement.this.processRatio);
            }
            TeleporterElement.this.reservateRefreshed = false;
            TeleporterElement.this.startFlag = false;
        }
    }
}

