/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.teleporter;

import mods.eln.gui.GuiHelper;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.GuiVerticalTrackBarHeat;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.transparentnode.teleporter.TeleporterRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class TeleporterGui
extends GuiScreenEln {
    GuiTextFieldEln name;
    GuiTextFieldEln target;
    GuiVerticalTrackBar chargePower;
    GuiVerticalTrackBarHeat chargeBar;
    GuiButton start;
    TeleporterRender render;

    public TeleporterGui(EntityPlayer player, TeleporterRender render) {
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.name = this.newGuiTextField(6, 6, 80);
        this.target = this.newGuiTextField(6, 26, 80);
        this.start = this.newGuiButton(6, 44, 80, I18N.tr("Start", new Object[0]));
        this.chargePower = this.newGuiVerticalTrackBar(92, 7, 20, 56);
        this.chargePower.setRange(2000.0f, 20000.0f);
        this.chargePower.setStepIdMax(100);
        this.chargeBar = this.newGuiVerticalTrackBarHeat(118, 7, 20, 56);
        this.chargeBar.sliderDrawEnable = false;
        this.name.func_146180_a(this.render.name);
        this.target.func_146180_a(this.render.targetName);
        this.chargePower.setValue(this.render.chargePower);
        this.name.setComment(0, I18N.tr("Transporter name", new Object[0]));
        this.target.setComment(0, I18N.tr("Destination transporter", new Object[0]));
        this.chargePower.setComment(0, I18N.tr("Power consumption:", new Object[0]));
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.start) {
            this.render.clientSendId((byte)2);
        }
        if (object == this.name) {
            this.render.clientSendString((byte)1, this.name.func_146179_b());
        }
        if (object == this.target) {
            this.render.clientSendString((byte)3, this.target.func_146179_b());
        }
        if (object == this.chargePower) {
            this.render.clientSendFloat((byte)4, this.chargePower.getValue());
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (this.render.chargePowerNew) {
            this.chargePower.setValue(this.render.chargePower);
            this.render.chargePowerNew = false;
        }
        this.chargePower.setComment(0, I18N.tr("Power consumption: %1$W", Float.valueOf(this.chargePower.getValue())));
        this.start.field_146124_l = this.render.state == 0;
        this.chargeBar.setRange(0.0f, this.render.energyTarget);
        this.chargeBar.temperatureHit = this.render.energyHit;
        this.chargeBar.setComment(0, I18N.tr("Required energy: %1$J", Float.valueOf(this.render.energyTarget)));
        this.chargeBar.setComment(1, (int)(this.render.processRatio * 100.0f) + "%");
    }

    @Override
    protected GuiHelper newHelper() {
        return new GuiHelper(this, 146, 70);
    }
}

