/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.teleporter;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.teleporter.TeleporterDescriptor;
import mods.eln.transparentnode.teleporter.TeleporterGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class TeleporterRender
extends TransparentNodeElementRender {
    TeleporterDescriptor d;
    Coordinate c;
    public static final float doorAlphaOpen = -90.0f;
    boolean doorState;
    PhysicalInterpolator doorInterpolator = new PhysicalInterpolator(0.2f, 8.0f, 5.0f, 0.0f);
    RcInterpolator processRatioInterpolator = new RcInterpolator(1.0f);
    RcInterpolator blueInterpolator = new RcInterpolator(0.5f);
    boolean[] ledState = new boolean[10];
    float counter = 0.0f;
    float ledCounter;
    boolean blink = false;
    float gyroAlpha = 0.0f;
    float voltage;
    String name;
    String targetName;
    float chargePower;
    float chargePowerLast;
    float energyHit;
    float energyTarget;
    boolean chargePowerNew;
    byte state;
    float processRatio;

    public TeleporterRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.d = (TeleporterDescriptor)descriptor;
        this.doorInterpolator.setMaxSpeed(0.3f);
        this.c = new Coordinate(tileEntity);
    }

    @Override
    public void draw() {
        Coordinate lightCoordinate = new Coordinate(this.d.lightCoordinate);
        lightCoordinate.applyTransformation(this.front, this.c);
        boolean lightEnable = this.getTileEntity().func_145831_w().func_147439_a(lightCoordinate.x, lightCoordinate.y, lightCoordinate.z) == Eln.lightBlock;
        this.front.glRotateXnRef();
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (!lightEnable) {
            this.d.door_in.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f);
            this.d.indoor_open.draw();
        }
        this.d.main.draw();
        this.d.ext_control.draw();
        this.d.ext_power.draw();
        UtilsClient.disableCulling();
        this.d.door_out.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f);
        UtilsClient.enableCulling();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.doorState) {
            UtilsClient.disableCulling();
            this.d.gyro.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f, this.gyroAlpha, -0.11746f, 0.04275f, 0.0f);
            UtilsClient.enableCulling();
        }
        UtilsClient.disableLight();
        GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.0f);
        if (!this.doorState) {
            UtilsClient.disableCulling();
            this.d.gyro.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f, this.gyroAlpha, -0.11746f, 0.04275f, 0.0f);
            UtilsClient.enableCulling();
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.0f, (float)0.4f);
            UtilsClient.enableBlend();
            this.d.gyro_alpha.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f, this.gyroAlpha, -0.11746f, 0.04275f, 0.0f);
            UtilsClient.disableBlend();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (lightEnable) {
            this.d.door_in.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f);
            this.d.indoor_open.draw();
        }
        if (this.voltage > 0.6f) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            this.d.leds[0].draw();
            this.d.leds[1].draw();
            GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
            for (int idx = 2; idx < 10; ++idx) {
                if (this.ledCounter == 0.0f && Math.random() < 0.3) {
                    boolean bl = this.ledState[idx] = !this.ledState[idx];
                }
                if (!this.ledState[idx]) continue;
                this.d.leds[idx].draw();
            }
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.0f, (float)1.0f);
            if (this.voltage > 0.875f && this.voltage < 1.2f || this.blink) {
                this.d.scr0_electrictity.draw();
            }
            this.d.scr1_cables.draw();
            this.d.scr2_transporter.draw();
            if (!this.getTileEntity().func_145831_w().func_72872_a(Entity.class, this.d.getBB(this.c, this.front)).isEmpty()) {
                this.d.scr3_userin.draw();
            }
            if (this.doorState) {
                this.d.scr5_dooropen.draw();
            } else {
                this.d.src4_doorclosed.draw();
            }
        }
        if ((double)this.processRatioInterpolator.get() > 0.005) {
            UtilsClient.enableBlend();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.blueInterpolator.get());
            this.d.indoor_closed.draw();
            this.d.door_in_charge.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f);
            this.d.whiteblur.draw(this.doorInterpolator.get() * -90.0f, 0.0f, 0.0f, 1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            UtilsClient.disableBlend();
        }
        UtilsClient.enableLight();
    }

    @Override
    public void refresh(float deltaT) {
        this.doorInterpolator.step(deltaT);
        this.processRatioInterpolator.step(deltaT);
        this.blueInterpolator.setTarget((double)this.processRatioInterpolator.get() > 0.1 && !this.doorState ? 1.0f : 0.0f);
        this.blueInterpolator.step(deltaT);
        this.counter += deltaT;
        if ((double)this.counter > 0.4) {
            this.counter = 0.0f;
            this.blink = !this.blink;
        }
        this.ledCounter += deltaT;
        if ((double)this.ledCounter > 0.1) {
            this.ledCounter = 0.0f;
        }
        this.gyroAlpha += 360.0f * deltaT * (1.0f - this.doorInterpolator.get());
        if (this.gyroAlpha >= 360.0f) {
            this.gyroAlpha -= 360.0f;
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.name = stream.readUTF();
            this.targetName = stream.readUTF();
            this.chargePower = stream.readFloat();
            this.state = stream.readByte();
            byte b = stream.readByte();
            this.doorState = (b & 1) != 0;
            this.processRatio = stream.readFloat();
            this.voltage = (float)((double)stream.readFloat() / this.d.cable.electricalNominalVoltage);
            this.energyHit = stream.readFloat();
            this.energyTarget = stream.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.chargePower != this.chargePowerLast) {
            this.chargePowerNew = true;
        }
        this.chargePowerLast = this.chargePower;
        if (this.doorState) {
            this.doorInterpolator.setTarget(1.0f);
        } else {
            this.doorInterpolator.setTarget(0.0f);
        }
        this.processRatioInterpolator.setTarget(this.processRatio);
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new TeleporterGui(player, this);
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) {
        super.serverPacketUnserialize(stream);
        try {
            stream.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }
}

